/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeBasedRollingPolicy<E>
extends RollingPolicyBase
implements TriggeringPolicy<E> {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    FileNamePattern fileNamePatternWithoutCompSuffix;
    private Compressor compressor;
    private RenameUtil renameUtil = new RenameUtil();
    Future<?> compressionFuture;
    Future<?> cleanUpFuture;
    private int maxHistory = 0;
    protected FileSize totalSizeCap = new FileSize(0L);
    private ArchiveRemover archiveRemover;
    TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedFileNamingAndTriggeringPolicy;
    boolean cleanHistoryOnStart = false;

    @Override
    public void start() {
        Object object;
        this.renameUtil.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addWarn(FNP_NOT_SET);
            this.addWarn("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
        this.fileNamePatternWithoutCompSuffix = new FileNamePattern(Compressor.computeFileNameStrWithoutCompSuffix(this.fileNamePatternStr, this.compressionMode), this.context);
        TimeBasedRollingPolicy timeBasedRollingPolicy = this;
        timeBasedRollingPolicy.addInfo("Will use the pattern " + String.valueOf(timeBasedRollingPolicy.fileNamePatternWithoutCompSuffix) + " for the active file");
        if (this.compressionMode == CompressionMode.ZIP) {
            TimeBasedRollingPolicy timeBasedRollingPolicy2 = this;
            object = timeBasedRollingPolicy2.transformFileNamePattern2ZipEntry(timeBasedRollingPolicy2.fileNamePatternStr);
            this.zipEntryFileNamePattern = new FileNamePattern((String)object, this.context);
        }
        if (this.timeBasedFileNamingAndTriggeringPolicy == null) {
            this.timeBasedFileNamingAndTriggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        }
        this.timeBasedFileNamingAndTriggeringPolicy.setContext(this.context);
        this.timeBasedFileNamingAndTriggeringPolicy.setTimeBasedRollingPolicy(this);
        this.timeBasedFileNamingAndTriggeringPolicy.start();
        if (!this.timeBasedFileNamingAndTriggeringPolicy.isStarted()) {
            this.addWarn("Subcomponent did not start. TimeBasedRollingPolicy will not start.");
            return;
        }
        if (this.maxHistory != 0) {
            this.archiveRemover = this.timeBasedFileNamingAndTriggeringPolicy.getArchiveRemover();
            this.archiveRemover.setMaxHistory(this.maxHistory);
            this.archiveRemover.setTotalSizeCap(this.totalSizeCap.getSize());
            if (this.cleanHistoryOnStart) {
                this.addInfo("Cleaning on start up");
                object = Instant.ofEpochMilli(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
                this.cleanUpFuture = this.archiveRemover.cleanAsynchronously((Instant)object);
            }
        } else if (!this.isUnboundedTotalSizeCap()) {
            TimeBasedRollingPolicy timeBasedRollingPolicy3 = this;
            timeBasedRollingPolicy3.addWarn("'maxHistory' is not set, ignoring 'totalSizeCap' option with value [" + String.valueOf(timeBasedRollingPolicy3.totalSizeCap) + "]");
        }
        super.start();
    }

    protected boolean isUnboundedTotalSizeCap() {
        return this.totalSizeCap.getSize() == 0L;
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        TimeBasedRollingPolicy timeBasedRollingPolicy = this;
        timeBasedRollingPolicy.waitForAsynchronousJobToStop(timeBasedRollingPolicy.compressionFuture, "compression");
        TimeBasedRollingPolicy timeBasedRollingPolicy2 = this;
        timeBasedRollingPolicy2.waitForAsynchronousJobToStop(timeBasedRollingPolicy2.cleanUpFuture, "clean-up");
        super.stop();
    }

    private void waitForAsynchronousJobToStop(Future<?> future, String string) {
        if (future != null) {
            try {
                future.get(30L, TimeUnit.SECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
                this.addError("Timeout while waiting for " + string + " job to finish", timeoutException);
                return;
            }
            catch (Exception exception) {
                this.addError("Unexpected exception while waiting for " + string + " job to finish", exception);
            }
        }
    }

    private String transformFileNamePattern2ZipEntry(String string) {
        string = FileFilterUtil.slashify(string);
        return FileFilterUtil.afterLastSlash(string);
    }

    public void setTimeBasedFileNamingAndTriggeringPolicy(TimeBasedFileNamingAndTriggeringPolicy<E> timeBasedFileNamingAndTriggeringPolicy) {
        this.timeBasedFileNamingAndTriggeringPolicy = timeBasedFileNamingAndTriggeringPolicy;
    }

    public TimeBasedFileNamingAndTriggeringPolicy<E> getTimeBasedFileNamingAndTriggeringPolicy() {
        return this.timeBasedFileNamingAndTriggeringPolicy;
    }

    @Override
    public void rollover() {
        Object object = this.timeBasedFileNamingAndTriggeringPolicy.getElapsedPeriodsFileName();
        String string = FileFilterUtil.afterLastSlash((String)object);
        if (this.compressionMode == CompressionMode.NONE) {
            if (this.getParentsRawFileProperty() != null) {
                this.renameUtil.rename(this.getParentsRawFileProperty(), (String)object);
            }
        } else if (this.getParentsRawFileProperty() == null) {
            String string2 = object;
            this.compressionFuture = this.compressor.asyncCompress(string2, string2, string);
        } else {
            this.compressionFuture = this.renameRawAndAsyncCompress((String)object, string);
        }
        if (this.archiveRemover != null) {
            object = Instant.ofEpochMilli(this.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime());
            this.cleanUpFuture = this.archiveRemover.cleanAsynchronously((Instant)object);
        }
    }

    Future<?> renameRawAndAsyncCompress(String string, String string2) {
        String string3 = this.getParentsRawFileProperty();
        String string4 = string + System.nanoTime() + ".tmp";
        this.renameUtil.rename(string3, string4);
        return this.compressor.asyncCompress(string4, string, string2);
    }

    @Override
    public String getActiveFileName() {
        String string = this.getParentsRawFileProperty();
        if (string != null) {
            return string;
        }
        return this.timeBasedFileNamingAndTriggeringPolicy.getCurrentPeriodsFileNameWithoutCompressionSuffix();
    }

    @Override
    public boolean isTriggeringEvent(File file, E e) {
        return this.timeBasedFileNamingAndTriggeringPolicy.isTriggeringEvent(file, e);
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void setMaxHistory(int n) {
        this.maxHistory = n;
    }

    public boolean isCleanHistoryOnStart() {
        return this.cleanHistoryOnStart;
    }

    public void setCleanHistoryOnStart(boolean bl) {
        this.cleanHistoryOnStart = bl;
    }

    public String toString() {
        return "c.q.l.core.rolling.TimeBasedRollingPolicy@" + this.hashCode();
    }

    public void setTotalSizeCap(FileSize fileSize) {
        this.addInfo("setting totalSizeCap to " + fileSize.toString());
        this.totalSizeCap = fileSize;
    }
}

