/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.encoding.BuiltInEncoding;
import org.apache.fontbox.encoding.StandardEncoding;
import org.apache.fontbox.type1.Token;
import org.apache.fontbox.type1.Token$Kind;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.type1.Type1Lexer;

final class Type1Parser {
    private static final int EEXEC_KEY = 55665;
    private static final int CHARSTRING_KEY = 4330;
    private Type1Lexer lexer;
    private Type1Font font;

    Type1Parser() {
    }

    public final Type1Font parse(byte[] byArray, byte[] byArray2) {
        this.font = new Type1Font(byArray, byArray2);
        try {
            this.parseASCII(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException);
        }
        if (byArray2.length > 0) {
            this.parseBinary(byArray2);
        }
        return this.font;
    }

    private void parseASCII(byte[] byArray) {
        Object object;
        if (byArray.length == 0) {
            throw new IOException("ASCII segment of type 1 font is empty");
        }
        if (byArray.length < 2 || byArray[0] != 37 && byArray[1] != 33) {
            throw new IOException("Invalid start of ASCII segment of type 1 font");
        }
        this.lexer = new Type1Lexer(byArray);
        if ("FontDirectory".equals(this.lexer.peekToken().getText())) {
            this.read(Token.NAME, "FontDirectory");
            this.read(Token.LITERAL);
            this.read(Token.NAME, "known");
            this.read(Token.START_PROC);
            this.readProcVoid();
            this.read(Token.START_PROC);
            this.readProcVoid();
            this.read(Token.NAME, "ifelse");
        }
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        block11: for (int i = 0; i < n && (object = this.lexer.peekToken()) != null && (((Token)object).getKind() != Token.NAME || !"currentdict".equals(((Token)object).getText()) && !"end".equals(((Token)object).getText())); ++i) {
            object = this.read(Token.LITERAL).getText();
            switch (object) {
                case "FontInfo": 
                case "Fontinfo": {
                    Type1Parser type1Parser = this;
                    type1Parser.readFontInfo(type1Parser.readSimpleDict());
                    continue block11;
                }
                case "Metrics": {
                    this.readSimpleDict();
                    continue block11;
                }
                case "Encoding": {
                    this.readEncoding();
                    continue block11;
                }
                default: {
                    this.readSimpleValue((String)object);
                }
            }
        }
        this.readMaybe(Token.NAME, "currentdict");
        this.read(Token.NAME, "end");
        this.read(Token.NAME, "currentfile");
        this.read(Token.NAME, "eexec");
    }

    private void readSimpleValue(String string) {
        List<Token> list = this.readDictValue();
        int n = -1;
        switch (string.hashCode()) {
            case 430088090: {
                if (!string.equals("FontName")) break;
                n = 0;
                break;
            }
            case 644005016: {
                if (!string.equals("PaintType")) break;
                n = 1;
                break;
            }
            case 430289993: {
                if (!string.equals("FontType")) break;
                n = 2;
                break;
            }
            case 969389328: {
                if (!string.equals("FontMatrix")) break;
                n = 3;
                break;
            }
            case 429700888: {
                if (!string.equals("FontBBox")) break;
                n = 4;
                break;
            }
            case -229816116: {
                if (!string.equals("UniqueID")) break;
                n = 5;
                break;
            }
            case -703032754: {
                if (!string.equals("StrokeWidth")) break;
                n = 6;
                break;
            }
            case 69601: {
                if (!string.equals("FID")) break;
                n = 7;
            }
        }
        switch (n) {
            case 0: {
                this.font.fontName = list.get(0).getText();
                return;
            }
            case 1: {
                this.font.paintType = list.get(0).intValue();
                return;
            }
            case 2: {
                this.font.fontType = list.get(0).intValue();
                return;
            }
            case 3: {
                this.font.fontMatrix = this.arrayToNumbers(list);
                return;
            }
            case 4: {
                this.font.fontBBox = this.arrayToNumbers(list);
                return;
            }
            case 5: {
                this.font.uniqueID = list.get(0).intValue();
                return;
            }
            case 6: {
                this.font.strokeWidth = list.get(0).floatValue();
                return;
            }
            case 7: {
                this.font.fontID = list.get(0).getText();
            }
        }
    }

    private void readEncoding() {
        if (this.lexer.peekKind(Token.NAME)) {
            String string = this.lexer.nextToken().getText();
            if (!string.equals("StandardEncoding")) {
                throw new IOException("Unknown encoding: " + string);
            }
            this.font.encoding = StandardEncoding.INSTANCE;
            this.readMaybe(Token.NAME, "readonly");
            this.read(Token.NAME, "def");
            return;
        }
        this.read(Token.INTEGER).intValue();
        this.readMaybe(Token.NAME, "array");
        while (!this.lexer.peekKind(Token.NAME) || !this.lexer.peekToken().getText().equals("dup") && !this.lexer.peekToken().getText().equals("readonly") && !this.lexer.peekToken().getText().equals("def")) {
            if (this.lexer.nextToken() != null) continue;
            throw new IOException("Incomplete data while reading encoding of type 1 font");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while (this.lexer.peekKind(Token.NAME) && this.lexer.peekToken().getText().equals("dup")) {
            this.read(Token.NAME, "dup");
            int n = this.read(Token.INTEGER).intValue();
            String string = this.read(Token.LITERAL).getText();
            this.read(Token.NAME, "put");
            hashMap.put(n, string);
        }
        this.font.encoding = new BuiltInEncoding(hashMap);
        this.readMaybe(Token.NAME, "readonly");
        this.read(Token.NAME, "def");
    }

    private List<Number> arrayToNumbers(List<Token> list) {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        int n = list.size() - 1;
        for (int i = 1; i < n; ++i) {
            Token token = list.get(i);
            if (token.getKind() == Token.REAL) {
                arrayList.add(Float.valueOf(token.floatValue()));
                continue;
            }
            if (token.getKind() == Token.INTEGER) {
                arrayList.add(token.intValue());
                continue;
            }
            throw new IOException("Expected INTEGER or REAL but got " + token + " at array position " + i);
        }
        return arrayList;
    }

    private void readFontInfo(Map<String, List<Token>> object) {
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            List object2 = (List)entry.getValue();
            int n = -1;
            switch (string.hashCode()) {
                case 351608024: {
                    if (!string.equals("version")) break;
                    n = 0;
                    break;
                }
                case -1955822856: {
                    if (!string.equals("Notice")) break;
                    n = 1;
                    break;
                }
                case 1395496410: {
                    if (!string.equals("FullName")) break;
                    n = 2;
                    break;
                }
                case -1502948305: {
                    if (!string.equals("FamilyName")) break;
                    n = 3;
                    break;
                }
                case -1707725160: {
                    if (!string.equals("Weight")) break;
                    n = 4;
                    break;
                }
                case -2037328797: {
                    if (!string.equals("ItalicAngle")) break;
                    n = 5;
                    break;
                }
                case -429952778: {
                    if (!string.equals("isFixedPitch")) break;
                    n = 6;
                    break;
                }
                case 425555957: {
                    if (!string.equals("UnderlinePosition")) break;
                    n = 7;
                    break;
                }
                case 1887629864: {
                    if (!string.equals("UnderlineThickness")) break;
                    n = 8;
                }
            }
            switch (n) {
                case 0: {
                    this.font.version = ((Token)object2.get(0)).getText();
                    break;
                }
                case 1: {
                    this.font.notice = ((Token)object2.get(0)).getText();
                    break;
                }
                case 2: {
                    this.font.fullName = ((Token)object2.get(0)).getText();
                    break;
                }
                case 3: {
                    this.font.familyName = ((Token)object2.get(0)).getText();
                    break;
                }
                case 4: {
                    this.font.weight = ((Token)object2.get(0)).getText();
                    break;
                }
                case 5: {
                    this.font.italicAngle = ((Token)object2.get(0)).floatValue();
                    break;
                }
                case 6: {
                    this.font.isFixedPitch = ((Token)object2.get(0)).booleanValue();
                    break;
                }
                case 7: {
                    this.font.underlinePosition = ((Token)object2.get(0)).floatValue();
                    break;
                }
                case 8: {
                    this.font.underlineThickness = ((Token)object2.get(0)).floatValue();
                }
            }
        }
    }

    private Map<String, List<Token>> readSimpleDict() {
        HashMap<String, List<Token>> hashMap = new HashMap<String, List<Token>>();
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        for (int i = 0; i < n && this.lexer.peekToken() != null; ++i) {
            if (this.lexer.peekKind(Token.NAME) && !this.lexer.peekToken().getText().equals("end")) {
                this.read(Token.NAME);
            }
            if (this.lexer.peekToken() == null || this.lexer.peekKind(Token.NAME) && this.lexer.peekToken().getText().equals("end")) break;
            String string = this.read(Token.LITERAL).getText();
            List<Token> list = this.readDictValue();
            hashMap.put(string, list);
        }
        this.read(Token.NAME, "end");
        this.readMaybe(Token.NAME, "readonly");
        this.read(Token.NAME, "def");
        return hashMap;
    }

    private List<Token> readDictValue() {
        List<Token> list = this.readValue();
        this.readDef();
        return list;
    }

    private List<Token> readValue() {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = this.lexer.nextToken();
        if (this.lexer.peekToken() == null) {
            return arrayList;
        }
        arrayList.add(token);
        if (token.getKind() == Token.START_ARRAY) {
            int n = 1;
            do {
                if (this.lexer.peekToken() == null) {
                    return arrayList;
                }
                if (this.lexer.peekKind(Token.START_ARRAY)) {
                    ++n;
                }
                token = this.lexer.nextToken();
                arrayList.add(token);
            } while (token.getKind() != Token.END_ARRAY || --n != 0);
        } else if (token.getKind() == Token.START_PROC) {
            arrayList.addAll(this.readProc());
        } else if (token.getKind() == Token.START_DICT) {
            this.read(Token.END_DICT);
            return arrayList;
        }
        this.readPostScriptWrapper(arrayList);
        return arrayList;
    }

    private void readPostScriptWrapper(List<Token> list) {
        if (this.lexer.peekToken() == null) {
            throw new IOException("Missing start token for the system dictionary");
        }
        if ("systemdict".equals(this.lexer.peekToken().getText())) {
            this.read(Token.NAME, "systemdict");
            this.read(Token.LITERAL, "internaldict");
            this.read(Token.NAME, "known");
            this.read(Token.START_PROC);
            this.readProcVoid();
            this.read(Token.START_PROC);
            this.readProcVoid();
            this.read(Token.NAME, "ifelse");
            this.read(Token.START_PROC);
            this.read(Token.NAME, "pop");
            list.clear();
            list.addAll(this.readValue());
            this.read(Token.END_PROC);
            this.read(Token.NAME, "if");
        }
    }

    private List<Token> readProc() {
        Token token;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = 1;
        do {
            if (this.lexer.peekToken() == null) {
                throw new IOException("Malformed procedure: missing token");
            }
            if (this.lexer.peekKind(Token.START_PROC)) {
                ++n;
            }
            token = this.lexer.nextToken();
            arrayList.add(token);
        } while (token.getKind() != Token.END_PROC || --n != 0);
        token = this.readMaybe(Token.NAME, "executeonly");
        if (token != null) {
            arrayList.add(token);
        }
        return arrayList;
    }

    private void readProcVoid() {
        Token token;
        int n = 1;
        do {
            if (this.lexer.peekToken() == null) {
                throw new IOException("Malformed procedure: missing token");
            }
            if (!this.lexer.peekKind(Token.START_PROC)) continue;
            ++n;
        } while ((token = this.lexer.nextToken()).getKind() != Token.END_PROC || --n != 0);
        this.readMaybe(Token.NAME, "executeonly");
    }

    private void parseBinary(byte[] object) {
        if (this.isBinary((byte[])object)) {
            object = this.decrypt((byte[])object, 55665, 4);
        } else {
            Type1Parser type1Parser = this;
            object = type1Parser.decrypt(type1Parser.hexToBinary((byte[])object), 55665, 4);
        }
        this.lexer = new Type1Lexer((byte[])object);
        object = this.lexer.peekToken();
        while (object != null && !"Private".equals(((Token)object).getText())) {
            this.lexer.nextToken();
            object = this.lexer.peekToken();
        }
        if (object == null) {
            throw new IOException("/Private token not found");
        }
        this.read(Token.LITERAL, "Private");
        int n = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.readMaybe(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        int n2 = 4;
        block17: for (int i = 0; i < n && this.lexer.peekKind(Token.LITERAL); ++i) {
            String string;
            switch (string = this.read(Token.LITERAL).getText()) {
                case "Subrs": {
                    this.readSubrs(n2);
                    continue block17;
                }
                case "OtherSubrs": {
                    this.readOtherSubrs();
                    continue block17;
                }
                case "lenIV": {
                    n2 = this.readDictValue().get(0).intValue();
                    continue block17;
                }
                case "ND": {
                    this.read(Token.START_PROC);
                    this.readMaybe(Token.NAME, "noaccess");
                    this.read(Token.NAME, "def");
                    this.read(Token.END_PROC);
                    this.readMaybe(Token.NAME, "executeonly");
                    this.readMaybe(Token.NAME, "readonly");
                    this.read(Token.NAME, "def");
                    continue block17;
                }
                case "NP": {
                    this.read(Token.START_PROC);
                    this.readMaybe(Token.NAME, "noaccess");
                    this.read(Token.NAME);
                    this.read(Token.END_PROC);
                    this.readMaybe(Token.NAME, "executeonly");
                    this.readMaybe(Token.NAME, "readonly");
                    this.read(Token.NAME, "def");
                    continue block17;
                }
                case "RD": {
                    this.read(Token.START_PROC);
                    this.readProcVoid();
                    this.readMaybe(Token.NAME, "bind");
                    this.readMaybe(Token.NAME, "executeonly");
                    this.readMaybe(Token.NAME, "readonly");
                    this.read(Token.NAME, "def");
                    continue block17;
                }
                default: {
                    this.readPrivate(string, this.readDictValue());
                }
            }
        }
        while (!this.lexer.peekKind(Token.LITERAL) || !this.lexer.peekToken().getText().equals("CharStrings")) {
            if (this.lexer.nextToken() != null) continue;
            throw new IOException("Missing 'CharStrings' dictionary in type 1 font");
        }
        this.read(Token.LITERAL, "CharStrings");
        this.readCharStrings(n2);
    }

    private void readPrivate(String string, List<Token> list) {
        int n = -1;
        switch (string.hashCode()) {
            case 2027383356: {
                if (!string.equals("BlueValues")) break;
                n = 0;
                break;
            }
            case 1784230473: {
                if (!string.equals("OtherBlues")) break;
                n = 1;
                break;
            }
            case 642496053: {
                if (!string.equals("FamilyBlues")) break;
                n = 2;
                break;
            }
            case -1030363955: {
                if (!string.equals("FamilyOtherBlues")) break;
                n = 3;
                break;
            }
            case -352964368: {
                if (!string.equals("BlueScale")) break;
                n = 4;
                break;
            }
            case -352807896: {
                if (!string.equals("BlueShift")) break;
                n = 5;
                break;
            }
            case -427397143: {
                if (!string.equals("BlueFuzz")) break;
                n = 6;
                break;
            }
            case 80206418: {
                if (!string.equals("StdHW")) break;
                n = 7;
                break;
            }
            case 80206852: {
                if (!string.equals("StdVW")) break;
                n = 8;
                break;
            }
            case -1043134379: {
                if (!string.equals("StemSnapH")) break;
                n = 9;
                break;
            }
            case -1043134365: {
                if (!string.equals("StemSnapV")) break;
                n = 10;
                break;
            }
            case -763499536: {
                if (!string.equals("ForceBold")) break;
                n = 11;
                break;
            }
            case 364444135: {
                if (!string.equals("LanguageGroup")) break;
                n = 12;
            }
        }
        switch (n) {
            case 0: {
                this.font.blueValues = this.arrayToNumbers(list);
                return;
            }
            case 1: {
                this.font.otherBlues = this.arrayToNumbers(list);
                return;
            }
            case 2: {
                this.font.familyBlues = this.arrayToNumbers(list);
                return;
            }
            case 3: {
                this.font.familyOtherBlues = this.arrayToNumbers(list);
                return;
            }
            case 4: {
                this.font.blueScale = list.get(0).floatValue();
                return;
            }
            case 5: {
                this.font.blueShift = list.get(0).intValue();
                return;
            }
            case 6: {
                this.font.blueFuzz = list.get(0).intValue();
                return;
            }
            case 7: {
                this.font.stdHW = this.arrayToNumbers(list);
                return;
            }
            case 8: {
                this.font.stdVW = this.arrayToNumbers(list);
                return;
            }
            case 9: {
                this.font.stemSnapH = this.arrayToNumbers(list);
                return;
            }
            case 10: {
                this.font.stemSnapV = this.arrayToNumbers(list);
                return;
            }
            case 11: {
                this.font.forceBold = list.get(0).booleanValue();
                return;
            }
            case 12: {
                this.font.languageGroup = list.get(0).intValue();
            }
        }
    }

    private void readSubrs(int n) {
        int n2;
        int n3 = this.read(Token.INTEGER).intValue();
        for (n2 = 0; n2 < n3; ++n2) {
            this.font.subrs.add(null);
        }
        this.read(Token.NAME, "array");
        for (n2 = 0; n2 < n3 && this.lexer.peekToken() != null && this.lexer.peekKind(Token.NAME) && this.lexer.peekToken().getText().equals("dup"); ++n2) {
            this.read(Token.NAME, "dup");
            Token token = this.read(Token.INTEGER);
            this.read(Token.INTEGER);
            Token token2 = this.read(Token.CHARSTRING);
            int n4 = token.intValue();
            if (n4 < this.font.subrs.size()) {
                this.font.subrs.set(n4, this.decrypt(token2.getData(), 4330, n));
            }
            this.readPut();
        }
        this.readDef();
    }

    private void readOtherSubrs() {
        if (this.lexer.peekToken() == null) {
            throw new IOException("Missing start token of OtherSubrs procedure");
        }
        if (this.lexer.peekKind(Token.START_ARRAY)) {
            this.readValue();
        } else {
            int n = this.read(Token.INTEGER).intValue();
            this.read(Token.NAME, "array");
            for (int i = 0; i < n; ++i) {
                this.read(Token.NAME, "dup");
                this.read(Token.INTEGER);
                this.readValue();
                this.readPut();
            }
        }
        this.readDef();
    }

    private void readCharStrings(int n) {
        int n2 = this.read(Token.INTEGER).intValue();
        this.read(Token.NAME, "dict");
        this.read(Token.NAME, "dup");
        this.read(Token.NAME, "begin");
        for (int i = 0; !(i >= n2 || this.lexer.peekToken() == null || this.lexer.peekKind(Token.NAME) && this.lexer.peekToken().getText().equals("end")); ++i) {
            String string = this.read(Token.LITERAL).getText();
            this.read(Token.INTEGER);
            Token token = this.read(Token.CHARSTRING);
            this.font.charstrings.put(string, this.decrypt(token.getData(), 4330, n));
            this.readDef();
        }
        this.read(Token.NAME, "end");
    }

    private void readDef() {
        this.readMaybe(Token.NAME, "readonly");
        this.readMaybe(Token.NAME, "noaccess");
        Token token = this.read(Token.NAME);
        switch (token.getText()) {
            case "ND": 
            case "|-": {
                return;
            }
            case "noaccess": {
                token = this.read(Token.NAME);
            }
        }
        if (token.getText().equals("def")) {
            return;
        }
        throw new IOException("Found " + token + " but expected ND");
    }

    private void readPut() {
        this.readMaybe(Token.NAME, "readonly");
        Token token = this.read(Token.NAME);
        switch (token.getText()) {
            case "NP": 
            case "|": {
                return;
            }
            case "noaccess": {
                token = this.read(Token.NAME);
            }
        }
        if (token.getText().equals("put")) {
            return;
        }
        throw new IOException("Found " + token + " but expected NP");
    }

    private Token read(Token$Kind token$Kind) {
        Token token = this.lexer.nextToken();
        if (token == null || token.getKind() != token$Kind) {
            throw new IOException("Found " + token + " but expected " + (Object)((Object)token$Kind));
        }
        return token;
    }

    private void read(Token$Kind object, String string) {
        if (((Token)(object = this.read((Token$Kind)((Object)object)))).getText() == null || !((Token)object).getText().equals(string)) {
            throw new IOException("Found " + object + " but expected " + string);
        }
    }

    private Token readMaybe(Token$Kind token$Kind, String string) {
        if (this.lexer.peekKind(token$Kind) && this.lexer.peekToken().getText().equals(string)) {
            return this.lexer.nextToken();
        }
        return null;
    }

    private byte[] decrypt(byte[] byArray, int n, int n2) {
        if (n2 == -1) {
            return byArray;
        }
        if (byArray.length == 0 || n2 > byArray.length) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            int n4 = n3 ^ n >> 8;
            if (i >= n2) {
                byArray2[i - n2] = (byte)n4;
            }
            n = (n3 + n) * 52845 + 22719 & 0xFFFF;
        }
        return byArray2;
    }

    private boolean isBinary(byte[] byArray) {
        if (byArray.length < 4) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            byte by = byArray[i];
            if (by == 10 || by == 13 || by == 32 || by == 9 || Character.digit((char)by, 16) != -1) continue;
            return true;
        }
        return false;
    }

    private byte[] hexToBinary(byte[] byArray) {
        int n;
        int n2 = 0;
        byte[] byArray2 = byArray;
        int n3 = byArray.length;
        for (n = 0; n < n3; ++n) {
            byte by = byArray2[n];
            if (Character.digit((char)by, 16) == -1) continue;
            ++n2;
        }
        byArray2 = new byte[n2 / 2];
        n3 = 0;
        n = -1;
        byte[] byArray3 = byArray;
        int n4 = byArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = byArray3[n2];
            if ((n5 = Character.digit((char)n5, 16)) == -1) continue;
            if (n == -1) {
                n = n5;
                continue;
            }
            byArray2[n3++] = (byte)((n << 4) + n5);
            n = -1;
        }
        return byArray2;
    }
}

