/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef$HBITMAP;
import com.sun.jna.platform.win32.WinDef$HDC;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinDef$RECT;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinGDI$BITMAPINFO;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class GDI32Util {
    private static final DirectColorModel SCREENSHOT_COLOR_MODEL = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private static final int[] SCREENSHOT_BAND_MASKS = new int[]{SCREENSHOT_COLOR_MODEL.getRedMask(), SCREENSHOT_COLOR_MODEL.getGreenMask(), SCREENSHOT_COLOR_MODEL.getBlueMask()};

    public static BufferedImage getScreenshot(WinDef$HWND winDef$HWND) {
        Object object;
        Object object2;
        Object object3 = new WinDef$RECT();
        if (!User32.INSTANCE.GetWindowRect(winDef$HWND, (WinDef$RECT)((Object)object3))) {
            throw new Win32Exception(Native.getLastError());
        }
        object3 = object3.toRectangle();
        int n = ((Rectangle)object3).width;
        int n2 = ((Rectangle)object3).height;
        if (n == 0 || n2 == 0) {
            throw new IllegalStateException("Window width and/or height were 0 even though GetWindowRect did not appear to fail.");
        }
        WinDef$HDC winDef$HDC = User32.INSTANCE.GetDC(winDef$HWND);
        if (winDef$HDC == null) {
            throw new Win32Exception(Native.getLastError());
        }
        Object object4 = null;
        WinDef$HDC winDef$HDC2 = null;
        WinDef$HBITMAP winDef$HBITMAP = null;
        WinNT$HANDLE winNT$HANDLE = null;
        BufferedImage bufferedImage = null;
        try {
            winDef$HDC2 = GDI32.INSTANCE.CreateCompatibleDC(winDef$HDC);
            if (winDef$HDC2 == null) {
                throw new Win32Exception(Native.getLastError());
            }
            winDef$HBITMAP = GDI32.INSTANCE.CreateCompatibleBitmap(winDef$HDC, n, n2);
            if (winDef$HBITMAP == null) {
                throw new Win32Exception(Native.getLastError());
            }
            winNT$HANDLE = GDI32.INSTANCE.SelectObject(winDef$HDC2, winDef$HBITMAP);
            if (winNT$HANDLE == null) {
                throw new Win32Exception(Native.getLastError());
            }
            if (!GDI32.INSTANCE.BitBlt(winDef$HDC2, 0, 0, n, n2, winDef$HDC, 0, 0, 0xCC0020)) {
                throw new Win32Exception(Native.getLastError());
            }
            WinGDI$BITMAPINFO winGDI$BITMAPINFO = new WinGDI$BITMAPINFO();
            new WinGDI$BITMAPINFO().bmiHeader.biWidth = n;
            winGDI$BITMAPINFO.bmiHeader.biHeight = -n2;
            winGDI$BITMAPINFO.bmiHeader.biPlanes = 1;
            winGDI$BITMAPINFO.bmiHeader.biBitCount = (short)32;
            winGDI$BITMAPINFO.bmiHeader.biCompression = 0;
            object2 = new Memory((long)(n * n2 << 2));
            int n3 = GDI32.INSTANCE.GetDIBits(winDef$HDC, winDef$HBITMAP, 0, n2, (Pointer)object2, winGDI$BITMAPINFO, 0);
            if (n3 == 0 || n3 == 87) {
                throw new Win32Exception(Native.getLastError());
            }
            n3 = n * n2;
            object = new DataBufferInt(object2.getIntArray(0L, n3), n3);
            WritableRaster writableRaster = Raster.createPackedRaster((DataBuffer)object, n, n2, n, SCREENSHOT_BAND_MASKS, null);
            bufferedImage = new BufferedImage(SCREENSHOT_COLOR_MODEL, writableRaster, false, null);
        }
        catch (Win32Exception win32Exception) {
            Object object5 = win32Exception;
            object4 = win32Exception;
            if (winNT$HANDLE != null && ((object5 = GDI32.INSTANCE.SelectObject(winDef$HDC2, winNT$HANDLE)) == null || WinGDI.HGDI_ERROR.equals(object5))) {
                Win32Exception win32Exception2 = new Win32Exception(Native.getLastError());
                win32Exception2.addSuppressedReflected((Throwable)object4);
                object4 = win32Exception2;
            }
            if (winDef$HBITMAP != null && !GDI32.INSTANCE.DeleteObject(winDef$HBITMAP)) {
                object5 = new Win32Exception(Native.getLastError());
                object5.addSuppressedReflected((Throwable)object4);
                object4 = object5;
            }
            if (winDef$HDC2 != null && !GDI32.INSTANCE.DeleteDC(winDef$HDC2)) {
                object5 = new Win32Exception(Native.getLastError());
                object5.addSuppressedReflected((Throwable)object4);
                object4 = object5;
            }
            if (winDef$HDC != null && 0 == User32.INSTANCE.ReleaseDC(winDef$HWND, winDef$HDC)) {
                throw new IllegalStateException("Device context did not release properly.");
            }
        }
        catch (Throwable throwable) {
            Object object6;
            if (winNT$HANDLE != null && ((object6 = GDI32.INSTANCE.SelectObject(winDef$HDC2, winNT$HANDLE)) == null || WinGDI.HGDI_ERROR.equals(object6))) {
                object6 = new Win32Exception(Native.getLastError());
                if (object4 != null) {
                    ((Win32Exception)((Object)object6)).addSuppressedReflected((Throwable)object4);
                }
                object4 = object6;
            }
            if (winDef$HBITMAP != null && !GDI32.INSTANCE.DeleteObject(winDef$HBITMAP)) {
                Win32Exception win32Exception = new Win32Exception(Native.getLastError());
                if (object4 != null) {
                    win32Exception.addSuppressedReflected((Throwable)object4);
                }
                object4 = win32Exception;
            }
            if (winDef$HDC2 != null && !GDI32.INSTANCE.DeleteDC(winDef$HDC2)) {
                Win32Exception win32Exception = new Win32Exception(Native.getLastError());
                if (object4 != null) {
                    win32Exception.addSuppressedReflected((Throwable)object4);
                }
            }
            if (winDef$HDC != null && 0 == User32.INSTANCE.ReleaseDC(winDef$HWND, winDef$HDC)) {
                throw new IllegalStateException("Device context did not release properly.");
            }
            throw throwable;
        }
        if (winNT$HANDLE != null && ((object = GDI32.INSTANCE.SelectObject(winDef$HDC2, winNT$HANDLE)) == null || WinGDI.HGDI_ERROR.equals(object))) {
            object2 = new Win32Exception(Native.getLastError());
            if (object4 != null) {
                ((Win32Exception)((Object)object2)).addSuppressedReflected((Throwable)object4);
            }
            object4 = object2;
        }
        if (winDef$HBITMAP != null && !GDI32.INSTANCE.DeleteObject(winDef$HBITMAP)) {
            object = new Win32Exception(Native.getLastError());
            if (object4 != null) {
                ((Win32Exception)((Object)object)).addSuppressedReflected((Throwable)object4);
            }
            object4 = object;
        }
        if (winDef$HDC2 != null && !GDI32.INSTANCE.DeleteDC(winDef$HDC2)) {
            object = new Win32Exception(Native.getLastError());
            if (object4 != null) {
                ((Win32Exception)((Object)object)).addSuppressedReflected((Throwable)object4);
            }
            object4 = object;
        }
        if (winDef$HDC != null && 0 == User32.INSTANCE.ReleaseDC(winDef$HWND, winDef$HDC)) {
            throw new IllegalStateException("Device context did not release properly.");
        }
        if (object4 != null) {
            throw object4;
        }
        return bufferedImage;
    }
}

