/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sqlite.BusyHandler;
import org.sqlite.Collation;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteCommitListener;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import org.sqlite.SQLiteUpdateListener;
import org.sqlite.SQLiteUpdateListener$Type;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB$ProgressObserver;
import org.sqlite.core.SafeStmtPtr;

public abstract class DB
implements Codes {
    private final String url;
    private final String fileName;
    private final SQLiteConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(true);
    volatile SafeStmtPtr begin;
    volatile SafeStmtPtr commit;
    private final Set<SafeStmtPtr> stmts = ConcurrentHashMap.newKeySet();
    private final Set<SQLiteUpdateListener> updateListeners = new HashSet<SQLiteUpdateListener>();
    private final Set<SQLiteCommitListener> commitListeners = new HashSet<SQLiteCommitListener>();

    public DB(String string, String string2, SQLiteConfig sQLiteConfig) {
        this.url = string;
        this.fileName = string2;
        this.config = sQLiteConfig;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public SQLiteConfig getConfig() {
        return this.config;
    }

    public abstract void interrupt();

    public abstract void busy_timeout(int var1);

    public abstract void busy_handler(BusyHandler var1);

    abstract String errmsg();

    public abstract String libversion();

    public abstract long changes();

    public abstract long total_changes();

    public abstract int shared_cache(boolean var1);

    public abstract int enable_load_extension(boolean var1);

    public final synchronized void exec(String object, boolean bl) {
        object = this.prepare((String)object);
        try {
            int n = ((SafeStmtPtr)object).safeRunInt(DB::step);
            switch (n) {
                case 101: {
                    this.ensureAutoCommit(bl);
                    return;
                }
                case 100: {
                    return;
                }
            }
            this.throwex(n);
            return;
        }
        finally {
            ((SafeStmtPtr)object).close();
        }
    }

    public final synchronized void open(String string, int n) {
        this._open(string, n);
        this.closed.set(false);
        if (this.fileName.startsWith("file:") && !this.fileName.contains("cache=")) {
            DB dB = this;
            dB.shared_cache(dB.config.isEnabledSharedCache());
        }
        DB dB = this;
        dB.enable_load_extension(dB.config.isEnabledLoadExtension());
        DB dB2 = this;
        dB2.busy_timeout(dB2.config.getBusyTimeout());
    }

    public final synchronized void close() {
        for (SafeStmtPtr safeStmtPtr : this.stmts) {
            safeStmtPtr.close();
        }
        if (this.begin != null) {
            this.begin.close();
        }
        if (this.commit != null) {
            this.commit.close();
        }
        this.closed.set(true);
        this._close();
    }

    public final synchronized void prepare(CoreStatement coreStatement) {
        if (coreStatement.sql == null) {
            throw new NullPointerException();
        }
        if (coreStatement.pointer != null) {
            coreStatement.pointer.close();
        }
        coreStatement.pointer = this.prepare(coreStatement.sql);
        boolean bl = this.stmts.add(coreStatement.pointer);
        if (!bl) {
            throw new IllegalStateException("Already added pointer to statements set");
        }
    }

    public synchronized int finalize(SafeStmtPtr safeStmtPtr, long l) {
        try {
            int n = this.finalize(l);
            return n;
        }
        finally {
            this.stmts.remove(safeStmtPtr);
        }
    }

    protected abstract void _open(String var1, int var2);

    protected abstract void _close();

    public abstract int _exec(String var1);

    protected abstract SafeStmtPtr prepare(String var1);

    protected abstract int finalize(long var1);

    public abstract int step(long var1);

    public abstract int reset(long var1);

    public abstract int clear_bindings(long var1);

    abstract int bind_parameter_count(long var1);

    public abstract int column_count(long var1);

    public abstract int column_type(long var1, int var3);

    public abstract String column_decltype(long var1, int var3);

    public abstract String column_table_name(long var1, int var3);

    public abstract String column_name(long var1, int var3);

    public abstract String column_text(long var1, int var3);

    public abstract byte[] column_blob(long var1, int var3);

    public abstract double column_double(long var1, int var3);

    public abstract long column_long(long var1, int var3);

    public abstract int column_int(long var1, int var3);

    abstract int bind_null(long var1, int var3);

    abstract int bind_int(long var1, int var3, int var4);

    abstract int bind_long(long var1, int var3, long var4);

    abstract int bind_double(long var1, int var3, double var4);

    abstract int bind_text(long var1, int var3, String var4);

    abstract int bind_blob(long var1, int var3, byte[] var4);

    public abstract void result_null(long var1);

    public abstract void result_text(long var1, String var3);

    public abstract void result_blob(long var1, byte[] var3);

    public abstract void result_double(long var1, double var3);

    public abstract void result_long(long var1, long var3);

    public abstract void result_int(long var1, int var3);

    public abstract void result_error(long var1, String var3);

    public abstract String value_text(Function var1, int var2);

    public abstract byte[] value_blob(Function var1, int var2);

    public abstract double value_double(Function var1, int var2);

    public abstract long value_long(Function var1, int var2);

    public abstract int value_int(Function var1, int var2);

    public abstract int value_type(Function var1, int var2);

    public abstract int create_function(String var1, Function var2, int var3, int var4);

    public abstract int destroy_function(String var1);

    public abstract int create_collation(String var1, Collation var2);

    public abstract int destroy_collation(String var1);

    public abstract int backup(String var1, String var2, DB$ProgressObserver var3);

    public abstract int backup(String var1, String var2, DB$ProgressObserver var3, int var4, int var5, int var6);

    public abstract int restore(String var1, String var2, DB$ProgressObserver var3);

    public abstract int restore(String var1, String var2, DB$ProgressObserver var3, int var4, int var5, int var6);

    public abstract int limit(int var1, int var2);

    public abstract void register_progress_handler(int var1, ProgressHandler var2);

    public abstract void clear_progress_handler();

    abstract boolean[][] column_metadata(long var1);

    public final synchronized String[] column_names(long l) {
        String[] stringArray = new String[this.column_count(l)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.column_name(l, i);
        }
        return stringArray;
    }

    final synchronized int sqlbind(long l, int n, Object object) {
        ++n;
        if (object == null) {
            return this.bind_null(l, n);
        }
        if (object instanceof Integer) {
            return this.bind_int(l, n, (Integer)object);
        }
        if (object instanceof Short) {
            return this.bind_int(l, n, ((Short)object).intValue());
        }
        if (object instanceof Long) {
            return this.bind_long(l, n, (Long)object);
        }
        if (object instanceof Float) {
            return this.bind_double(l, n, ((Float)object).doubleValue());
        }
        if (object instanceof Double) {
            return this.bind_double(l, n, (Double)object);
        }
        if (object instanceof String) {
            return this.bind_text(l, n, (String)object);
        }
        if (object instanceof byte[]) {
            return this.bind_blob(l, n, (byte[])object);
        }
        throw new SQLException("unexpected param type: " + object.getClass());
    }

    final synchronized long[] executeBatch(SafeStmtPtr safeStmtPtr, int n, Object[] objectArray, boolean bl) {
        return safeStmtPtr.safeRun((dB, l) -> this.executeBatch(l, n, objectArray, bl));
    }

    private synchronized long[] executeBatch(long l, int n, Object[] objectArray, boolean bl) {
        if (n <= 0) {
            throw new SQLException("count (" + n + ") < 1");
        }
        int n2 = this.bind_parameter_count(l);
        long[] lArray = new long[n];
        try {
            for (int i = 0; i < n; ++i) {
                int n3;
                this.reset(l);
                for (int j = 0; j < n2; ++j) {
                    n3 = this.sqlbind(l, j, objectArray[i * n2 + j]);
                    if (n3 == 0) continue;
                    this.throwex(n3);
                }
                n3 = this.step(l);
                if (n3 != 101) {
                    this.reset(l);
                    if (n3 == 100) {
                        throw new BatchUpdateException("batch entry " + i + ": query returns results", null, 0, lArray, null);
                    }
                    this.throwex(n3);
                }
                lArray[i] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit(bl);
        }
        this.reset(l);
        return lArray;
    }

    public final synchronized boolean execute(CoreStatement coreStatement, Object[] objectArray) {
        int n = coreStatement.pointer.safeRunInt((dB, l) -> this.execute(l, objectArray));
        switch (n & 0xFF) {
            case 101: {
                this.ensureAutoCommit(coreStatement.conn.getAutoCommit());
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: 
            case 19: 
            case 21: {
                throw this.newSQLException(n);
            }
        }
        coreStatement.pointer.close();
        throw this.newSQLException(n);
    }

    private synchronized int execute(long l, Object[] objectArray) {
        int n;
        if (objectArray != null) {
            n = this.bind_parameter_count(l);
            if (n > objectArray.length) {
                throw new SQLException("assertion failure: param count (" + n + ") > value count (" + objectArray.length + ")");
            }
            for (int i = 0; i < n; ++i) {
                int n2 = this.sqlbind(l, i, objectArray[i]);
                if (n2 == 0) continue;
                this.throwex(n2);
            }
        }
        if (((n = this.step(l)) & 0xFF) == 101) {
            this.reset(l);
        }
        return n;
    }

    final synchronized boolean execute(String string, boolean bl) {
        int n = this._exec(string);
        switch (n) {
            case 0: {
                return false;
            }
            case 101: {
                this.ensureAutoCommit(bl);
                return false;
            }
            case 100: {
                return true;
            }
        }
        throw this.newSQLException(n);
    }

    public final synchronized long executeUpdate(CoreStatement coreStatement, Object[] objectArray) {
        try {
            if (this.execute(coreStatement, objectArray)) {
                throw new SQLException("query returns results");
            }
        }
        finally {
            if (!coreStatement.pointer.isClosed()) {
                coreStatement.pointer.safeRunInt(DB::reset);
            }
        }
        return this.changes();
    }

    abstract void set_commit_listener(boolean var1);

    abstract void set_update_listener(boolean var1);

    public synchronized void addUpdateListener(SQLiteUpdateListener sQLiteUpdateListener) {
        if (this.updateListeners.add(sQLiteUpdateListener) && this.updateListeners.size() == 1) {
            this.set_update_listener(true);
        }
    }

    public synchronized void addCommitListener(SQLiteCommitListener sQLiteCommitListener) {
        if (this.commitListeners.add(sQLiteCommitListener) && this.commitListeners.size() == 1) {
            this.set_commit_listener(true);
        }
    }

    public synchronized void removeUpdateListener(SQLiteUpdateListener sQLiteUpdateListener) {
        if (this.updateListeners.remove(sQLiteUpdateListener) && this.updateListeners.isEmpty()) {
            this.set_update_listener(false);
        }
    }

    public synchronized void removeCommitListener(SQLiteCommitListener sQLiteCommitListener) {
        if (this.commitListeners.remove(sQLiteCommitListener) && this.commitListeners.isEmpty()) {
            this.set_commit_listener(false);
        }
    }

    void onUpdate(int n, String string, String string2, long l) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            object = new HashSet<SQLiteUpdateListener>(this.updateListeners);
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            SQLiteUpdateListener$Type sQLiteUpdateListener$Type;
            object = (SQLiteUpdateListener)object2.next();
            switch (n) {
                case 18: {
                    sQLiteUpdateListener$Type = SQLiteUpdateListener$Type.INSERT;
                    break;
                }
                case 9: {
                    sQLiteUpdateListener$Type = SQLiteUpdateListener$Type.DELETE;
                    break;
                }
                case 23: {
                    sQLiteUpdateListener$Type = SQLiteUpdateListener$Type.UPDATE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + n));
                }
            }
            object.onUpdate(sQLiteUpdateListener$Type, string, string2, l);
        }
    }

    void onCommit(boolean bl) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            object = new HashSet<SQLiteCommitListener>(this.commitListeners);
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            object = (SQLiteCommitListener)object2.next();
            if (bl) {
                object.onCommit();
                continue;
            }
            object.onRollback();
        }
    }

    final void throwex() {
        throw new SQLException(this.errmsg());
    }

    public final void throwex(int n) {
        throw this.newSQLException(n);
    }

    static void throwex(int n, String string) {
        throw DB.newSQLException(n, string);
    }

    public static SQLiteException newSQLException(int n, String string) {
        SQLiteErrorCode sQLiteErrorCode = SQLiteErrorCode.getErrorCode(n);
        String string2 = sQLiteErrorCode == SQLiteErrorCode.UNKNOWN_ERROR ? String.format("%s:%s (%s)", new Object[]{sQLiteErrorCode, n, string}) : String.format("%s (%s)", new Object[]{sQLiteErrorCode, string});
        return new SQLiteException(string2, sQLiteErrorCode);
    }

    private SQLiteException newSQLException(int n) {
        return DB.newSQLException(n, this.errmsg());
    }

    final void ensureAutoCommit(boolean bl) {
        if (!bl) {
            return;
        }
        this.ensureBeginAndCommit();
        this.begin.safeRunConsume((dB2, l) -> this.commit.safeRunConsume((dB, l2) -> this.ensureAutocommit(l, l2)));
    }

    private void ensureBeginAndCommit() {
        DB dB;
        if (this.begin == null) {
            dB = this;
            synchronized (dB) {
                if (this.begin == null) {
                    this.begin = this.prepare("begin;");
                }
            }
        }
        if (this.commit == null) {
            dB = this;
            synchronized (dB) {
                if (this.commit == null) {
                    this.commit = this.prepare("commit;");
                }
                return;
            }
        }
    }

    private void ensureAutocommit(long l, long l2) {
        try {
            if (this.step(l) != 101) {
                return;
            }
            int n = this.step(l2);
            if (n != 101) {
                this.reset(l2);
                this.throwex(n);
            }
            return;
        }
        finally {
            this.reset(l);
            this.reset(l2);
        }
    }

    public abstract byte[] serialize(String var1);

    public abstract void deserialize(String var1, byte[] var2);
}

