/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.RMISecurityManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.listeners.SchedulerListenerSupport;

public class QuartzServer
extends SchedulerListenerSupport {
    private Scheduler sched = null;

    QuartzServer() {
    }

    public void serve(SchedulerFactory object, boolean bl) {
        this.sched = object.getScheduler();
        this.sched.start();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {}
        System.out.println("\n*** The scheduler successfully started.");
        if (bl) {
            System.out.println("\n");
            System.out.println("The scheduler will now run until you type \"exit\"");
            System.out.println("   If it was configured to export itself via RMI,");
            System.out.println("   then other process may now use it.");
            object = new BufferedReader(new InputStreamReader(System.in));
            do {
                System.out.print("Type 'exit' to shutdown the server: ");
            } while (!"exit".equals(((BufferedReader)object).readLine()));
            System.out.println("\n...Shutting down server...");
            this.sched.shutdown(true);
        }
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        System.err.println("*** " + string);
        schedulerException.printStackTrace();
    }

    @Override
    public void schedulerShutdown() {
        System.out.println("\n*** The scheduler is now shutdown.");
        this.sched = null;
    }

    public static void main(String[] stringArray) {
        block5: {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            try {
                QuartzServer quartzServer = new QuartzServer();
                if (stringArray.length == 0) {
                    quartzServer.serve(new StdSchedulerFactory(), false);
                    break block5;
                }
                if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("console")) {
                    quartzServer.serve(new StdSchedulerFactory(), true);
                    break block5;
                }
                System.err.println("\nUsage: QuartzServer [console]");
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
    }
}

