/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.BaseCalendar;

public class CronCalendar
extends BaseCalendar {
    static final long serialVersionUID = -8172103999750856831L;
    CronExpression cronExpression;

    public CronCalendar(String string) {
        this(null, string, null);
    }

    public CronCalendar(Calendar calendar, String string) {
        this(calendar, string, null);
    }

    public CronCalendar(Calendar calendar, String string, TimeZone timeZone) {
        super(calendar);
        this.cronExpression = new CronExpression(string);
        this.cronExpression.setTimeZone(timeZone);
    }

    @Override
    public Object clone() {
        CronCalendar cronCalendar = (CronCalendar)super.clone();
        ((CronCalendar)super.clone()).cronExpression = new CronExpression(this.cronExpression);
        return cronCalendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.cronExpression.getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.cronExpression.setTimeZone(timeZone);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l)) {
            return false;
        }
        return !this.cronExpression.isSatisfiedBy(new Date(l));
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = l + 1L;
        while (!this.isTimeIncluded(l2)) {
            if (this.cronExpression.isSatisfiedBy(new Date(l2))) {
                l2 = this.cronExpression.getNextInvalidTimeAfter(new Date(l2)).getTime();
                continue;
            }
            if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                continue;
            }
            ++l2;
        }
        return l2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("base calendar: [");
        if (this.getBaseCalendar() != null) {
            stringBuffer.append(this.getBaseCalendar().toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("], excluded cron expression: '");
        stringBuffer.append(this.cronExpression);
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String object) {
        this.cronExpression = object = new CronExpression((String)object);
    }

    public void setCronExpression(CronExpression cronExpression) {
        if (cronExpression == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        this.cronExpression = cronExpression;
    }
}

