/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils.counter.sampled;

import org.quartz.utils.counter.sampled.SampledCounterImpl;
import org.quartz.utils.counter.sampled.SampledRateCounter;
import org.quartz.utils.counter.sampled.SampledRateCounterConfig;

public class SampledRateCounterImpl
extends SampledCounterImpl
implements SampledRateCounter {
    private static final long serialVersionUID = 6531350452676920607L;
    private static final String OPERATION_NOT_SUPPORTED_MSG = "This operation is not supported. Use SampledCounter Or Counter instead";
    private long numeratorValue;
    private long denominatorValue;

    public SampledRateCounterImpl(SampledRateCounterConfig sampledRateCounterConfig) {
        super(sampledRateCounterConfig);
    }

    @Override
    public synchronized void setValue(long l, long l2) {
        this.numeratorValue = l;
        this.denominatorValue = l2;
    }

    @Override
    public synchronized void increment(long l, long l2) {
        this.numeratorValue += l;
        this.denominatorValue += l2;
    }

    @Override
    public synchronized void decrement(long l, long l2) {
        this.numeratorValue -= l;
        this.denominatorValue -= l2;
    }

    @Override
    public synchronized void setDenominatorValue(long l) {
        this.denominatorValue = l;
    }

    @Override
    public synchronized void setNumeratorValue(long l) {
        this.numeratorValue = l;
    }

    @Override
    public synchronized long getValue() {
        if (this.denominatorValue == 0L) {
            return 0L;
        }
        return this.numeratorValue / this.denominatorValue;
    }

    @Override
    public synchronized long getAndReset() {
        long l = this.getValue();
        this.setValue(0L, 0L);
        return l;
    }

    @Override
    public long getAndSet(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public synchronized void setValue(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long decrement() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long decrement(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    public long getMaxValue() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    public long getMinValue() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long increment() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long increment(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }
}

