/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import org.apache.fontbox.cff.DataInput;

public class DataInputByteArray
implements DataInput {
    private final byte[] inputBuffer;
    private int bufferPosition = 0;

    public DataInputByteArray(byte[] byArray) {
        this.inputBuffer = byArray;
    }

    @Override
    public boolean hasRemaining() {
        return this.bufferPosition < this.inputBuffer.length;
    }

    @Override
    public int getPosition() {
        return this.bufferPosition;
    }

    @Override
    public void setPosition(int n) {
        if (n < 0) {
            throw new IOException("position is negative");
        }
        if (n >= this.inputBuffer.length) {
            throw new IOException("New position is out of range " + n + " >= " + this.inputBuffer.length);
        }
        this.bufferPosition = n;
    }

    @Override
    public byte readByte() {
        if (!this.hasRemaining()) {
            throw new IOException("End off buffer reached");
        }
        return this.inputBuffer[this.bufferPosition++];
    }

    @Override
    public int readUnsignedByte() {
        if (!this.hasRemaining()) {
            throw new IOException("End off buffer reached");
        }
        return this.inputBuffer[this.bufferPosition++] & 0xFF;
    }

    @Override
    public int peekUnsignedByte(int n) {
        if (n < 0) {
            throw new IOException("offset is negative");
        }
        if (this.bufferPosition + n >= this.inputBuffer.length) {
            throw new IOException("Offset position is out of range " + (this.bufferPosition + n) + " >= " + this.inputBuffer.length);
        }
        return this.inputBuffer[this.bufferPosition + n] & 0xFF;
    }

    @Override
    public byte[] readBytes(int n) {
        if (n < 0) {
            throw new IOException("length is negative");
        }
        if (this.inputBuffer.length - this.bufferPosition < n) {
            throw new IOException("Premature end of buffer reached");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.inputBuffer, this.bufferPosition, byArray, 0, n);
        this.bufferPosition += n;
        return byArray;
    }

    @Override
    public int length() {
        return this.inputBuffer.length;
    }
}

