/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jmx.jboss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.ee.jmx.jboss.QuartzServiceMBean;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzService
extends ServiceMBeanSupport
implements QuartzServiceMBean {
    private Properties properties = new Properties();
    private StdSchedulerFactory schedulerFactory;
    private String jndiName = "Quartz";
    private String propertiesFile = "";
    private boolean error = false;
    private boolean useProperties = false;
    private boolean usePropertiesFile = false;
    private boolean startScheduler = true;

    @Override
    public void setJndiName(String string) {
        String string2 = this.jndiName;
        this.jndiName = string;
        if (super.getState() == 3) {
            this.unbind(string2);
            try {
                this.rebind();
                return;
            }
            catch (NamingException namingException) {
                this.log.error((Object)"Failed to rebind Scheduler", (Throwable)namingException);
                throw new SchedulerConfigException("Failed to rebind Scheduler - ", namingException);
            }
        }
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    public String getName() {
        return "QuartzService(" + this.jndiName + ")";
    }

    @Override
    public void setProperties(String object) {
        if (this.usePropertiesFile) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            this.error = true;
            return;
        }
        this.useProperties = true;
        try {
            object = ((String)object).replace(File.separator, "/");
            object = new ByteArrayInputStream(((String)object).getBytes());
            this.properties = new Properties();
            this.properties.load((InputStream)object);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public String getProperties() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.properties.store(byteArrayOutputStream, "");
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public void setPropertiesFile(String string) {
        if (this.useProperties) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            this.error = true;
            return;
        }
        this.usePropertiesFile = true;
        this.propertiesFile = string;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public void setStartScheduler(boolean bl) {
        this.startScheduler = bl;
    }

    public boolean getStartScheduler() {
        return this.startScheduler;
    }

    public void createService() {
        this.log.info((Object)("Create QuartzService(" + this.jndiName + ")..."));
        if (this.error) {
            this.log.error((Object)"Must specify only one of 'Properties' or 'PropertiesFile'");
            throw new Exception("Must specify only one of 'Properties' or 'PropertiesFile'");
        }
        this.schedulerFactory = new StdSchedulerFactory();
        try {
            if (this.useProperties) {
                this.schedulerFactory.initialize(this.properties);
            }
            if (this.usePropertiesFile) {
                this.schedulerFactory.initialize(this.propertiesFile);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Failed to initialize Scheduler", (Throwable)exception);
            throw new SchedulerConfigException("Failed to initialize Scheduler - ", exception);
        }
        this.log.info((Object)("QuartzService(" + this.jndiName + ") created."));
    }

    public void destroyService() {
        this.log.info((Object)("Destroy QuartzService(" + this.jndiName + ")..."));
        this.schedulerFactory = null;
        this.log.info((Object)("QuartzService(" + this.jndiName + ") destroyed."));
    }

    public void startService() {
        this.log.info((Object)("Start QuartzService(" + this.jndiName + ")..."));
        try {
            this.rebind();
        }
        catch (NamingException namingException) {
            this.log.error((Object)"Failed to rebind Scheduler", (Throwable)namingException);
            throw new SchedulerConfigException("Failed to rebind Scheduler - ", namingException);
        }
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            if (this.startScheduler) {
                scheduler.start();
            } else {
                this.log.info((Object)"Skipping starting the scheduler (will not run jobs).");
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Failed to start Scheduler", (Throwable)exception);
            throw new SchedulerConfigException("Failed to start Scheduler - ", exception);
        }
        this.log.info((Object)("QuartzService(" + this.jndiName + ") started."));
    }

    public void stopService() {
        this.log.info((Object)("Stop QuartzService(" + this.jndiName + ")..."));
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.shutdown();
        }
        catch (Exception exception) {
            this.log.error((Object)"Failed to shutdown Scheduler", (Throwable)exception);
            throw new SchedulerConfigException("Failed to shutdown Scheduler - ", exception);
        }
        QuartzService quartzService = this;
        quartzService.unbind(quartzService.jndiName);
        this.log.info((Object)("QuartzService(" + this.jndiName + ") stopped."));
    }

    private void rebind() {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Name name = initialContext.getNameParser("").parse(this.jndiName);
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            NonSerializableFactory.rebind((Name)name, (Object)scheduler, (boolean)true);
        }
        catch (Throwable throwable) {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
            throw throwable;
        }
        try {
            initialContext.close();
            return;
        }
        catch (NamingException namingException) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unbind(String string) {
        InitialContext initialContext = null;
        initialContext = new InitialContext();
        initialContext.unbind(string);
        NonSerializableFactory.unbind((String)string);
        try {
            initialContext.close();
            return;
        }
        catch (NamingException namingException) {
            return;
        }
        catch (NamingException namingException) {
            try {
                this.log.warn((Object)("Failed to unbind scheduler with jndiName: " + string), (Throwable)namingException);
                if (initialContext == null) return;
            }
            catch (Throwable throwable) {
                if (initialContext == null) throw throwable;
                try {
                    initialContext.close();
                    throw throwable;
                }
                catch (NamingException namingException2) {}
                throw throwable;
            }
            try {
                initialContext.close();
                return;
            }
            catch (NamingException namingException3) {
                return;
            }
        }
    }
}

