/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzInitializerListener
implements ServletContextListener {
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private boolean waitOnShutdown = false;
    private Scheduler scheduler = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.log.info("Quartz Initializer Servlet loaded, initializing Scheduler...");
        servletContextEvent = servletContextEvent.getServletContext();
        try {
            String string;
            Object object = servletContextEvent.getInitParameter("quartz:config-file");
            if (object == null) {
                object = servletContextEvent.getInitParameter("config-file");
            }
            if ((string = servletContextEvent.getInitParameter("quartz:shutdown-on-unload")) == null) {
                string = servletContextEvent.getInitParameter("shutdown-on-unload");
            }
            if (string != null) {
                this.performShutdown = Boolean.valueOf(string);
            }
            if ((string = servletContextEvent.getInitParameter("quartz:wait-on-shutdown")) != null) {
                this.waitOnShutdown = Boolean.valueOf(string);
            }
            object = this.getSchedulerFactory((String)object);
            this.scheduler = ((StdSchedulerFactory)object).getScheduler();
            string = servletContextEvent.getInitParameter("quartz:start-on-load");
            if (string == null) {
                string = servletContextEvent.getInitParameter("start-scheduler-on-load");
            }
            int n = 0;
            String string2 = servletContextEvent.getInitParameter("quartz:start-delay-seconds");
            if (string2 == null) {
                string2 = servletContextEvent.getInitParameter("start-delay-seconds");
            }
            try {
                if (string2 != null && string2.trim().length() > 0) {
                    n = Integer.parseInt(string2);
                }
            }
            catch (Exception exception) {
                this.log.error("Cannot parse value of 'start-delay-seconds' to an integer: " + string2 + ", defaulting to 5 seconds.");
                n = 5;
            }
            if (string == null || Boolean.valueOf(string).booleanValue()) {
                if (n <= 0) {
                    this.scheduler.start();
                    this.log.info("Scheduler has been started...");
                } else {
                    this.scheduler.startDelayed(n);
                    this.log.info("Scheduler will start in " + n + " seconds.");
                }
            } else {
                this.log.info("Scheduler has not been started. Use scheduler.start()");
            }
            string = servletContextEvent.getInitParameter("quartz:servlet-context-factory-key");
            if (string == null) {
                string = servletContextEvent.getInitParameter("servlet-context-factory-key");
            }
            if (string == null) {
                string = QUARTZ_FACTORY_KEY;
            }
            this.log.info("Storing the Quartz Scheduler Factory in the servlet context at key: " + string);
            servletContextEvent.setAttribute(string, object);
            object = servletContextEvent.getInitParameter("quartz:scheduler-context-servlet-context-key");
            if (object == null) {
                object = servletContextEvent.getInitParameter("scheduler-context-servlet-context-key");
            }
            if (object != null) {
                this.log.info("Storing the ServletContext in the scheduler context at key: " + (String)object);
                this.scheduler.getContext().put((String)object, (Object)servletContextEvent);
            }
            return;
        }
        catch (Exception exception) {
            this.log.error("Quartz Scheduler failed to initialize: " + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    protected StdSchedulerFactory getSchedulerFactory(String object) {
        object = object != null ? new StdSchedulerFactory((String)object) : new StdSchedulerFactory();
        return object;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown(this.waitOnShutdown);
            }
        }
        catch (Exception exception) {
            this.log.error("Quartz Scheduler failed to shutdown cleanly: " + exception.toString());
            exception.printStackTrace();
        }
        this.log.info("Quartz Scheduler successful shutdown.");
    }
}

