/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.transaction.UserTransaction;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.jobs.FileScanJob;
import org.quartz.jobs.FileScanListener;
import org.quartz.plugins.SchedulerPluginWithUserTransactionSupport;
import org.quartz.plugins.xml.XMLSchedulingDataProcessorPlugin$JobFile;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.xml.XMLSchedulingDataProcessor;
import org.slf4j.Logger;

public class XMLSchedulingDataProcessorPlugin
extends SchedulerPluginWithUserTransactionSupport
implements FileScanListener {
    private static final int MAX_JOB_TRIGGER_NAME_LEN = 80;
    private static final String JOB_INITIALIZATION_PLUGIN_NAME = "JobSchedulingDataLoaderPlugin";
    private static final String FILE_NAME_DELIMITERS = ",";
    private boolean failOnFileNotFound = true;
    private String fileNames = "quartz_data.xml";
    private Map<String, XMLSchedulingDataProcessorPlugin$JobFile> jobFiles = new LinkedHashMap<String, XMLSchedulingDataProcessorPlugin$JobFile>();
    private long scanInterval = 0L;
    boolean started = false;
    protected ClassLoadHelper classLoadHelper = null;
    private Set<String> jobTriggerNameSet = new HashSet<String>();

    public String getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String string) {
        this.fileNames = string;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long l) {
        this.scanInterval = l * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean bl) {
        this.failOnFileNotFound = bl;
    }

    @Override
    public void initialize(String object, Scheduler object2, ClassLoadHelper object3) {
        super.initialize((String)object, (Scheduler)object2);
        this.classLoadHelper = object3;
        this.getLog().info("Registering Quartz Job Initialization Plug-in.");
        object = new StringTokenizer(this.fileNames, FILE_NAME_DELIMITERS);
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken();
            object3 = new XMLSchedulingDataProcessorPlugin$JobFile(this, (String)object2);
            this.jobFiles.put((String)object2, (XMLSchedulingDataProcessorPlugin$JobFile)object3);
        }
    }

    @Override
    public void start(UserTransaction object) {
        try {
            if (!this.jobFiles.isEmpty()) {
                if (this.scanInterval > 0L) {
                    this.getScheduler().getContext().put("JobSchedulingDataLoaderPlugin_" + this.getName(), (Object)this);
                }
                for (XMLSchedulingDataProcessorPlugin$JobFile xMLSchedulingDataProcessorPlugin$JobFile : this.jobFiles.values()) {
                    if (this.scanInterval > 0L) {
                        Object object2 = this.buildJobTriggerName(xMLSchedulingDataProcessorPlugin$JobFile.getFileBasename());
                        Comparable<Key<TriggerKey>> comparable = new TriggerKey((String)object2, JOB_INITIALIZATION_PLUGIN_NAME);
                        this.getScheduler().unscheduleJob((TriggerKey)comparable);
                        object2 = JobBuilder.newJob().withIdentity((String)object2, JOB_INITIALIZATION_PLUGIN_NAME).ofType(FileScanJob.class).usingJobData("FILE_NAME", xMLSchedulingDataProcessorPlugin$JobFile.getFileName()).usingJobData("FILE_SCAN_LISTENER_NAME", "JobSchedulingDataLoaderPlugin_" + this.getName()).build();
                        comparable = TriggerBuilder.newTrigger().withIdentity((TriggerKey)comparable).withSchedule(SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInMilliseconds(this.scanInterval)).forJob((JobDetail)object2).build();
                        this.getScheduler().scheduleJob((JobDetail)object2, (Trigger)comparable);
                        this.getLog().debug("Scheduled file scan job for data file: {}, at interval: {}", (Object)xMLSchedulingDataProcessorPlugin$JobFile.getFileName(), (Object)this.scanInterval);
                    }
                    this.processFile(xMLSchedulingDataProcessorPlugin$JobFile);
                }
            }
            return;
        }
        catch (SchedulerException schedulerException) {
            this.getLog().error("Error starting background-task for watching jobs file.", (Throwable)schedulerException);
            return;
        }
        finally {
            this.started = true;
        }
    }

    private String buildJobTriggerName(String string) {
        string = "JobSchedulingDataLoaderPlugin_" + this.getName() + '_' + string.replace('.', '_');
        if (string.length() > 80) {
            string = string.substring(0, 80);
        }
        int n = 1;
        while (!this.jobTriggerNameSet.add(string)) {
            if (n > 1) {
                string = string.substring(0, string.lastIndexOf(95));
            }
            String string2 = "_" + n++;
            if (string.length() > 80 - string2.length()) {
                string = string.substring(0, 80 - string2.length());
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public void shutdown() {
    }

    private void processFile(XMLSchedulingDataProcessorPlugin$JobFile xMLSchedulingDataProcessorPlugin$JobFile) {
        if (xMLSchedulingDataProcessorPlugin$JobFile == null || !xMLSchedulingDataProcessorPlugin$JobFile.getFileFound()) {
            return;
        }
        try {
            XMLSchedulingDataProcessor xMLSchedulingDataProcessor = new XMLSchedulingDataProcessor(this.classLoadHelper);
            xMLSchedulingDataProcessor.addJobGroupToNeverDelete(JOB_INITIALIZATION_PLUGIN_NAME);
            xMLSchedulingDataProcessor.addTriggerGroupToNeverDelete(JOB_INITIALIZATION_PLUGIN_NAME);
            xMLSchedulingDataProcessor.processFileAndScheduleJobs(xMLSchedulingDataProcessorPlugin$JobFile.getFileName(), xMLSchedulingDataProcessorPlugin$JobFile.getFileName(), this.getScheduler());
            return;
        }
        catch (Exception exception) {
            this.getLog().error("Error scheduling jobs: " + exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public void processFile(String string) {
        XMLSchedulingDataProcessorPlugin xMLSchedulingDataProcessorPlugin = this;
        xMLSchedulingDataProcessorPlugin.processFile(xMLSchedulingDataProcessorPlugin.jobFiles.get(string));
    }

    public void fileUpdated(String string) {
        if (this.started) {
            this.processFile(string);
        }
    }

    static /* synthetic */ Logger access$000(XMLSchedulingDataProcessorPlugin xMLSchedulingDataProcessorPlugin) {
        return xMLSchedulingDataProcessorPlugin.getLog();
    }

    static /* synthetic */ Logger access$100(XMLSchedulingDataProcessorPlugin xMLSchedulingDataProcessorPlugin) {
        return xMLSchedulingDataProcessorPlugin.getLog();
    }
}

