/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.CharsKt__CharJVMKt;
import kotlin.text._OneToManyTitlecaseMappingsKt;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\f\u0010\u0004\u001a\u00020\u0002*\u00020\u0001H\u0007\u001a\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u001b\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0002\u0010\u0007\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0001\u001a\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000eH\u0087\n\u001a\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0001H\u0007\u00a8\u0006\u0010"}, d2={"digitToChar", "", "", "radix", "digitToInt", "digitToIntOrNull", "(C)Ljava/lang/Integer;", "(CI)Ljava/lang/Integer;", "equals", "", "other", "ignoreCase", "isSurrogate", "plus", "", "titlecase", "kotlin-stdlib"}, xs="kotlin/text/CharsKt")
class CharsKt__CharKt
extends CharsKt__CharJVMKt {
    public static final int digitToInt(char c) {
        int n = CharsKt.digitOf(c, 10);
        if (n < 0) {
            throw new IllegalArgumentException("Char " + c + " is not a decimal digit");
        }
        return n;
    }

    public static final int digitToInt(char c, int n) {
        Integer n2 = CharsKt.digitToIntOrNull(c, n);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalArgumentException("Char " + c + " is not a digit in the given radix=" + n);
    }

    public static final Integer digitToIntOrNull(char c) {
        Integer n = CharsKt.digitOf(c, 10);
        int n2 = ((Number)n).intValue();
        if (n2 >= 0) {
            return n;
        }
        return null;
    }

    public static final Integer digitToIntOrNull(char c, int n) {
        CharsKt.checkRadix(n);
        Integer n2 = CharsKt.digitOf(c, n);
        n = ((Number)n2).intValue();
        if (n >= 0) {
            return n2;
        }
        return null;
    }

    public static final char digitToChar(int n) {
        boolean bl = n >= 0 ? n < 10 : false;
        if (bl) {
            return (char)(n + 48);
        }
        throw new IllegalArgumentException("Int " + n + " is not a decimal digit");
    }

    public static final char digitToChar(int n, int n2) {
        if (!(2 <= n2 ? n2 < 37 : false)) {
            throw new IllegalArgumentException("Invalid radix: " + n2 + ". Valid radix values are in range 2..36");
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Digit " + n + " does not represent a valid digit in radix " + n2);
        }
        if (n < 10) {
            return (char)(n + 48);
        }
        return (char)((char)(n + 65) - 10);
    }

    public static final String titlecase(char c) {
        return _OneToManyTitlecaseMappingsKt.titlecaseImpl(c);
    }

    private static final String plus(char c, String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return c + string;
    }

    public static final boolean equals(char c, char c2, boolean bl) {
        if (c == c2) {
            return true;
        }
        if (!bl) {
            return false;
        }
        return (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    public static /* synthetic */ boolean equals$default(char c, char c2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return CharsKt.equals(c, c2, bl);
    }

    public static final boolean isSurrogate(char c) {
        if ('\ud800' <= c) {
            return c < '\ue000';
        }
        return false;
    }
}

