/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.util.LocationUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class KeyStoreFactoryBean {
    private String location;
    private String provider;
    private String type;
    private String password;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore createKeyStore() {
        Object object;
        if (this.getLocation() == null) {
            throw new IllegalArgumentException("location is required");
        }
        Object object2 = null;
        try {
            object = LocationUtil.urlForResource(this.getLocation());
            object2 = ((URL)object).openStream();
            object = this.newKeyStore();
            ((KeyStore)object).load((InputStream)object2, this.getPassword().toCharArray());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            try {
                throw new NoSuchProviderException("no such keystore provider: " + this.getProvider());
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new NoSuchAlgorithmException("no such keystore type: " + this.getType());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new KeyStoreException(this.getLocation() + ": file not found");
                }
                catch (Exception exception) {
                    throw new KeyStoreException(this.getLocation() + ": " + exception.getMessage(), exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (object2 == null) throw throwable;
                    ((InputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
        try {
            if (object2 == null) return object;
            ((InputStream)object2).close();
            return object;
        }
        catch (IOException iOException) {
            object2 = iOException;
            iOException.printStackTrace(System.err);
        }
        return object;
    }

    private KeyStore newKeyStore() {
        if (this.getProvider() != null) {
            return KeyStore.getInstance(this.getType(), this.getProvider());
        }
        return KeyStore.getInstance(this.getType());
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getType() {
        if (this.type == null) {
            return "JKS";
        }
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public String getPassword() {
        if (this.password == null) {
            return "changeit";
        }
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }
}

