/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.PathKt;
import org.jetbrains.skia.PathOp;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fJ\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fJ&\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fJ \u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lorg/jetbrains/skia/Path$Companion;", "", "()V", "convertConicToQuads", "", "Lorg/jetbrains/skia/Point;", "p0", "p1", "p2", "w", "", "pow2", "", "(Lorg/jetbrains/skia/Point;Lorg/jetbrains/skia/Point;Lorg/jetbrains/skia/Point;FI)[Lorg/jetbrains/skia/Point;", "isCubicDegenerate", "", "p3", "p4", "exact", "isLineDegenerate", "isQuadDegenerate", "makeCombining", "Lorg/jetbrains/skia/Path;", "one", "two", "op", "Lorg/jetbrains/skia/PathOp;", "makeFromBytes", "data", "", "makeFromSVGString", "svg", "", "skiko"})
public final class Path$Companion {
    private Path$Companion() {
    }

    public final Path makeFromSVGString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Stats.INSTANCE.onNativeCall();
        InteropScope interopScope = theScope.INSTANCE;
        long l = PathKt.access$_nMakeFromSVGString(interopScope.toInterop(string));
        if (l == Native.Companion.getNullPointer()) {
            throw new IllegalArgumentException("Failed to parse SVG Path string: " + string);
        }
        return new Path(l);
    }

    public final boolean isLineDegenerate(Point point, Point point2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"");
        Stats.INSTANCE.onNativeCall();
        return PathKt.access$_nIsLineDegenerate(point.getX(), point.getY(), point2.getX(), point2.getY(), bl);
    }

    public final boolean isQuadDegenerate(Point point, Point point2, Point point3, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"");
        Intrinsics.checkNotNullParameter((Object)point3, (String)"");
        Stats.INSTANCE.onNativeCall();
        return PathKt.access$_nIsQuadDegenerate(point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY(), bl);
    }

    public final boolean isCubicDegenerate(Point point, Point point2, Point point3, Point point4, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        Intrinsics.checkNotNullParameter((Object)point2, (String)"");
        Intrinsics.checkNotNullParameter((Object)point3, (String)"");
        Intrinsics.checkNotNullParameter((Object)point4, (String)"");
        Stats.INSTANCE.onNativeCall();
        return PathKt.access$_nIsCubicDegenerate(point.getX(), point.getY(), point2.getX(), point2.getY(), point3.getX(), point3.getY(), point4.getX(), point4.getY(), bl);
    }

    public final Point[] convertConicToQuads(Point point, Point object, Point pointArray, float f, int n) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)pointArray, (String)"");
        Stats.INSTANCE.onNativeCall();
        int n2 = 1 + 2 * (1 << n);
        float[] fArray = new float[n2 << 1];
        InteropScope interopScope = theScope.INSTANCE;
        Object object3 = object2 = interopScope.toInteropForResult(fArray);
        int n3 = PathKt.access$_nConvertConicToQuads(point.getX(), point.getY(), ((Point)object).getX(), ((Point)object).getY(), pointArray.getX(), pointArray.getY(), f, n, object3);
        interopScope.fromInterop(object2, fArray);
        object = fArray;
        int n4 = 0;
        pointArray = new Point[n3];
        while (n4 < n3) {
            int n5 = n4++;
            pointArray[n5] = new Point((float)object[2 * n5], (float)object[2 * n5 + 1]);
        }
        return pointArray;
    }

    public final Path makeCombining(Path path, Path path2, PathOp pathOp) {
        Path path3;
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pathOp), (String)"");
        try {
            Stats.INSTANCE.onNativeCall();
            long l = PathKt.access$_nMakeCombining(NativeKt.getPtr(path), NativeKt.getPtr(path2), pathOp.ordinal());
            path3 = l == Native.Companion.getNullPointer() ? null : new Path(l);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(path);
            Native_jvmKt.reachabilityBarrier(path2);
        }
        return path3;
    }

    public final Path makeFromBytes(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Stats.INSTANCE.onNativeCall();
        InteropScope interopScope = theScope.INSTANCE;
        long l = PathKt.access$_nMakeFromBytes(interopScope.toInterop(byArray), byArray.length);
        if (l == Native.Companion.getNullPointer()) {
            throw new IllegalArgumentException("Failed to parse serialized Path");
        }
        return new Path(l);
    }

    public /* synthetic */ Path$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

