/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import com.e.b.a.k;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NotContextException;
import org.apache.commons.a.a;
import org.osjava.sj.jndi.JndiUtils;
import org.osjava.sj.loader.convert.ConverterIF;
import org.osjava.sj.loader.convert.ConverterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLoader {
    public static final String DELIMITER = "org.osjava.sj.delimiter";
    public static final String COLON_REPLACE = "org.osjava.sj.colon.replace";
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static ConverterRegistry converterRegistry = new ConverterRegistry();
    private final Properties envAsProperties;
    Hashtable environment = new Hashtable();
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String FILENAME_TO_CONTEXT = "org.osjava.sj.filenameToContext";

    public JndiLoader(Hashtable hashtable) {
        this.environment = new Hashtable(hashtable);
        if (!this.environment.containsKey(DELIMITER)) {
            this.LOGGER.info("{} not set. Setting to \".\"", (Object)DELIMITER);
            this.environment.put(DELIMITER, ".");
        }
        if (!this.environment.containsKey("jndi.syntax.direction")) {
            this.LOGGER.warn("jndi.syntax.direction not set. Setting to \"left_to_right\"");
            this.environment.put("jndi.syntax.direction", "left_to_right");
        }
        hashtable = new Properties();
        ((Properties)hashtable).putAll((Map<?, ?>)this.environment);
        this.envAsProperties = hashtable;
    }

    boolean isNotNamespacedTypeDefinition(Properties object) {
        for (Object object2 : ((Properties)((Object)object)).keySet()) {
            String object22 = (String)object2;
            if (!object22.equals("type")) continue;
            return true;
        }
        return false;
    }

    String handleColonReplacement(String string) {
        String string2 = (String)this.environment.get(COLON_REPLACE);
        if (string2 != null && string.contains(string2)) {
            string = k.a((String)string, (String)string2, (String)":");
        }
        return string;
    }

    public void load(Properties properties, Context context) {
        this.load(properties, context, null, "");
    }

    void load(Properties properties, Context context, Context context2, String string) {
        Object object;
        Object object2;
        String string2;
        Map<String, Properties> map = this.extractTypedProperties(properties);
        for (Object object3 : properties.keySet()) {
            Object object4 = properties.get(object3);
            string2 = this.extractDelimiter((String)object3);
            if (((String)object3).equals("type") || this.extractTypeDeclaration((String)object3) != null) continue;
            if (map.containsKey("datasourceOrBeanProperty")) {
                map.get("datasourceOrBeanProperty").put(object3, object4);
                continue;
            }
            if (map.containsKey(object3)) {
                map.get(object3).put("valueToConvert", object4);
                continue;
            }
            if (string2 != null) {
                object2 = JndiLoader.removeLastElement((String)object3, string2);
                object = JndiLoader.getLastElement((String)object3, string2);
                if (map.containsKey(object2)) {
                    map.get(object2).put(object, object4);
                    continue;
                }
                this.jndiPut(context, (String)object3, object4);
                continue;
            }
            this.jndiPut(context, (String)object3, object4);
        }
        for (Object e : map.keySet()) {
            string2 = (String)e;
            object2 = map.get(string2);
            object = this.convert((Properties)object2);
            if (string2.equals("datasourceOrBeanProperty")) {
                context2.rebind(string, object);
                continue;
            }
            this.jndiPut(context, string2, object);
        }
    }

    Map<String, Properties> extractTypedProperties(Properties properties) {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        for (String string : properties.keySet()) {
            String string2 = this.extractTypeDeclaration(string);
            if (!string.equals("type") && string2 == null) continue;
            Properties properties2 = new Properties();
            properties2.put("type", properties.get(string));
            if (string.equals("type")) {
                hashMap.put("datasourceOrBeanProperty", properties2);
                continue;
            }
            String string3 = string.substring(0, string.length() - string2.length() - 1);
            hashMap.put(string3, properties2);
        }
        return hashMap;
    }

    private void processTypedProperty(Properties properties, Context object, String object2) {
        if (this.isNotNamespacedTypeDefinition(properties)) {
            Iterator<Object> iterator = this.getTypeDefinition(properties);
            iterator = this.extractContextName((String)((Object)iterator));
            Context context = object;
            if (iterator != null) {
                if (iterator.size() > 1) {
                    Iterator<Object> iterator2 = iterator;
                    iterator2.remove(iterator2.size() - 1);
                    context = this.createSubContexts((Name)((Object)iterator), (Context)object);
                    Iterator<Object> iterator3 = iterator;
                    object = iterator3.getSuffix(iterator3.size() - 1);
                } else {
                    object = iterator;
                }
            } else {
                object = new CompoundName((String)object2, EMPTY_PROPERTIES);
            }
            object2 = new Properties();
            for (Object object3 : properties.keySet()) {
                object3 = (String)object3;
                object3 = this.extractObjectName((String)object3);
                String string = (String)properties.get(object3);
                ((Properties)object2).put(object3, string);
            }
            this.jndiPut(context, object.toString(), this.convert((Properties)object2));
            return;
        }
        throw new RuntimeException("Not implemented yet.");
    }

    String getTypeDefinition(Properties object) {
        if (object == null) {
            JndiLoader.$$$reportNull$$$0(1);
        }
        for (Object object2 : ((Properties)((Object)object)).keySet()) {
            String object22 = (String)object2;
            if (!object22.endsWith("type")) continue;
            return object22;
        }
        return null;
    }

    Name extractContextName(String object) {
        Name name;
        if (((CompoundName)(object = this.toCompoundName((String)object))).size() > 1) {
            Object object2 = object;
            name = ((CompoundName)object2).getPrefix(((CompoundName)object2).size() - 1);
        } else {
            name = null;
        }
        object = name;
        return name;
    }

    String extractObjectName(String object) {
        String string = ((CompoundName)object).getSuffix(((CompoundName)(object = this.toCompoundName((String)object))).size() > 1 ? ((CompoundName)object).size() - 1 : 0).toString();
        if (string == null) {
            JndiLoader.$$$reportNull$$$0(2);
        }
        return string;
    }

    CompoundName toCompoundName(String string) {
        if (string == null) {
            JndiLoader.$$$reportNull$$$0(3);
        }
        CompoundName compoundName = JndiUtils.toCompoundName(string, this.envAsProperties);
        if (compoundName == null) {
            JndiLoader.$$$reportNull$$$0(4);
        }
        return compoundName;
    }

    private String extractDelimiter(String object) {
        Object object2 = (String)this.environment.get(DELIMITER);
        if (((String)object2).length() == 1) {
            object2 = ((String)object2).replace(".", "\\.");
        }
        if (((Matcher)(object = ((Pattern)(object2 = Pattern.compile("^.+(" + (String)object2 + ").+"))).matcher((CharSequence)object))).find()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    private String extractTypeDeclaration(String string) {
        if (string == null) {
            JndiLoader.$$$reportNull$$$0(5);
        }
        if ((string = this.extractObjectName(string)).equals("type")) {
            return string;
        }
        return null;
    }

    private void jndiPut(Context context, String string, Object object) {
        Name name = this.extractContextName(string);
        if (name != null) {
            context = this.createSubContexts(name, context);
            context.bind(this.extractObjectName(string), object);
            return;
        }
        context.bind(this.toCompoundName(string), object);
    }

    Context createSubContexts(Name name, Context context) {
        for (int i = 0; i < name.size(); ++i) {
            try {
                Object object = context.lookup(name.get(i));
                if (!(object instanceof Context)) {
                    this.LOGGER.error("createSubContexts() CompoundName={} Name '{}' already occupied by '{}'.", new Object[]{name, name.get(i), object});
                    throw new NotContextException(name.get(i) + " already occupied by " + object);
                }
                context = (Context)object;
                continue;
            }
            catch (NameNotFoundException nameNotFoundException) {
                context = context.createSubcontext(name.get(i));
            }
        }
        return context;
    }

    private Object convert(Properties properties) {
        String string = properties.getProperty("type");
        Object object = properties.get("valueToConvert");
        String string2 = properties.getProperty("converter");
        object = string2 != null ? JndiLoader.callConverter(properties, string, string2) : this.processType(properties, string, object);
        return object;
    }

    Object processType(Properties cloneable, String string, Object object) {
        block12: {
            if (((Properties)cloneable).containsKey("type")) {
                if (((Properties)cloneable).containsKey("javaxNamingSpiObjectFactory")) {
                    object = JndiUtils.toReference((Properties)cloneable, string);
                } else {
                    ConverterIF converterIF = converterRegistry.getConverter(string);
                    if (converterIF != null) {
                        Object object2 = ((Properties)cloneable).get("valueToConvert");
                        if (object2 instanceof List) {
                            object2 = (List)object2;
                            cloneable = new LinkedList();
                            object = object2.iterator();
                            while (object.hasNext()) {
                                object2 = (String)object.next();
                                Properties properties = new Properties();
                                properties.setProperty("valueToConvert", (String)object2);
                                ((LinkedList)cloneable).add(converterIF.convert(properties, string));
                            }
                            object = cloneable;
                        } else {
                            try {
                                object = converterIF.convert((Properties)cloneable, string);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (string.equals("javax.sql.DataSource") && this.environment.containsKey("java.naming.factory.object")) {
                                    object = JndiUtils.toReference((Properties)cloneable, string);
                                    break block12;
                                }
                                this.LOGGER.error("", (Throwable)illegalArgumentException);
                            }
                        }
                    } else if (this.environment.containsKey("java.naming.factory.object")) {
                        object = JndiUtils.toReference((Properties)cloneable, string);
                    }
                }
            }
        }
        return object;
    }

    private static Object callConverter(Properties object, String string, String string2) {
        try {
            Object object2 = Class.forName(string2);
            object2 = (ConverterIF)((Class)object2).newInstance();
            object = object2.convert((Properties)object, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unable to find class: " + string2, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to access class: " + string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Unable to create Converter " + string + " via empty constructor. ", instantiationException);
        }
        return object;
    }

    private static String getLastElement(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return string.substring(n + 1);
    }

    private static String removeLastElement(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return string.substring(0, n);
    }

    protected boolean isSupportedFile(File object) {
        if (object == null) {
            JndiLoader.$$$reportNull$$$0(6);
        }
        String[] stringArray = new String[]{"properties", "ini", "xml"};
        object = a.b((String)((File)object).getName());
        for (int i = 0; i < 3; ++i) {
            String string = stringArray[i];
            if (!string.equals(object)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osjava/sj/loader/JndiLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTypedProperties";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osjava/sj/loader/JndiLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractObjectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompoundName";
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toCompoundName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTypeDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
            }
        }
        throw runtimeException;
    }
}

