/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util$EventLogRecord;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.ptr.IntByReference;
import java.util.Iterator;

public class Advapi32Util$EventLogIterator
implements Iterable<Advapi32Util$EventLogRecord>,
Iterator<Advapi32Util$EventLogRecord> {
    private WinNT$HANDLE _h;
    private Memory _buffer = new Memory(65536L);
    private boolean _done = false;
    private int _dwRead = 0;
    private Pointer _pevlr = null;
    private int _flags;

    public Advapi32Util$EventLogIterator(String string) {
        this(null, string, 4);
    }

    public Advapi32Util$EventLogIterator(String string, String string2, int n) {
        this._flags = n;
        this._h = Advapi32.INSTANCE.OpenEventLog(string, string2);
        if (this._h == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    private boolean read() {
        if (this._done || this._dwRead > 0) {
            return false;
        }
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        if (!Advapi32.INSTANCE.ReadEventLog(this._h, 1 | this._flags, 0, (Pointer)this._buffer, (int)this._buffer.size(), intByReference, intByReference2)) {
            int n = Kernel32.INSTANCE.GetLastError();
            if (n == 122) {
                this._buffer = new Memory((long)intByReference2.getValue());
                if (!Advapi32.INSTANCE.ReadEventLog(this._h, 1 | this._flags, 0, (Pointer)this._buffer, (int)this._buffer.size(), intByReference, intByReference2)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            } else {
                this.close();
                if (n != 38) {
                    throw new Win32Exception(n);
                }
                return false;
            }
        }
        this._dwRead = intByReference.getValue();
        this._pevlr = this._buffer;
        return true;
    }

    public void close() {
        this._done = true;
        if (this._h != null) {
            if (!Advapi32.INSTANCE.CloseEventLog(this._h)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this._h = null;
        }
    }

    @Override
    public Iterator<Advapi32Util$EventLogRecord> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.read();
        return !this._done;
    }

    @Override
    public Advapi32Util$EventLogRecord next() {
        this.read();
        Advapi32Util$EventLogRecord advapi32Util$EventLogRecord = new Advapi32Util$EventLogRecord(this._pevlr);
        this._dwRead -= advapi32Util$EventLogRecord.getLength();
        this._pevlr = this._pevlr.share((long)advapi32Util$EventLogRecord.getLength());
        return advapi32Util$EventLogRecord;
    }

    @Override
    public void remove() {
    }
}

