/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$LUID;
import com.sun.jna.platform.win32.WinNT$LUID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_PRIVILEGES;
import java.io.Closeable;

public class Advapi32Util$Privilege
implements Closeable {
    private boolean currentlyImpersonating = false;
    private boolean privilegesEnabled = false;
    private final WinNT$LUID[] pLuids;

    public Advapi32Util$Privilege(String ... stringArray) {
        this.pLuids = new WinNT$LUID[stringArray.length];
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            this.pLuids[n] = new WinNT$LUID();
            if (!Advapi32.INSTANCE.LookupPrivilegeValue(null, string, this.pLuids[n])) {
                throw new IllegalArgumentException("Failed to find privilege \"" + stringArray[n] + "\" - " + Kernel32.INSTANCE.GetLastError());
            }
            ++n;
        }
    }

    @Override
    public void close() {
        this.disable();
    }

    public Advapi32Util$Privilege enable() {
        if (this.privilegesEnabled) {
            return this;
        }
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        try {
            winNT$HANDLEByReference.setValue(this.getThreadToken());
            WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
            for (int i = 0; i < this.pLuids.length; ++i) {
                winNT$TOKEN_PRIVILEGES.Privileges[i] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef$DWORD(2L));
            }
            if (!Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            this.privilegesEnabled = true;
        }
        catch (Win32Exception win32Exception) {
            if (this.currentlyImpersonating) {
                Advapi32.INSTANCE.SetThreadToken(null, null);
                this.currentlyImpersonating = false;
            } else if (this.privilegesEnabled) {
                WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
                for (int i = 0; i < this.pLuids.length; ++i) {
                    winNT$TOKEN_PRIVILEGES.Privileges[i] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef$DWORD(0L));
                }
                Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null);
                this.privilegesEnabled = false;
            }
            throw win32Exception;
        }
        finally {
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLEByReference.getValue()) && winNT$HANDLEByReference.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                winNT$HANDLEByReference.setValue(null);
            }
        }
        return this;
    }

    public void disable() {
        WinNT$HANDLEByReference winNT$HANDLEByReference;
        block6: {
            winNT$HANDLEByReference = new WinNT$HANDLEByReference();
            try {
                winNT$HANDLEByReference.setValue(this.getThreadToken());
                if (this.currentlyImpersonating) {
                    Advapi32.INSTANCE.SetThreadToken(null, null);
                    break block6;
                }
                if (!this.privilegesEnabled) break block6;
                WinNT$TOKEN_PRIVILEGES winNT$TOKEN_PRIVILEGES = new WinNT$TOKEN_PRIVILEGES(this.pLuids.length);
                for (int i = 0; i < this.pLuids.length; ++i) {
                    winNT$TOKEN_PRIVILEGES.Privileges[i] = new WinNT$LUID_AND_ATTRIBUTES(this.pLuids[i], new WinDef$DWORD(0L));
                }
                Advapi32.INSTANCE.AdjustTokenPrivileges(winNT$HANDLEByReference.getValue(), false, winNT$TOKEN_PRIVILEGES, 0, null, null);
                this.privilegesEnabled = false;
            }
            catch (Throwable throwable) {
                if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLEByReference.getValue()) && winNT$HANDLEByReference.getValue() != null) {
                    Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                    winNT$HANDLEByReference.setValue(null);
                }
                throw throwable;
            }
        }
        if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLEByReference.getValue()) && winNT$HANDLEByReference.getValue() != null) {
            Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
            winNT$HANDLEByReference.setValue(null);
            return;
        }
    }

    private WinNT$HANDLE getThreadToken() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$HANDLEByReference winNT$HANDLEByReference2 = new WinNT$HANDLEByReference();
        try {
            if (!Advapi32.INSTANCE.OpenThreadToken(Kernel32.INSTANCE.GetCurrentThread(), 32, false, winNT$HANDLEByReference)) {
                int n = Kernel32.INSTANCE.GetLastError();
                if (1008 != n) {
                    throw new Win32Exception(n);
                }
                if (!Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 2, winNT$HANDLEByReference2)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                if (!Advapi32.INSTANCE.DuplicateTokenEx(winNT$HANDLEByReference2.getValue(), 36, null, 2, 2, winNT$HANDLEByReference)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                if (!Advapi32.INSTANCE.SetThreadToken(null, winNT$HANDLEByReference.getValue())) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                this.currentlyImpersonating = true;
            }
        }
        catch (Win32Exception win32Exception) {
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLEByReference.getValue()) && winNT$HANDLEByReference.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue());
                winNT$HANDLEByReference.setValue(null);
            }
            throw win32Exception;
        }
        finally {
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLEByReference2.getValue()) && winNT$HANDLEByReference2.getValue() != null) {
                Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference2.getValue());
                winNT$HANDLEByReference2.setValue(null);
            }
        }
        return winNT$HANDLEByReference.getValue();
    }
}

