/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util$1;
import com.sun.jna.platform.win32.Advapi32Util$2;
import com.sun.jna.platform.win32.Advapi32Util$AccessCheckPermission;
import com.sun.jna.platform.win32.Advapi32Util$Account;
import com.sun.jna.platform.win32.Advapi32Util$EnumKey;
import com.sun.jna.platform.win32.Advapi32Util$InfoKey;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinBase$FE_EXPORT_FUNC;
import com.sun.jna.platform.win32.WinBase$FE_IMPORT_FUNC;
import com.sun.jna.platform.win32.WinDef$BOOLByReference;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinNT$ACCESS_ACEStructure;
import com.sun.jna.platform.win32.WinNT$ACE_HEADER;
import com.sun.jna.platform.win32.WinNT$ACL;
import com.sun.jna.platform.win32.WinNT$GENERIC_MAPPING;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$PRIVILEGE_SET;
import com.sun.jna.platform.win32.WinNT$PSID;
import com.sun.jna.platform.win32.WinNT$PSIDByReference;
import com.sun.jna.platform.win32.WinNT$SECURITY_DESCRIPTOR_RELATIVE;
import com.sun.jna.platform.win32.WinNT$SID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_GROUPS;
import com.sun.jna.platform.win32.WinNT$TOKEN_PRIMARY_GROUP;
import com.sun.jna.platform.win32.WinNT$TOKEN_USER;
import com.sun.jna.platform.win32.WinReg$HKEY;
import com.sun.jna.platform.win32.WinReg$HKEYByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class Advapi32Util {
    public static String getUserName() {
        char[] cArray = new char[128];
        IntByReference intByReference = new IntByReference(128);
        boolean bl = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        if (!bl) {
            switch (Kernel32.INSTANCE.GetLastError()) {
                case 122: {
                    cArray = new char[intByReference.getValue()];
                    break;
                }
                default: {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            bl = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        }
        if (!bl) {
            throw new Win32Exception(Native.getLastError());
        }
        return Native.toString((char[])cArray);
    }

    public static Advapi32Util$Account getAccountByName(String string) {
        return Advapi32Util.getAccountByName(null, string);
    }

    public static Advapi32Util$Account getAccountByName(String object, String string) {
        String[] stringArray = new IntByReference(0);
        IntByReference intByReference = new IntByReference(0);
        String[] stringArray2 = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountName((String)object, string, null, (IntByReference)stringArray, null, intByReference, (PointerByReference)stringArray2)) {
            throw new RuntimeException("LookupAccountNameW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n = Kernel32.INSTANCE.GetLastError();
        if (stringArray.getValue() == 0 || n != 122) {
            throw new Win32Exception(n);
        }
        Object object2 = new Memory((long)stringArray.getValue());
        char[] cArray = new char[intByReference.getValue() + 1];
        if (!Advapi32.INSTANCE.LookupAccountName((String)object, string, (WinNT$PSID)((Object)(object2 = new WinNT$PSID((Pointer)object2))), (IntByReference)stringArray, cArray, intByReference, (PointerByReference)stringArray2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object = new Advapi32Util$Account();
        new Advapi32Util$Account().accountType = stringArray2.getPointer().getInt(0L);
        stringArray = string.split("\\\\", 2);
        stringArray2 = string.split("@", 2);
        ((Advapi32Util$Account)object).name = stringArray.length == 2 ? stringArray[1] : (stringArray2.length == 2 ? stringArray2[0] : string);
        if (intByReference.getValue() > 0) {
            ((Advapi32Util$Account)object).domain = Native.toString((char[])cArray);
            ((Advapi32Util$Account)object).fqn = ((Advapi32Util$Account)object).domain + "\\" + ((Advapi32Util$Account)object).name;
        } else {
            ((Advapi32Util$Account)object).fqn = ((Advapi32Util$Account)object).name;
        }
        ((Advapi32Util$Account)object).sid = ((WinNT$PSID)((Object)object2)).getBytes();
        ((Advapi32Util$Account)object).sidString = Advapi32Util.convertSidToStringSid(new WinNT$PSID(((Advapi32Util$Account)object).sid));
        return object;
    }

    public static Advapi32Util$Account getAccountBySid(WinNT$PSID winNT$PSID) {
        return Advapi32Util.getAccountBySid(null, winNT$PSID);
    }

    public static Advapi32Util$Account getAccountBySid(String object, WinNT$PSID winNT$PSID) {
        IntByReference intByReference = new IntByReference(257);
        IntByReference intByReference2 = new IntByReference(256);
        PointerByReference pointerByReference = new PointerByReference();
        char[] cArray = new char[intByReference2.getValue()];
        char[] cArray2 = new char[intByReference.getValue()];
        int n = 0;
        if (!Advapi32.INSTANCE.LookupAccountSid((String)object, winNT$PSID, cArray2, intByReference, cArray, intByReference2, pointerByReference) && (n = Kernel32.INSTANCE.GetLastError()) != 1332) {
            throw new Win32Exception(n);
        }
        object = new Advapi32Util$Account();
        if (n == 1332) {
            ((Advapi32Util$Account)object).accountType = 8;
            ((Advapi32Util$Account)object).name = "NONE_MAPPED";
        } else {
            ((Advapi32Util$Account)object).accountType = pointerByReference.getPointer().getInt(0L);
            ((Advapi32Util$Account)object).name = Native.toString((char[])cArray2);
        }
        ((Advapi32Util$Account)object).domain = Native.toString((char[])cArray);
        ((Advapi32Util$Account)object).fqn = ((Advapi32Util$Account)object).domain.isEmpty() ? ((Advapi32Util$Account)object).name : ((Advapi32Util$Account)object).domain + "\\" + ((Advapi32Util$Account)object).name;
        ((Advapi32Util$Account)object).sid = winNT$PSID.getBytes();
        ((Advapi32Util$Account)object).sidString = Advapi32Util.convertSidToStringSid(winNT$PSID);
        return object;
    }

    public static String convertSidToStringSid(WinNT$PSID winNT$PSID) {
        Object object = new PointerByReference();
        if (!Advapi32.INSTANCE.ConvertSidToStringSid(winNT$PSID, (PointerByReference)object)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        winNT$PSID = object.getValue();
        try {
            object = winNT$PSID.getWideString(0L);
            return object;
        }
        finally {
            Kernel32Util.freeLocalMemory((Pointer)winNT$PSID);
        }
    }

    public static byte[] convertStringSidToSid(String object) {
        Object object2 = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid((String)object, (WinNT$PSIDByReference)((Object)object2))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object = object2.getValue();
        try {
            object2 = ((WinNT$PSID)((Object)object)).getBytes();
            return object2;
        }
        finally {
            Kernel32Util.freeLocalMemory(object.getPointer());
        }
    }

    public static boolean isWellKnownSid(String object, int n) {
        WinNT$PSIDByReference winNT$PSIDByReference = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid((String)object, winNT$PSIDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object = winNT$PSIDByReference.getValue();
        try {
            n = Advapi32.INSTANCE.IsWellKnownSid((WinNT$PSID)((Object)object), n) ? 1 : 0;
            return n != 0;
        }
        finally {
            Kernel32Util.freeLocalMemory(object.getPointer());
        }
    }

    public static boolean isWellKnownSid(byte[] object, int n) {
        object = (Object)new WinNT$PSID((byte[])object);
        return Advapi32.INSTANCE.IsWellKnownSid((WinNT$PSID)((Object)object), n);
    }

    public static int alignOnDWORD(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public static int getAceSize(int n) {
        return Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null) + n - 4;
    }

    public static Advapi32Util$Account getAccountBySid(String string) {
        return Advapi32Util.getAccountBySid(null, string);
    }

    public static Advapi32Util$Account getAccountBySid(String string, String string2) {
        return Advapi32Util.getAccountBySid(string, new WinNT$PSID(Advapi32Util.convertStringSidToSid(string2)));
    }

    public static Advapi32Util$Account[] getTokenGroups(WinNT$HANDLE object) {
        WinNT$SID_AND_ATTRIBUTES[] winNT$SID_AND_ATTRIBUTESArray = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation((WinNT$HANDLE)((Object)object), 2, null, 0, (IntByReference)winNT$SID_AND_ATTRIBUTESArray)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n = Kernel32.INSTANCE.GetLastError();
        if (n != 122) {
            throw new Win32Exception(n);
        }
        WinNT$TOKEN_GROUPS winNT$TOKEN_GROUPS = new WinNT$TOKEN_GROUPS(winNT$SID_AND_ATTRIBUTESArray.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation((WinNT$HANDLE)((Object)object), 2, winNT$TOKEN_GROUPS, winNT$SID_AND_ATTRIBUTESArray.getValue(), (IntByReference)winNT$SID_AND_ATTRIBUTESArray)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object = new ArrayList();
        for (WinNT$SID_AND_ATTRIBUTES winNT$SID_AND_ATTRIBUTES : winNT$TOKEN_GROUPS.getGroups()) {
            Advapi32Util$Account advapi32Util$Account;
            try {
                advapi32Util$Account = Advapi32Util.getAccountBySid(winNT$SID_AND_ATTRIBUTES.Sid);
            }
            catch (Exception exception) {
                advapi32Util$Account = new Advapi32Util$Account();
                new Advapi32Util$Account().sid = winNT$SID_AND_ATTRIBUTES.Sid.getBytes();
                advapi32Util$Account.name = advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(winNT$SID_AND_ATTRIBUTES.Sid);
                advapi32Util$Account.fqn = advapi32Util$Account.sidString;
                advapi32Util$Account.accountType = 2;
            }
            ((ArrayList)object).add(advapi32Util$Account);
        }
        return ((ArrayList)object).toArray(new Advapi32Util$Account[0]);
    }

    public static Advapi32Util$Account getTokenPrimaryGroup(WinNT$HANDLE object) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation((WinNT$HANDLE)((Object)object), 5, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n = Kernel32.INSTANCE.GetLastError();
        if (n != 122) {
            throw new Win32Exception(n);
        }
        WinNT$TOKEN_PRIMARY_GROUP winNT$TOKEN_PRIMARY_GROUP = new WinNT$TOKEN_PRIMARY_GROUP(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation((WinNT$HANDLE)((Object)object), 5, winNT$TOKEN_PRIMARY_GROUP, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            object = Advapi32Util.getAccountBySid(winNT$TOKEN_PRIMARY_GROUP.PrimaryGroup);
        }
        catch (Exception exception) {
            object = new Advapi32Util$Account();
            new Advapi32Util$Account().sid = winNT$TOKEN_PRIMARY_GROUP.PrimaryGroup.getBytes();
            ((Advapi32Util$Account)object).name = ((Advapi32Util$Account)object).sidString = Advapi32Util.convertSidToStringSid(winNT$TOKEN_PRIMARY_GROUP.PrimaryGroup);
            ((Advapi32Util$Account)object).fqn = ((Advapi32Util$Account)object).sidString;
            ((Advapi32Util$Account)object).accountType = 2;
        }
        return object;
    }

    public static Advapi32Util$Account getTokenAccount(WinNT$HANDLE winNT$HANDLE) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n = Kernel32.INSTANCE.GetLastError();
        if (n != 122) {
            throw new Win32Exception(n);
        }
        WinNT$TOKEN_USER winNT$TOKEN_USER = new WinNT$TOKEN_USER(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, winNT$TOKEN_USER, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Advapi32Util.getAccountBySid(winNT$TOKEN_USER.User.Sid);
    }

    public static Advapi32Util$Account[] getCurrentUserGroups() {
        Object object = new WinNT$HANDLEByReference();
        Win32Exception win32Exception = null;
        try {
            Advapi32Util$Account[] advapi32Util$AccountArray = Kernel32.INSTANCE.GetCurrentThread();
            if (!Advapi32.INSTANCE.OpenThreadToken((WinNT$HANDLE)advapi32Util$AccountArray, 10, true, (WinNT$HANDLEByReference)((Object)object))) {
                int n = Kernel32.INSTANCE.GetLastError();
                if (n != 1008) {
                    throw new Win32Exception(n);
                }
                WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.GetCurrentProcess();
                if (!Advapi32.INSTANCE.OpenProcessToken(winNT$HANDLE, 10, (WinNT$HANDLEByReference)((Object)object))) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            advapi32Util$AccountArray = Advapi32Util.getTokenGroups(((WinNT$HANDLEByReference)((Object)object)).getValue());
            return advapi32Util$AccountArray;
        }
        catch (Win32Exception win32Exception2) {
            Win32Exception win32Exception3 = win32Exception2;
            win32Exception = win32Exception2;
            throw win32Exception2;
        }
        finally {
            object = ((WinNT$HANDLEByReference)((Object)object)).getValue();
            if (!WinBase.INVALID_HANDLE_VALUE.equals(object)) {
                try {
                    Kernel32Util.closeHandle((WinNT$HANDLE)((Object)object));
                }
                catch (Win32Exception win32Exception4) {
                    if (win32Exception == null) {
                        win32Exception = win32Exception4;
                    }
                    win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception4));
                }
            }
            if (win32Exception != null) {
                throw win32Exception;
            }
        }
    }

    public static boolean registryKeyExists(WinReg$HKEY hKEY, String string) {
        return Advapi32Util.registryKeyExists(hKEY, string, 0);
    }

    public static boolean registryKeyExists(WinReg$HKEY hKEY, String string, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        switch (n2) {
            case 0: {
                Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new Win32Exception(n2);
    }

    public static boolean registryValueExists(WinReg$HKEY hKEY, String string, String string2) {
        return Advapi32Util.registryValueExists(hKEY, string, string2, 0);
    }

    public static boolean registryValueExists(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        switch (n2) {
            case 0: {
                break;
            }
            case 2: {
                return false;
            }
            default: {
                throw new Win32Exception(n2);
            }
        }
        try {
            IntByReference intByReference = new IntByReference();
            string = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, (IntByReference)string, (Pointer)null, intByReference);
            switch (n2) {
                case 0: 
                case 122: 
                case 234: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            throw new Win32Exception(n2);
        }
        finally {
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)winReg$HKEYByReference.getValue()) && (n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue())) != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String registryGetStringValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetStringValue(winReg$HKEY, string, string2, 0);
    }

    public static String registryGetStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            string = Advapi32Util.registryGetStringValue(winReg$HKEYByReference.getValue(), string2);
            return string;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String registryGetStringValue(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (Pointer)null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 1 && intByReference.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
        }
        if (intByReference2.getValue() == 0) {
            return "";
        }
        Memory memory = new Memory((long)(intByReference2.getValue() + Native.WCHAR_SIZE));
        memory.clear();
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (Pointer)memory, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    public static String registryGetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetExpandableStringValue(winReg$HKEY, string, string2, 0);
    }

    public static String registryGetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            string = Advapi32Util.registryGetExpandableStringValue(winReg$HKEYByReference.getValue(), string2);
            return string;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String registryGetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 2) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ");
        }
        if (intByReference2.getValue() == 0) {
            return "";
        }
        Memory memory = new Memory((long)(intByReference2.getValue() + Native.WCHAR_SIZE));
        memory.clear();
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (Pointer)memory, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    public static String[] registryGetStringArray(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetStringArray(winReg$HKEY, string, string2, 0);
    }

    public static String[] registryGetStringArray(WinReg$HKEY winReg$HKEY, String stringArray, String string, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, (String)stringArray, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            stringArray = Advapi32Util.registryGetStringArray(winReg$HKEYByReference.getValue(), string);
            return stringArray;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String[] registryGetStringArray(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 7) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_SZ");
        }
        Memory memory = new Memory((long)(intByReference2.getValue() + 2 * Native.WCHAR_SIZE));
        memory.clear();
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (Pointer)memory, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        return Advapi32Util.regMultiSzBufferToStringArray(memory);
    }

    static String[] regMultiSzBufferToStringArray(Memory memory) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((long)n < memory.size()) {
            String string;
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                string = memory.getWideString((long)n);
                n += string.length() * Native.WCHAR_SIZE;
                n += Native.WCHAR_SIZE;
            } else {
                string = memory.getString((long)n);
                n += string.length();
                ++n;
            }
            if (string.length() == 0) break;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public static byte[] registryGetBinaryValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetBinaryValue(winReg$HKEY, string, string2, 0);
    }

    public static byte[] registryGetBinaryValue(WinReg$HKEY winReg$HKEY, String object, String string, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, (String)object, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            object = Advapi32Util.registryGetBinaryValue(winReg$HKEYByReference.getValue(), string);
            return object;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static byte[] registryGetBinaryValue(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (Pointer)null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 3) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_BINARY");
        }
        byte[] byArray = new byte[intByReference2.getValue()];
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, byArray, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        return byArray;
    }

    public static int registryGetIntValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetIntValue(winReg$HKEY, string, string2, 0);
    }

    public static int registryGetIntValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            int n3 = Advapi32Util.registryGetIntValue(winReg$HKEYByReference.getValue(), string2);
            return n3;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static int registryGetIntValue(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 4) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_DWORD");
        }
        IntByReference intByReference3 = new IntByReference();
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, intByReference3, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        return intByReference3.getValue();
    }

    public static long registryGetLongValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryGetLongValue(winReg$HKEY, string, string2, 0);
    }

    public static long registryGetLongValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            long l = Advapi32Util.registryGetLongValue(winReg$HKEYByReference.getValue(), string2);
            return l;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static long registryGetLongValue(WinReg$HKEY winReg$HKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, (char[])null, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() != 11) {
            throw new RuntimeException("Unexpected registry type " + intByReference.getValue() + ", expected REG_QWORD");
        }
        LongByReference longByReference = new LongByReference();
        n = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEY, string, 0, intByReference, longByReference, intByReference2);
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        return longByReference.getValue();
    }

    public static Object registryGetValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        Object object = null;
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegGetValue(winReg$HKEY, string, string2, 65535, intByReference, (Pointer)null, intByReference2);
        if (intByReference.getValue() == 0) {
            return null;
        }
        if (n != 0 && n != 122) {
            throw new Win32Exception(n);
        }
        Memory memory = new Memory((long)(intByReference2.getValue() + Native.WCHAR_SIZE));
        memory.clear();
        n = Advapi32.INSTANCE.RegGetValue(winReg$HKEY, string, string2, 65535, intByReference, (Pointer)memory, intByReference2);
        if (n != 0) {
            throw new Win32Exception(n);
        }
        if (intByReference.getValue() == 4) {
            object = memory.getInt(0L);
        } else if (intByReference.getValue() == 11) {
            object = memory.getLong(0L);
        } else if (intByReference.getValue() == 3) {
            object = memory.getByteArray(0L, intByReference2.getValue());
        } else if (intByReference.getValue() == 1 || intByReference.getValue() == 2) {
            object = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? memory.getWideString(0L) : memory.getString(0L);
        }
        return object;
    }

    public static boolean registryCreateKey(WinReg$HKEY winReg$HKEY, String string) {
        return Advapi32Util.registryCreateKey(winReg$HKEY, string, 0);
    }

    public static boolean registryCreateKey(WinReg$HKEY winReg$HKEY, String string, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        IntByReference intByReference = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegCreateKeyEx(winReg$HKEY, string, 0, null, 0, 0x20019 | n, null, winReg$HKEYByReference, intByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        return 1 == intByReference.getValue();
    }

    public static boolean registryCreateKey(WinReg$HKEY winReg$HKEY, String string, String string2) {
        return Advapi32Util.registryCreateKey(winReg$HKEY, string, string2, 0);
    }

    public static boolean registryCreateKey(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 4 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            boolean bl = Advapi32Util.registryCreateKey(winReg$HKEYByReference.getValue(), string2);
            return bl;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetIntValue(WinReg$HKEY winReg$HKEY, String string, int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        byArray2[1] = (byte)(n >> 8);
        byArray2[2] = (byte)(n >> 16);
        byArray2[3] = (byte)(n >>> 24);
        int n2 = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 4, byArray2, 4);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    public static void registrySetIntValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        Advapi32Util.registrySetIntValue(winReg$HKEY, string, string2, n, 0);
    }

    public static void registrySetIntValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n2, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetIntValue(winReg$HKEYByReference.getValue(), string2, n);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetLongValue(WinReg$HKEY winReg$HKEY, String string, long l) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(l & 0xFFL);
        byArray2[1] = (byte)(l >> 8 & 0xFFL);
        byArray2[2] = (byte)(l >> 16 & 0xFFL);
        byArray2[3] = (byte)(l >> 24 & 0xFFL);
        byArray2[4] = (byte)(l >> 32 & 0xFFL);
        byArray2[5] = (byte)(l >> 40 & 0xFFL);
        byArray2[6] = (byte)(l >> 48 & 0xFFL);
        byArray2[7] = (byte)(l >> 56 & 0xFFL);
        int n = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 11, byArray2, 8);
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registrySetLongValue(WinReg$HKEY winReg$HKEY, String string, String string2, long l) {
        Advapi32Util.registrySetLongValue(winReg$HKEY, string, string2, l, 0);
    }

    public static void registrySetLongValue(WinReg$HKEY winReg$HKEY, String string, String string2, long l, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetLongValue(winReg$HKEYByReference.getValue(), string2, l);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetStringValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        Memory memory;
        if (string2 == null) {
            string2 = "";
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            memory = new Memory((long)((string2.length() + 1) * Native.WCHAR_SIZE));
            memory.setWideString(0L, string2);
        } else {
            memory = new Memory((long)(string2.length() + 1));
            memory.setString(0L, string2);
        }
        Memory memory2 = memory;
        int n = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 1, (Pointer)memory2, (int)memory2.size());
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registrySetStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, String string3) {
        Advapi32Util.registrySetStringValue(winReg$HKEY, string, string2, string3, 0);
    }

    public static void registrySetStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, String string3, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        Memory memory;
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            memory = new Memory((long)((string2.length() + 1) * Native.WCHAR_SIZE));
            memory.setWideString(0L, string2);
        } else {
            memory = new Memory((long)(string2.length() + 1));
            memory.setString(0L, string2);
        }
        Memory memory2 = memory;
        int n = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 2, (Pointer)memory2, (int)memory2.size());
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registrySetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, String string3) {
        Advapi32Util.registrySetExpandableStringValue(winReg$HKEY, string, string2, string3, 0);
    }

    public static void registrySetExpandableStringValue(WinReg$HKEY winReg$HKEY, String string, String string2, String string3, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetExpandableStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetStringArray(WinReg$HKEY winReg$HKEY, String string, String[] stringArray) {
        int n = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? Native.WCHAR_SIZE : 1;
        int n2 = 0;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            String string2 = stringArray2[i];
            n2 += string2.length() * n;
            n2 += n;
        }
        int n4 = 0;
        Memory memory = new Memory((long)(n2 += n));
        memory.clear();
        String[] stringArray3 = stringArray;
        int n5 = stringArray.length;
        for (int i = 0; i < n5; ++i) {
            String string3 = stringArray3[i];
            if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                memory.setWideString((long)n4, string3);
            } else {
                memory.setString((long)n4, string3);
            }
            n4 += string3.length() * n;
            n4 += n;
        }
        int n6 = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 7, (Pointer)memory, n2);
        if (n6 != 0) {
            throw new Win32Exception(n6);
        }
    }

    public static void registrySetStringArray(WinReg$HKEY winReg$HKEY, String string, String string2, String[] stringArray) {
        Advapi32Util.registrySetStringArray(winReg$HKEY, string, string2, stringArray, 0);
    }

    public static void registrySetStringArray(WinReg$HKEY winReg$HKEY, String string, String string2, String[] stringArray, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetStringArray(winReg$HKEYByReference.getValue(), string2, stringArray);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetBinaryValue(WinReg$HKEY winReg$HKEY, String string, byte[] byArray) {
        int n = Advapi32.INSTANCE.RegSetValueEx(winReg$HKEY, string, 0, 3, byArray, byArray.length);
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registrySetBinaryValue(WinReg$HKEY winReg$HKEY, String string, String string2, byte[] byArray) {
        Advapi32Util.registrySetBinaryValue(winReg$HKEY, string, string2, byArray, 0);
    }

    public static void registrySetBinaryValue(WinReg$HKEY winReg$HKEY, String string, String string2, byte[] byArray, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetBinaryValue(winReg$HKEYByReference.getValue(), string2, byArray);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registryDeleteKey(WinReg$HKEY winReg$HKEY, String string) {
        int n = Advapi32.INSTANCE.RegDeleteKey(winReg$HKEY, string);
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registryDeleteKey(WinReg$HKEY winReg$HKEY, String string, String string2) {
        Advapi32Util.registryDeleteKey(winReg$HKEY, string, string2, 0);
    }

    public static void registryDeleteKey(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registryDeleteKey(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registryDeleteValue(WinReg$HKEY winReg$HKEY, String string) {
        int n = Advapi32.INSTANCE.RegDeleteValue(winReg$HKEY, string);
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static void registryDeleteValue(WinReg$HKEY winReg$HKEY, String string, String string2) {
        Advapi32Util.registryDeleteValue(winReg$HKEY, string, string2, 0);
    }

    public static void registryDeleteValue(WinReg$HKEY winReg$HKEY, String string, String string2, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, 0x2001F | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registryDeleteValue(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String[] registryGetKeys(WinReg$HKEY winReg$HKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryInfoKey(winReg$HKEY, null, null, null, intByReference, intByReference2, null, null, null, null, null, null);
        if (n != 0) {
            throw new Win32Exception(n);
        }
        ArrayList<String> arrayList = new ArrayList<String>(intByReference.getValue());
        char[] cArray = new char[intByReference2.getValue() + 1];
        for (int i = 0; i < intByReference.getValue(); ++i) {
            IntByReference intByReference3 = new IntByReference(intByReference2.getValue() + 1);
            n = Advapi32.INSTANCE.RegEnumKeyEx(winReg$HKEY, i, cArray, intByReference3, null, null, null, null);
            if (n != 0) {
                throw new Win32Exception(n);
            }
            arrayList.add(Native.toString((char[])cArray));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] registryGetKeys(WinReg$HKEY winReg$HKEY, String string) {
        return Advapi32Util.registryGetKeys(winReg$HKEY, string, 0);
    }

    public static String[] registryGetKeys(WinReg$HKEY winReg$HKEY, String stringArray, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, (String)stringArray, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            stringArray = Advapi32Util.registryGetKeys(winReg$HKEYByReference.getValue());
            return stringArray;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static WinReg$HKEYByReference registryGetKey(WinReg$HKEY winReg$HKEY, String string, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, string, 0, n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        return winReg$HKEYByReference;
    }

    public static WinReg$HKEYByReference registryLoadAppKey(String string, int n, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegLoadAppKey(string, winReg$HKEYByReference, n, n2, 0);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return winReg$HKEYByReference;
    }

    public static void registryCloseKey(WinReg$HKEY winReg$HKEY) {
        int n = Advapi32.INSTANCE.RegCloseKey(winReg$HKEY);
        if (n != 0) {
            throw new Win32Exception(n);
        }
    }

    public static TreeMap<String, Object> registryGetValues(WinReg$HKEY winReg$HKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        int n = Advapi32.INSTANCE.RegQueryInfoKey(winReg$HKEY, null, null, null, null, null, null, intByReference, intByReference2, intByReference3, null, null);
        if (n != 0) {
            throw new Win32Exception(n);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        char[] cArray = new char[intByReference2.getValue() + 1];
        Memory memory = new Memory((long)(intByReference3.getValue() + 2 * Native.WCHAR_SIZE));
        block13: for (int i = 0; i < intByReference.getValue(); ++i) {
            memory.clear();
            IntByReference intByReference4 = new IntByReference(intByReference2.getValue() + 1);
            Object object = new IntByReference(intByReference3.getValue());
            IntByReference intByReference5 = new IntByReference();
            int n2 = Advapi32.INSTANCE.RegEnumValue(winReg$HKEY, i, cArray, intByReference4, null, intByReference5, (Pointer)memory, (IntByReference)object);
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
            String string = Native.toString((char[])cArray);
            if (object.getValue() == 0) {
                switch (intByReference5.getValue()) {
                    case 3: {
                        treeMap.put(string, new byte[0]);
                        continue block13;
                    }
                    case 1: 
                    case 2: {
                        treeMap.put(string, new char[0]);
                        continue block13;
                    }
                    case 7: {
                        treeMap.put(string, new String[0]);
                        continue block13;
                    }
                    case 0: {
                        treeMap.put(string, null);
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("Unsupported empty type: " + intByReference5.getValue());
                    }
                }
            }
            switch (intByReference5.getValue()) {
                case 11: {
                    treeMap.put(string, memory.getLong(0L));
                    continue block13;
                }
                case 4: {
                    treeMap.put(string, memory.getInt(0L));
                    continue block13;
                }
                case 1: 
                case 2: {
                    if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                        treeMap.put(string, memory.getWideString(0L));
                        continue block13;
                    }
                    treeMap.put(string, memory.getString(0L));
                    continue block13;
                }
                case 3: {
                    treeMap.put(string, memory.getByteArray(0L, object.getValue()));
                    continue block13;
                }
                case 7: {
                    object = new ArrayList();
                    int n3 = 0;
                    while ((long)n3 < memory.size()) {
                        String string2;
                        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
                            string2 = memory.getWideString((long)n3);
                            n3 += string2.length() * Native.WCHAR_SIZE;
                            n3 += Native.WCHAR_SIZE;
                        } else {
                            string2 = memory.getString((long)n3);
                            n3 += string2.length();
                            ++n3;
                        }
                        if (string2.length() == 0) break;
                        ((ArrayList)object).add(string2);
                    }
                    treeMap.put(string, ((ArrayList)object).toArray(new String[0]));
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unsupported type: " + intByReference5.getValue());
                }
            }
        }
        return treeMap;
    }

    public static TreeMap<String, Object> registryGetValues(WinReg$HKEY winReg$HKEY, String string) {
        return Advapi32Util.registryGetValues(winReg$HKEY, string, 0);
    }

    public static TreeMap<String, Object> registryGetValues(WinReg$HKEY winReg$HKEY, String object, int n) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(winReg$HKEY, (String)object, 0, 0x20019 | n, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            object = Advapi32Util.registryGetValues(winReg$HKEYByReference.getValue());
            return object;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static Advapi32Util$InfoKey registryQueryInfoKey(WinReg$HKEY winReg$HKEY, int n) {
        Advapi32Util$InfoKey advapi32Util$InfoKey = new Advapi32Util$InfoKey(winReg$HKEY, n);
        int n2 = Advapi32.INSTANCE.RegQueryInfoKey(winReg$HKEY, advapi32Util$InfoKey.lpClass, advapi32Util$InfoKey.lpcClass, null, advapi32Util$InfoKey.lpcSubKeys, advapi32Util$InfoKey.lpcMaxSubKeyLen, advapi32Util$InfoKey.lpcMaxClassLen, advapi32Util$InfoKey.lpcValues, advapi32Util$InfoKey.lpcMaxValueNameLen, advapi32Util$InfoKey.lpcMaxValueLen, advapi32Util$InfoKey.lpcbSecurityDescriptor, advapi32Util$InfoKey.lpftLastWriteTime);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        return advapi32Util$InfoKey;
    }

    public static Advapi32Util$EnumKey registryRegEnumKey(WinReg$HKEY winReg$HKEY, int n) {
        Advapi32Util$EnumKey advapi32Util$EnumKey = new Advapi32Util$EnumKey(winReg$HKEY, n);
        int n2 = Advapi32.INSTANCE.RegEnumKeyEx(winReg$HKEY, advapi32Util$EnumKey.dwIndex, advapi32Util$EnumKey.lpName, advapi32Util$EnumKey.lpcName, null, advapi32Util$EnumKey.lpClass, advapi32Util$EnumKey.lpcbClass, advapi32Util$EnumKey.lpftLastWriteTime);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        return advapi32Util$EnumKey;
    }

    public static String getEnvironmentBlock(Map<String, String> object) {
        StringBuilder stringBuilder = new StringBuilder(object.size() << 5);
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            String object2 = (String)entry.getValue();
            if (object2 == null) continue;
            stringBuilder.append(string).append("=").append(object2).append('\u0000');
        }
        return stringBuilder.append('\u0000').toString();
    }

    public static WinNT$ACE_HEADER[] getFileSecurity(String object, boolean bl) {
        Object object2;
        Memory memory;
        int n;
        int n2 = 1024;
        do {
            n = 0;
            memory = new Memory((long)n2);
            object2 = new IntByReference();
            int n3 = Advapi32.INSTANCE.GetFileSecurity((String)object, 4, (Pointer)memory, n2, (IntByReference)object2);
            if (n3 == 0) {
                n3 = Kernel32.INSTANCE.GetLastError();
                memory.clear();
                if (122 != n3) {
                    throw new Win32Exception(n3);
                }
            }
            if (n2 >= (n3 = object2.getValue())) continue;
            n = 1;
            n2 = n3;
            memory.clear();
        } while (n != 0);
        object2 = new WinNT$SECURITY_DESCRIPTOR_RELATIVE((Pointer)memory);
        Object object3 = object2.getDiscretionaryACL();
        object3 = ((WinNT$ACL)((Object)object3)).getACEs();
        if (bl) {
            object = new ArrayList();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            WinNT$ACE_HEADER[] winNT$ACE_HEADERArray = object3;
            n = ((WinNT$ACE_HEADER[])object3).length;
            for (int i = 0; i < n; ++i) {
                object2 = winNT$ACE_HEADERArray[i];
                if (object2 instanceof WinNT$ACCESS_ACEStructure) {
                    object3 = (WinNT$ACCESS_ACEStructure)((Object)object2);
                    boolean bl2 = (object2.AceFlags & 0x1F) != 0;
                    object2 = ((WinNT$ACCESS_ACEStructure)((Object)object3)).getSidString() + "/" + bl2 + "/" + object2.getClass().getName();
                    WinNT$ACCESS_ACEStructure winNT$ACCESS_ACEStructure = (WinNT$ACCESS_ACEStructure)((Object)hashMap.get(object2));
                    if (winNT$ACCESS_ACEStructure != null) {
                        int n4 = winNT$ACCESS_ACEStructure.Mask;
                        winNT$ACCESS_ACEStructure.Mask = n4 |= ((WinNT$ACCESS_ACEStructure)((Object)object3)).Mask;
                        continue;
                    }
                    hashMap.put(object2, object3);
                    object.add(winNT$ACCESS_ACEStructure);
                    continue;
                }
                object.add(object2);
            }
            return object.toArray(new WinNT$ACE_HEADER[0]);
        }
        return object3;
    }

    private static Memory getSecurityDescriptorForFile(String string) {
        IntByReference intByReference = new IntByReference();
        int n = Advapi32.INSTANCE.GetFileSecurity(string, 7, null, 0, intByReference);
        if (n == 0 && 122 != (n = Kernel32.INSTANCE.GetLastError())) {
            throw new Win32Exception(n);
        }
        n = intByReference.getValue();
        Memory memory = new Memory((long)n);
        boolean bl = Advapi32.INSTANCE.GetFileSecurity(string, 7, (Pointer)memory, n, intByReference);
        n = bl ? 1 : 0;
        if (!bl) {
            memory.clear();
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return memory;
    }

    public static Memory getSecurityDescriptorForObject(String string, int n, boolean bl) {
        Object object;
        int n2 = Advapi32.INSTANCE.GetNamedSecurityInfo(string, n, (bl = 7 | (bl ? 8 : 0)) ? 1 : 0, null, null, null, null, (PointerByReference)(object = new PointerByReference()));
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        n2 = Advapi32.INSTANCE.GetSecurityDescriptorLength(object.getValue());
        Memory memory = new Memory((long)n2);
        Pointer pointer = object.getValue();
        try {
            object = pointer.getByteArray(0L, n2);
            memory.write(0L, (byte[])object, 0, n2);
            Memory memory2 = memory;
            return memory2;
        }
        finally {
            Kernel32Util.freeLocalMemory(pointer);
        }
    }

    public static void setSecurityDescriptorForObject(String string, int n, WinNT$SECURITY_DESCRIPTOR_RELATIVE winNT$SECURITY_DESCRIPTOR_RELATIVE, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        int n2;
        WinNT$PSID winNT$PSID = winNT$SECURITY_DESCRIPTOR_RELATIVE.getOwner();
        WinNT$PSID winNT$PSID2 = winNT$SECURITY_DESCRIPTOR_RELATIVE.getGroup();
        WinNT$ACL winNT$ACL = winNT$SECURITY_DESCRIPTOR_RELATIVE.getDiscretionaryACL();
        WinNT$ACL winNT$ACL2 = winNT$SECURITY_DESCRIPTOR_RELATIVE.getSystemACL();
        int n3 = 0;
        if (bl) {
            if (winNT$PSID == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain owner");
            }
            if (!Advapi32.INSTANCE.IsValidSid(winNT$PSID)) {
                throw new IllegalArgumentException("Owner PSID is invalid");
            }
            n3 = 1;
        }
        if (bl2) {
            if (winNT$PSID2 == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain group");
            }
            if (!Advapi32.INSTANCE.IsValidSid(winNT$PSID2)) {
                throw new IllegalArgumentException("Group PSID is invalid");
            }
            n3 |= 2;
        }
        if (bl3) {
            if (winNT$ACL == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain DACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(winNT$ACL.getPointer())) {
                throw new IllegalArgumentException("DACL is invalid");
            }
            n3 |= 4;
        }
        if (bl4) {
            if (winNT$ACL2 == null) {
                throw new IllegalArgumentException("SECURITY_DESCRIPTOR_RELATIVE does not contain SACL");
            }
            if (!Advapi32.INSTANCE.IsValidAcl(winNT$ACL2.getPointer())) {
                throw new IllegalArgumentException("SACL is invalid");
            }
            n3 |= 8;
        }
        if (bl5) {
            if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x1000) != 0) {
                n3 |= Integer.MIN_VALUE;
            } else if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x1000) == 0) {
                n3 |= 0x20000000;
            }
        }
        if (bl6) {
            if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x2000) != 0) {
                n3 |= 0x40000000;
            } else if ((winNT$SECURITY_DESCRIPTOR_RELATIVE.Control & 0x2000) == 0) {
                n3 |= 0x10000000;
            }
        }
        if ((n2 = Advapi32.INSTANCE.SetNamedSecurityInfo(string, n, n3, bl ? winNT$PSID.getPointer() : null, bl2 ? winNT$PSID2.getPointer() : null, bl3 ? winNT$ACL.getPointer() : null, bl4 ? winNT$ACL2.getPointer() : null)) != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean accessCheck(File file, Advapi32Util$AccessCheckPermission object) {
        boolean bl;
        file = Advapi32Util.getSecurityDescriptorForFile(file.getAbsolutePath().replace('/', '\\'));
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        WinNT$HANDLEByReference winNT$HANDLEByReference2 = new WinNT$HANDLEByReference();
        Win32Exception win32Exception = null;
        try {
            Object object2 = Kernel32.INSTANCE.GetCurrentProcess();
            if (!Advapi32.INSTANCE.OpenProcessToken((WinNT$HANDLE)((Object)object2), 131086, winNT$HANDLEByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            if (!Advapi32.INSTANCE.DuplicateToken(winNT$HANDLEByReference.getValue(), 2, winNT$HANDLEByReference2)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            object2 = new WinNT$GENERIC_MAPPING();
            new WinNT$GENERIC_MAPPING().genericRead = new WinDef$DWORD(1179785L);
            ((WinNT$GENERIC_MAPPING)((Object)object2)).genericWrite = new WinDef$DWORD(1179926L);
            ((WinNT$GENERIC_MAPPING)((Object)object2)).genericExecute = new WinDef$DWORD(1179808L);
            ((WinNT$GENERIC_MAPPING)((Object)object2)).genericAll = new WinDef$DWORD(0x1F01FFL);
            object = new WinDef$DWORDByReference(new WinDef$DWORD(((Advapi32Util$AccessCheckPermission)((Object)object)).getCode()));
            Advapi32.INSTANCE.MapGenericMask((WinDef$DWORDByReference)((Object)object), (WinNT$GENERIC_MAPPING)((Object)object2));
            WinNT$PRIVILEGE_SET winNT$PRIVILEGE_SET = new WinNT$PRIVILEGE_SET(1);
            new WinNT$PRIVILEGE_SET(1).PrivilegeCount = new WinDef$DWORD(0L);
            WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD(winNT$PRIVILEGE_SET.size()));
            WinDef$DWORDByReference winDef$DWORDByReference2 = new WinDef$DWORDByReference();
            WinDef$BOOLByReference winDef$BOOLByReference = new WinDef$BOOLByReference();
            if (!Advapi32.INSTANCE.AccessCheck((Pointer)file, winNT$HANDLEByReference2.getValue(), ((WinDef$DWORDByReference)((Object)object)).getValue(), (WinNT$GENERIC_MAPPING)((Object)object2), winNT$PRIVILEGE_SET, winDef$DWORDByReference, winDef$DWORDByReference2, winDef$BOOLByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            bl = winDef$BOOLByReference.getValue().booleanValue();
        }
        catch (Win32Exception win32Exception2) {
            try {
                object = win32Exception2;
                win32Exception = win32Exception2;
                throw win32Exception2;
            }
            catch (Throwable throwable) {
                block17: {
                    try {
                        Kernel32Util.closeHandleRefs(winNT$HANDLEByReference, winNT$HANDLEByReference2);
                    }
                    catch (Win32Exception win32Exception4) {
                        if (win32Exception == null) {
                            win32Exception = win32Exception4;
                            break block17;
                        }
                        win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception4));
                    }
                }
                if (file != null) {
                    file.clear();
                }
                if (win32Exception != null) {
                    throw win32Exception;
                }
                throw throwable;
            }
        }
        try {
            Kernel32Util.closeHandleRefs(winNT$HANDLEByReference, winNT$HANDLEByReference2);
        }
        catch (Win32Exception win32Exception2) {
            if (win32Exception == null) {
                win32Exception = win32Exception2;
            }
            win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception2));
        }
        if (file != null) {
            file.clear();
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return bl;
    }

    public static WinNT$SECURITY_DESCRIPTOR_RELATIVE getFileSecurityDescriptor(File object, boolean bl) {
        object = Advapi32Util.getSecurityDescriptorForObject(object.getAbsolutePath().replaceAll("/", "\\"), 1, bl);
        object = new WinNT$SECURITY_DESCRIPTOR_RELATIVE((Pointer)object);
        return object;
    }

    public static void setFileSecurityDescriptor(File file, WinNT$SECURITY_DESCRIPTOR_RELATIVE winNT$SECURITY_DESCRIPTOR_RELATIVE, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        Advapi32Util.setSecurityDescriptorForObject(file.getAbsolutePath().replaceAll("/", "\\"), 1, winNT$SECURITY_DESCRIPTOR_RELATIVE, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public static void encryptFile(File object) {
        if (!Advapi32.INSTANCE.EncryptFile((String)(object = ((File)object).getAbsolutePath()))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void decryptFile(File object) {
        if (!Advapi32.INSTANCE.DecryptFile((String)(object = ((File)object).getAbsolutePath()), new WinDef$DWORD(0L))) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static int fileEncryptionStatus(File object) {
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
        if (!Advapi32.INSTANCE.FileEncryptionStatus((String)(object = ((File)object).getAbsolutePath()), winDef$DWORDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winDef$DWORDByReference.getValue().intValue();
    }

    public static void disableEncryption(File object, boolean bl) {
        if (!Advapi32.INSTANCE.EncryptionDisable((String)(object = ((File)object).getAbsolutePath()), bl)) {
            throw new Win32Exception(Native.getLastError());
        }
    }

    public static void backupEncryptedFile(File object, File file) {
        PointerByReference pointerByReference;
        Object object2;
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("destDir must be a directory.");
        }
        Object object3 = new WinDef$ULONG(0L);
        WinDef$ULONG winDef$ULONG = new WinDef$ULONG(1L);
        if (((File)object).isDirectory()) {
            winDef$ULONG.setValue(3L);
        }
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw((String)(object2 = ((File)object).getAbsolutePath()), (WinDef$ULONG)object3, pointerByReference = new PointerByReference()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object3 = new ByteArrayOutputStream();
        object2 = new Advapi32Util$1((ByteArrayOutputStream)object3);
        if (Advapi32.INSTANCE.ReadEncryptedFileRaw((WinBase$FE_EXPORT_FUNC)object2, null, pointerByReference.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            ((ByteArrayOutputStream)object3).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pointerByReference.getValue());
        object = file.getAbsolutePath() + File.separator + ((File)object).getName();
        pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.OpenEncryptedFileRaw((String)object, winDef$ULONG, pointerByReference) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        object = new IntByReference(0);
        if (Advapi32.INSTANCE.WriteEncryptedFileRaw((WinBase$FE_IMPORT_FUNC)(object = new Advapi32Util$2((IntByReference)object, (ByteArrayOutputStream)object3)), null, pointerByReference.getValue()) != 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32.INSTANCE.CloseEncryptedFileRaw(pointerByReference.getValue());
    }
}

