/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef$DWORDLONG;
import com.sun.jna.platform.win32.WinNT$LARGE_INTEGER;
import java.util.Date;

@Structure.FieldOrder(value={"dwLowDateTime", "dwHighDateTime"})
public class WinBase$FILETIME
extends Structure {
    public int dwLowDateTime;
    public int dwHighDateTime;
    private static final long EPOCH_DIFF = 11644473600000L;

    public WinBase$FILETIME(Date date) {
        long l = WinBase$FILETIME.dateToFileTime(date);
        this.dwHighDateTime = (int)(l >> 32);
        this.dwLowDateTime = (int)l;
    }

    public WinBase$FILETIME(WinNT$LARGE_INTEGER winNT$LARGE_INTEGER) {
        this.dwHighDateTime = winNT$LARGE_INTEGER.getHigh().intValue();
        this.dwLowDateTime = winNT$LARGE_INTEGER.getLow().intValue();
    }

    public WinBase$FILETIME() {
    }

    public WinBase$FILETIME(Pointer pointer) {
        super(pointer);
        this.read();
    }

    public static Date filetimeToDate(int n, int n2) {
        long l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        long l2 = l / 10000L;
        long l3 = l2 - 11644473600000L;
        return new Date(l3);
    }

    public static long dateToFileTime(Date date) {
        long l = date.getTime();
        long l2 = l + 11644473600000L;
        return l2 * 1000L * 10L;
    }

    public Date toDate() {
        return WinBase$FILETIME.filetimeToDate(this.dwHighDateTime, this.dwLowDateTime);
    }

    public long toTime() {
        return this.toDate().getTime();
    }

    public WinDef$DWORDLONG toDWordLong() {
        return new WinDef$DWORDLONG((long)this.dwHighDateTime << 32 | (long)this.dwLowDateTime & 0xFFFFFFFFL);
    }

    public String toString() {
        return super.toString() + ": " + this.toDate().toString();
    }
}

