/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;

public final class ReflectJavaArrayType
extends ReflectJavaType
implements JavaArrayType {
    private final Type reflectType;
    private final ReflectJavaType componentType;
    private final Collection<JavaAnnotation> annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaArrayType(Type type2) {
        ReflectJavaType reflectJavaType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"");
        this.reflectType = type2;
        ReflectJavaArrayType reflectJavaArrayType = this;
        type2 = reflectJavaArrayType.getReflectType();
        ReflectJavaArrayType reflectJavaArrayType2 = reflectJavaArrayType;
        if (type2 instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type2).getGenericComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"");
            reflectJavaType = ReflectJavaType.Factory.create(type3);
        } else if (type2 instanceof Class && ((Class)type2).isArray()) {
            Class<?> clazz = ((Class)type2).getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
            reflectJavaType = ReflectJavaType.Factory.create(clazz);
        } else {
            throw new IllegalArgumentException("Not an array type (" + this.getReflectType().getClass() + "): " + this.getReflectType());
        }
        reflectJavaArrayType2.componentType = reflectJavaType;
        this.annotations = CollectionsKt.emptyList();
    }

    @Override
    protected final Type getReflectType() {
        return this.reflectType;
    }

    @Override
    public final ReflectJavaType getComponentType() {
        return this.componentType;
    }

    @Override
    public final Collection<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

