/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet$ArrayIterator;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet$Companion;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet$SingletonIterator;

public final class SmartSet<T>
extends AbstractSet<T> {
    public static final SmartSet$Companion Companion = new SmartSet$Companion(null);
    private Object data;
    private int size;

    private SmartSet() {
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @Override
    public final Iterator<T> iterator() {
        if (this.size() == 0) {
            return Collections.emptySet().iterator();
        }
        if (this.size() == 1) {
            return new SmartSet$SingletonIterator<Object>(this.data);
        }
        if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object);
            return new SmartSet$ArrayIterator<Object>((Object[])object);
        }
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object);
        return TypeIntrinsics.asMutableSet((Object)object).iterator();
    }

    @Override
    public final boolean add(T t) {
        Object object;
        if (this.size() == 0) {
            this.data = t;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual((Object)this.data, t)) {
                return false;
            }
            Object[] objectArray = new Object[2];
            object = objectArray;
            objectArray[0] = this.data;
            object[1] = t;
            this.data = object;
        } else if (this.size() < 5) {
            Object object2;
            SmartSet smartSet;
            Object object3 = this.data;
            Intrinsics.checkNotNull((Object)object3);
            object = (Object[])object3;
            if (ArraysKt.contains((Object[])object, t)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (smartSet2.size() == 4) {
                object = SetsKt.linkedSetOf((Object[])Arrays.copyOf(object, ((Object[])object).length));
                LinkedHashSet linkedHashSet = object;
                SmartSet smartSet3 = smartSet2;
                linkedHashSet.add(t);
                smartSet = smartSet3;
                object2 = object;
            } else {
                Object[] objectArray = Arrays.copyOf(object, this.size() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"");
                object = objectArray;
                Object[] objectArray2 = objectArray;
                SmartSet smartSet4 = smartSet2;
                objectArray2[objectArray2.length - 1] = t;
                smartSet = smartSet4;
                object2 = object;
            }
            smartSet.data = object2;
        } else {
            Object object4 = this.data;
            Intrinsics.checkNotNull((Object)object4);
            object = TypeIntrinsics.asMutableSet((Object)object4);
            if (!object.add(t)) {
                return false;
            }
        }
        int n = this.size();
        this.setSize(n + 1);
        return true;
    }

    @Override
    public final void clear() {
        this.data = null;
        this.setSize(0);
    }

    @Override
    public final boolean contains(Object object) {
        if (this.size() == 0) {
            return false;
        }
        if (this.size() == 1) {
            return Intrinsics.areEqual((Object)this.data, (Object)object);
        }
        if (this.size() < 5) {
            Object object2 = this.data;
            Intrinsics.checkNotNull((Object)object2);
            return ArraysKt.contains((Object[])((Object[])object2), (Object)object);
        }
        Object object3 = this.data;
        Intrinsics.checkNotNull((Object)object3);
        return ((Set)object3).contains(object);
    }

    @JvmStatic
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

