/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cff.CharStringCommand$Key;
import org.apache.fontbox.cff.CharStringCommand$Type1KeyWord;
import org.apache.fontbox.cff.CharStringCommand$Type2KeyWord;

public class CharStringCommand {
    private final CharStringCommand$Type1KeyWord type1KeyWord;
    private final CharStringCommand$Type2KeyWord type2KeyWord;
    private static final Map<Integer, CharStringCommand> CHAR_STRING_COMMANDS = CharStringCommand.createMap();
    public static final CharStringCommand COMMAND_CLOSEPATH = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.CLOSEPATH));
    public static final CharStringCommand COMMAND_RLINETO = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.RLINETO));
    public static final CharStringCommand COMMAND_HLINETO = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.HLINETO));
    public static final CharStringCommand COMMAND_VLINETO = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.VLINETO));
    public static final CharStringCommand COMMAND_RRCURVETO = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.RRCURVETO));
    public static final CharStringCommand COMMAND_HSBW = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.HSBW));
    public static final CharStringCommand COMMAND_CALLOTHERSUBR = CharStringCommand.getInstance(CharStringCommand$Key.access$000(CharStringCommand$Key.CALLOTHERSUBR));
    private static final int KEY_UNKNOWN = 99;
    private static final CharStringCommand COMMAND_UNKNOWN = new CharStringCommand(99, 0);

    private static Map<Integer, CharStringCommand> createMap() {
        HashMap<Integer, CharStringCommand> hashMap = new HashMap<Integer, CharStringCommand>();
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HSTEM), new CharStringCommand(CharStringCommand$Key.HSTEM));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VSTEM), new CharStringCommand(CharStringCommand$Key.VSTEM));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VMOVETO), new CharStringCommand(CharStringCommand$Key.VMOVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RLINETO), new CharStringCommand(CharStringCommand$Key.RLINETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HLINETO), new CharStringCommand(CharStringCommand$Key.HLINETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VLINETO), new CharStringCommand(CharStringCommand$Key.VLINETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RRCURVETO), new CharStringCommand(CharStringCommand$Key.RRCURVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.CLOSEPATH), new CharStringCommand(CharStringCommand$Key.CLOSEPATH));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.CALLSUBR), new CharStringCommand(CharStringCommand$Key.CALLSUBR));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RET), new CharStringCommand(CharStringCommand$Key.RET));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.ESCAPE), new CharStringCommand(CharStringCommand$Key.ESCAPE));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HSBW), new CharStringCommand(CharStringCommand$Key.HSBW));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.ENDCHAR), new CharStringCommand(CharStringCommand$Key.ENDCHAR));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HSTEMHM), new CharStringCommand(CharStringCommand$Key.HSTEMHM));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HINTMASK), new CharStringCommand(CharStringCommand$Key.HINTMASK));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.CNTRMASK), new CharStringCommand(CharStringCommand$Key.CNTRMASK));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RMOVETO), new CharStringCommand(CharStringCommand$Key.RMOVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HMOVETO), new CharStringCommand(CharStringCommand$Key.HMOVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VSTEMHM), new CharStringCommand(CharStringCommand$Key.VSTEMHM));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RCURVELINE), new CharStringCommand(CharStringCommand$Key.RCURVELINE));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RLINECURVE), new CharStringCommand(CharStringCommand$Key.RLINECURVE));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VVCURVETO), new CharStringCommand(CharStringCommand$Key.VVCURVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HHCURVETO), new CharStringCommand(CharStringCommand$Key.HHCURVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SHORTINT), new CharStringCommand(CharStringCommand$Key.SHORTINT));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.CALLGSUBR), new CharStringCommand(CharStringCommand$Key.CALLGSUBR));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VHCURVETO), new CharStringCommand(CharStringCommand$Key.VHCURVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HVCURVETO), new CharStringCommand(CharStringCommand$Key.HVCURVETO));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.DOTSECTION), new CharStringCommand(12, 0));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.VSTEM3), new CharStringCommand(12, 1));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HSTEM3), new CharStringCommand(12, 2));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.AND), new CharStringCommand(12, 3));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.OR), new CharStringCommand(12, 4));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.NOT), new CharStringCommand(12, 5));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SEAC), new CharStringCommand(12, 6));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SBW), new CharStringCommand(12, 7));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.ABS), new CharStringCommand(12, 9));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.ADD), new CharStringCommand(12, 10));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SUB), new CharStringCommand(12, 11));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.DIV), new CharStringCommand(12, 12));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.NEG), new CharStringCommand(12, 14));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.EQ), new CharStringCommand(12, 15));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.CALLOTHERSUBR), new CharStringCommand(12, 16));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.POP), new CharStringCommand(12, 17));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.DROP), new CharStringCommand(12, 18));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.PUT), new CharStringCommand(12, 20));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.GET), new CharStringCommand(12, 21));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.IFELSE), new CharStringCommand(12, 22));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.RANDOM), new CharStringCommand(12, 23));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.MUL), new CharStringCommand(12, 24));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SQRT), new CharStringCommand(12, 26));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.DUP), new CharStringCommand(12, 27));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.EXCH), new CharStringCommand(12, 28));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.INDEX), new CharStringCommand(12, 29));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.ROLL), new CharStringCommand(12, 30));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.SETCURRENTPOINT), new CharStringCommand(12, 33));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HFLEX), new CharStringCommand(12, 34));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.FLEX), new CharStringCommand(12, 35));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.HFLEX1), new CharStringCommand(12, 36));
        hashMap.put(CharStringCommand$Key.access$000(CharStringCommand$Key.FLEX1), new CharStringCommand(12, 37));
        return hashMap;
    }

    private CharStringCommand(CharStringCommand$Key charStringCommand$Key) {
        this.type1KeyWord = CharStringCommand$Type1KeyWord.valueOfKey(CharStringCommand$Key.access$000(charStringCommand$Key));
        this.type2KeyWord = CharStringCommand$Type2KeyWord.valueOfKey(CharStringCommand$Key.access$000(charStringCommand$Key));
    }

    private CharStringCommand(int n, int n2) {
        this.type1KeyWord = CharStringCommand$Type1KeyWord.valueOfKey(n, n2);
        this.type2KeyWord = CharStringCommand$Type2KeyWord.valueOfKey(n, n2);
    }

    public static CharStringCommand getInstance(int n) {
        CharStringCommand charStringCommand = CHAR_STRING_COMMANDS.get(n);
        if (charStringCommand != null) {
            return charStringCommand;
        }
        return COMMAND_UNKNOWN;
    }

    public static CharStringCommand getInstance(int n, int n2) {
        CharStringCommand charStringCommand = CHAR_STRING_COMMANDS.get(CharStringCommand.getKeyHashValue(n, n2));
        if (charStringCommand != null) {
            return charStringCommand;
        }
        return COMMAND_UNKNOWN;
    }

    public static CharStringCommand getInstance(int[] nArray) {
        if (nArray.length == 1) {
            return CharStringCommand.getInstance(nArray[0]);
        }
        if (nArray.length == 2) {
            return CharStringCommand.getInstance(nArray[0], nArray[1]);
        }
        return COMMAND_UNKNOWN;
    }

    private static int getKeyHashValue(int n, int n2) {
        CharStringCommand$Type1KeyWord charStringCommand$Type1KeyWord = CharStringCommand$Type1KeyWord.valueOfKey(n, n2);
        if (charStringCommand$Type1KeyWord != null) {
            return CharStringCommand$Key.access$000(charStringCommand$Type1KeyWord.key);
        }
        CharStringCommand$Type2KeyWord charStringCommand$Type2KeyWord = CharStringCommand$Type2KeyWord.valueOfKey(n, n2);
        if (charStringCommand$Type2KeyWord != null) {
            return CharStringCommand$Key.access$000(charStringCommand$Type2KeyWord.key);
        }
        return 99;
    }

    public CharStringCommand$Type1KeyWord getType1KeyWord() {
        return this.type1KeyWord;
    }

    public CharStringCommand$Type2KeyWord getType2KeyWord() {
        return this.type2KeyWord;
    }

    public String toString() {
        String string = this.type2KeyWord != null ? this.type2KeyWord.toString() : (this.type1KeyWord != null ? this.type1KeyWord.toString() : "unknown command");
        return string + '|';
    }

    public int hashCode() {
        if (this.type1KeyWord != null) {
            return this.type1KeyWord.key.hashCode();
        }
        if (this.type2KeyWord != null) {
            return this.type2KeyWord.key.hashCode();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof CharStringCommand) {
            object = (CharStringCommand)object;
            if (this.type1KeyWord != null && this.type1KeyWord == ((CharStringCommand)object).getType1KeyWord()) {
                return true;
            }
            if (this.type2KeyWord != null && this.type2KeyWord == ((CharStringCommand)object).getType2KeyWord()) {
                return true;
            }
            if (this.type1KeyWord == null && this.type2KeyWord == null) {
                return true;
            }
        }
        return false;
    }
}

