/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.pfb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PfbParser {
    private static final Log LOG = LogFactory.getLog(PfbParser.class);
    private static final int PFB_HEADER_LENGTH = 18;
    private static final int START_MARKER = 128;
    private static final int ASCII_MARKER = 1;
    private static final int BINARY_MARKER = 2;
    private static final int EOF_MARKER = 3;
    private static final int BUFFER_SIZE = 65535;
    private byte[] pfbdata;
    private final int[] lengths = new int[3];

    public PfbParser(String string) {
        this(Files.readAllBytes(Paths.get(string, new String[0])));
    }

    public PfbParser(InputStream object) {
        object = this.readFully((InputStream)object);
        this.parsePfb((byte[])object);
    }

    public PfbParser(byte[] byArray) {
        this.parsePfb(byArray);
    }

    private void parsePfb(byte[] object) {
        byte[] byArray;
        int n;
        int n2;
        int n3;
        int n4;
        if (((byte[])object).length < 18) {
            throw new IOException("PFB header missing");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(3);
        object = new ByteArrayInputStream((byte[])object);
        for (n2 = 0; (n3 = ((ByteArrayInputStream)object).read()) != -1 || n2 <= 0; n2 += n4) {
            if (n3 != 128) {
                throw new IOException("Start marker missing");
            }
            n = ((ByteArrayInputStream)object).read();
            if (n == 3) break;
            if (n != 1 && n != 2) {
                throw new IOException("Incorrect record type: " + n);
            }
            n4 = ((ByteArrayInputStream)object).read();
            n4 += ((ByteArrayInputStream)object).read() << 8;
            n4 += ((ByteArrayInputStream)object).read() << 16;
            n4 += ((ByteArrayInputStream)object).read() << 24;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("record type: " + n + ", segment size: " + n4));
            }
            if ((n3 = ((InputStream)object).read(byArray = new byte[n4])) != n4) {
                throw new EOFException("EOF while reading PFB font");
            }
            arrayList.add(n);
            arrayList2.add(byArray);
        }
        this.pfbdata = new byte[n2];
        byte[] byArray2 = null;
        n = 0;
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if ((Integer)arrayList.get(n4) != 1) continue;
            byArray = (byte[])arrayList2.get(n4);
            if (n4 == arrayList.size() - 1 && byArray.length < 600 && new String(byArray).contains("cleartomark")) {
                byArray2 = byArray;
                continue;
            }
            System.arraycopy(byArray, 0, this.pfbdata, n, byArray.length);
            n += byArray.length;
        }
        this.lengths[0] = n;
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            if ((Integer)arrayList.get(n4) != 2) continue;
            byArray = (byte[])arrayList2.get(n4);
            System.arraycopy(byArray, 0, this.pfbdata, n, byArray.length);
            n += byArray.length;
        }
        this.lengths[1] = n - this.lengths[0];
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, this.pfbdata, n, byArray2.length);
            this.lengths[2] = byArray2.length;
        }
    }

    private byte[] readFully(InputStream inputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65535];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public byte[] getPfbdata() {
        return this.pfbdata;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.pfbdata);
    }

    public int size() {
        return this.pfbdata.length;
    }

    public byte[] getSegment1() {
        return Arrays.copyOfRange(this.pfbdata, 0, this.lengths[0]);
    }

    public byte[] getSegment2() {
        return Arrays.copyOfRange(this.pfbdata, this.lengths[0], this.lengths[0] + this.lengths[1]);
    }
}

