/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.NullSampledStatisticsImpl;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerMBeanImpl$Emitter;
import org.quartz.core.SampledStatistics;
import org.quartz.core.SampledStatisticsImpl;
import org.quartz.core.jmx.JobDetailSupport;
import org.quartz.core.jmx.JobExecutionContextSupport;
import org.quartz.core.jmx.QuartzSchedulerMBean;
import org.quartz.core.jmx.TriggerSupport;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.AbstractTrigger;

public class QuartzSchedulerMBeanImpl
extends StandardMBean
implements NotificationEmitter,
JobListener,
SchedulerListener,
QuartzSchedulerMBean {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final QuartzScheduler scheduler;
    private boolean sampledStatisticsEnabled;
    private SampledStatistics sampledStatistics;
    private static final SampledStatistics NULL_SAMPLED_STATISTICS;
    protected final QuartzSchedulerMBeanImpl$Emitter emitter = new QuartzSchedulerMBeanImpl$Emitter(this, null);
    protected final AtomicLong sequenceNumber = new AtomicLong();

    protected QuartzSchedulerMBeanImpl(QuartzScheduler quartzScheduler) {
        super(QuartzSchedulerMBean.class);
        this.scheduler = quartzScheduler;
        this.scheduler.addInternalJobListener(this);
        this.scheduler.addInternalSchedulerListener(this);
        this.sampledStatistics = NULL_SAMPLED_STATISTICS;
        this.sampledStatisticsEnabled = false;
    }

    @Override
    public TabularData getCurrentlyExecutingJobs() {
        try {
            List<JobExecutionContext> list = this.scheduler.getCurrentlyExecutingJobs();
            return JobExecutionContextSupport.toTabularData(list);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public TabularData getAllJobDetails() {
        try {
            ArrayList<JobDetail> arrayList = new ArrayList<JobDetail>();
            for (String string : this.scheduler.getJobGroupNames()) {
                for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                    arrayList.add(this.scheduler.getJobDetail(jobKey));
                }
            }
            ArrayList<JobDetail> arrayList2 = arrayList;
            return JobDetailSupport.toTabularData(arrayList2.toArray(new JobDetail[arrayList2.size()]));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<CompositeData> getAllTriggers() {
        try {
            ArrayList<Trigger> arrayList = new ArrayList<Trigger>();
            for (String string : this.scheduler.getTriggerGroupNames()) {
                for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string))) {
                    arrayList.add(this.scheduler.getTrigger(triggerKey));
                }
            }
            return TriggerSupport.toCompositeList(arrayList);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void addJob(CompositeData compositeData, boolean bl) {
        try {
            this.scheduler.addJob(JobDetailSupport.newJobDetail(compositeData), bl);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private static void invokeSetter(Object object, String string, Object object2) {
        Object object3 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Class[] classArray = new Class[]{object2.getClass()};
        object3 = QuartzSchedulerMBeanImpl.findMethod(object.getClass(), (String)object3, classArray);
        if (object3 != null) {
            ((Method)object3).invoke(object, object2);
            return;
        }
        throw new Exception("Unable to find setter for attribute '" + string + "' and value '" + object2 + "'");
    }

    private static Class<?> getWrapperIfPrimitive(Class<?> annotatedElement) {
        Class clazz = annotatedElement;
        try {
            annotatedElement = ((Class)annotatedElement).getField("TYPE");
            ((Field)annotatedElement).setAccessible(true);
            clazz = (Class)((Field)annotatedElement).get(null);
        }
        catch (Exception exception) {}
        return clazz;
    }

    private static Method findMethod(Class<?> methodDescriptorArray, String string, Class<?>[] classArray) {
        if ((methodDescriptorArray = Introspector.getBeanInfo(methodDescriptorArray)) != null) {
            for (MethodDescriptor methodDescriptor : methodDescriptorArray.getMethodDescriptors()) {
                Method object = methodDescriptor.getMethod();
                Class<?>[] classArray2 = object.getParameterTypes();
                if (!string.equals(object.getName()) || classArray.length != classArray2.length) continue;
                boolean bl = true;
                for (int i = 0; i < classArray.length; ++i) {
                    if (QuartzSchedulerMBeanImpl.getWrapperIfPrimitive(classArray[i]) == classArray2[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public void scheduleBasicJob(Map<String, Object> object, Map<String, Object> object2) {
        try {
            object = JobDetailSupport.newJobDetail(object);
            object2 = TriggerSupport.newTrigger(object2);
            this.scheduler.deleteJob(object.getKey());
            this.scheduler.scheduleJob((JobDetail)object, (Trigger)object2);
            return;
        }
        catch (ParseException parseException) {
            object = parseException;
            throw parseException;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void scheduleJob(Map<String, Object> map, Map<String, Object> object) {
        try {
            String string;
            Object object2 = (String)object.remove("triggerClass");
            if (object2 == null) {
                throw new IllegalArgumentException("No triggerClass specified");
            }
            object2 = Class.forName((String)object2);
            object2 = (Trigger)((Class)object2).newInstance();
            Object object3 = (String)map.remove("jobDetailClass");
            if (object3 == null) {
                throw new IllegalArgumentException("No jobDetailClass specified");
            }
            object3 = Class.forName((String)object3);
            object3 = (JobDetail)((Class)object3).newInstance();
            String object42 = (String)map.remove("jobClass");
            if (object42 == null) {
                throw new IllegalArgumentException("No jobClass specified");
            }
            Class<?> clazz = Class.forName(object42);
            map.put("jobClass", clazz);
            for (Map.Entry entry : object.entrySet()) {
                void var5_12;
                string = (String)entry.getKey();
                Object v = entry.getValue();
                if ("jobDataMap".equals(string)) {
                    JobDataMap jobDataMap = new JobDataMap((Map)v);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(object2, string, var5_12);
            }
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                void var5_17;
                string = (String)entry.getKey();
                Object object4 = entry.getValue();
                if ("jobDataMap".equals(string)) {
                    JobDataMap jobDataMap = new JobDataMap((Map)object4);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(object3, string, var5_17);
            }
            object = (AbstractTrigger)object2;
            ((AbstractTrigger)object).setKey(new TriggerKey(((AbstractTrigger)object).getName(), ((AbstractTrigger)object).getGroup()));
            Date date = ((AbstractTrigger)object).getStartTime();
            if (date == null || date.before(new Date())) {
                ((AbstractTrigger)object).setStartTime(new Date());
            }
            this.scheduler.deleteJob(object3.getKey());
            this.scheduler.scheduleJob((JobDetail)object3, (Trigger)object2);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void scheduleJob(String object, String object2, Map<String, Object> object32) {
        try {
            object = new JobKey((String)object, (String)object2);
            object2 = this.scheduler.getJobDetail((JobKey)object);
            if (object2 == null) {
                throw new IllegalArgumentException("No such job '" + object + "'");
            }
            object = (String)object32.remove("triggerClass");
            if (object == null) {
                throw new IllegalArgumentException("No triggerClass specified");
            }
            object = Class.forName((String)object);
            object = (Trigger)((Class)object).newInstance();
            for (Map.Entry entry : object32.entrySet()) {
                void var3_9;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if ("jobDataMap".equals(string)) {
                    JobDataMap jobDataMap = new JobDataMap((Map)v);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(object, string, var3_9);
            }
            object2 = (AbstractTrigger)object;
            ((AbstractTrigger)object2).setKey(new TriggerKey(((AbstractTrigger)object2).getName(), ((AbstractTrigger)object2).getGroup()));
            Date date = ((AbstractTrigger)object2).getStartTime();
            if (date == null || date.before(new Date())) {
                ((AbstractTrigger)object2).setStartTime(new Date());
            }
            this.scheduler.scheduleJob((Trigger)object);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addJob(Map<String, Object> object, boolean bl) {
        try {
            Object object2 = (String)object.remove("jobDetailClass");
            if (object2 == null) {
                throw new IllegalArgumentException("No jobDetailClass specified");
            }
            object2 = Class.forName((String)object2);
            object2 = (JobDetail)((Class)object2).newInstance();
            String object32 = (String)object.remove("jobClass");
            if (object32 == null) {
                throw new IllegalArgumentException("No jobClass specified");
            }
            Class<?> clazz = Class.forName(object32);
            object.put("jobClass", clazz);
            for (Map.Entry entry : object.entrySet()) {
                void var4_11;
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if ("jobDataMap".equals(string)) {
                    JobDataMap jobDataMap = new JobDataMap((Map)v);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(object2, string, var4_11);
            }
            this.scheduler.addJob((JobDetail)object2, bl);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private Exception newPlainException(Exception exception) {
        Object object = exception.getClass().getName();
        if (((String)object).startsWith("java.") || ((String)object).startsWith("javax.")) {
            return exception;
        }
        object = new Exception(exception.getMessage());
        ((Throwable)object).setStackTrace(exception.getStackTrace());
        return object;
    }

    @Override
    public void deleteCalendar(String string) {
        try {
            this.scheduler.deleteCalendar(string);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean deleteJob(String string, String string2) {
        try {
            return this.scheduler.deleteJob(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getCalendarNames() {
        try {
            return this.scheduler.getCalendarNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public CompositeData getJobDetail(String object, String string) {
        try {
            object = this.scheduler.getJobDetail(JobKey.jobKey((String)object, string));
            return JobDetailSupport.toCompositeData((JobDetail)object);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getJobGroupNames() {
        try {
            return this.scheduler.getJobGroupNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getJobNames(String object) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)object))) {
                arrayList.add(jobKey.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getJobStoreClassName() {
        return this.scheduler.getJobStoreClass().getName();
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        try {
            return this.scheduler.getPausedTriggerGroups();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public CompositeData getTrigger(String object, String string) {
        try {
            object = this.scheduler.getTrigger(TriggerKey.triggerKey((String)object, string));
            return TriggerSupport.toCompositeData((Trigger)object);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() {
        try {
            return this.scheduler.getTriggerGroupNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getTriggerNames(String object) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)object))) {
                arrayList.add(triggerKey.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getTriggerState(String object, String string) {
        try {
            object = TriggerKey.triggerKey((String)object, string);
            object = this.scheduler.getTriggerState((TriggerKey)object);
            return ((Enum)object).name();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<CompositeData> getTriggersOfJob(String object, String string) {
        try {
            object = JobKey.jobKey((String)object, string);
            return TriggerSupport.toCompositeList(this.scheduler.getTriggersOfJob((JobKey)object));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean interruptJob(String string, String string2) {
        try {
            return this.scheduler.interrupt(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean interruptJob(String string) {
        try {
            return this.scheduler.interrupt(string);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public Date scheduleJob(String object, String object2, String object3, String string) {
        try {
            object = JobKey.jobKey((String)object, (String)object2);
            object2 = this.scheduler.getJobDetail((JobKey)object);
            if (object2 == null) {
                throw new IllegalArgumentException("No such job: " + object);
            }
            object = TriggerKey.triggerKey((String)object3, string);
            if ((object3 = this.scheduler.getTrigger((TriggerKey)object)) == null) {
                throw new IllegalArgumentException("No such trigger: " + object);
            }
            return this.scheduler.scheduleJob((JobDetail)object2, (Trigger)object3);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean unscheduleJob(String string, String string2) {
        try {
            return this.scheduler.unscheduleJob(TriggerKey.triggerKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void clear() {
        try {
            this.scheduler.clear();
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getVersion() {
        return this.scheduler.getVersion();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    @Override
    public boolean isStarted() {
        return this.scheduler.isStarted();
    }

    @Override
    public void start() {
        try {
            this.scheduler.start();
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public void standby() {
        this.scheduler.standby();
    }

    @Override
    public boolean isStandbyMode() {
        return this.scheduler.isInStandbyMode();
    }

    @Override
    public String getSchedulerName() {
        return this.scheduler.getSchedulerName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.scheduler.getSchedulerInstanceId();
    }

    @Override
    public String getThreadPoolClassName() {
        return this.scheduler.getThreadPoolClass().getName();
    }

    @Override
    public int getThreadPoolSize() {
        return this.scheduler.getThreadPoolSize();
    }

    @Override
    public void pauseJob(String string, String string2) {
        try {
            this.scheduler.pauseJob(JobKey.jobKey(string, string2));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        try {
            this.scheduler.pauseJobs(groupMatcher);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void pauseJobGroup(String string) {
        this.pauseJobs(GroupMatcher.groupEquals(string));
    }

    @Override
    public void pauseJobsStartingWith(String string) {
        this.pauseJobs(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void pauseJobsEndingWith(String string) {
        this.pauseJobs(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void pauseJobsContaining(String string) {
        this.pauseJobs(GroupMatcher.groupContains(string));
    }

    @Override
    public void pauseJobsAll() {
        this.pauseJobs(GroupMatcher.anyJobGroup());
    }

    @Override
    public void pauseAllTriggers() {
        try {
            this.scheduler.pauseAll();
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.scheduler.pauseTriggers(groupMatcher);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void pauseTriggerGroup(String string) {
        this.pauseTriggers(GroupMatcher.groupEquals(string));
    }

    @Override
    public void pauseTriggersStartingWith(String string) {
        this.pauseTriggers(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void pauseTriggersEndingWith(String string) {
        this.pauseTriggers(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void pauseTriggersContaining(String string) {
        this.pauseTriggers(GroupMatcher.groupContains(string));
    }

    @Override
    public void pauseTriggersAll() {
        this.pauseTriggers(GroupMatcher.anyTriggerGroup());
    }

    @Override
    public void pauseTrigger(String string, String string2) {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey(string, string2));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeAllTriggers() {
        try {
            this.scheduler.resumeAll();
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeJob(String string, String string2) {
        try {
            this.scheduler.resumeJob(JobKey.jobKey(string, string2));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        try {
            this.scheduler.resumeJobs(groupMatcher);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeJobGroup(String string) {
        this.resumeJobs(GroupMatcher.groupEquals(string));
    }

    @Override
    public void resumeJobsStartingWith(String string) {
        this.resumeJobs(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void resumeJobsEndingWith(String string) {
        this.resumeJobs(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void resumeJobsContaining(String string) {
        this.resumeJobs(GroupMatcher.groupContains(string));
    }

    @Override
    public void resumeJobsAll() {
        this.resumeJobs(GroupMatcher.anyJobGroup());
    }

    @Override
    public void resumeTrigger(String string, String string2) {
        try {
            this.scheduler.resumeTrigger(TriggerKey.triggerKey(string, string2));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        try {
            this.scheduler.resumeTriggers(groupMatcher);
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeTriggerGroup(String string) {
        this.resumeTriggers(GroupMatcher.groupEquals(string));
    }

    @Override
    public void resumeTriggersStartingWith(String string) {
        this.resumeTriggers(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void resumeTriggersEndingWith(String string) {
        this.resumeTriggers(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void resumeTriggersContaining(String string) {
        this.resumeTriggers(GroupMatcher.groupContains(string));
    }

    @Override
    public void resumeTriggersAll() {
        this.resumeTriggers(GroupMatcher.anyTriggerGroup());
    }

    @Override
    public void triggerJob(String string, String string2, Map<String, String> map) {
        try {
            this.scheduler.triggerJob(JobKey.jobKey(string, string2), new JobDataMap(map));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void triggerJob(CompositeData compositeData) {
        try {
            this.scheduler.triggerJob(TriggerSupport.newTrigger(compositeData));
            return;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void jobAdded(JobDetail jobDetail) {
        this.sendNotification("jobAdded", JobDetailSupport.toCompositeData(jobDetail));
    }

    @Override
    public void jobDeleted(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobDeleted", hashMap);
    }

    @Override
    public void jobScheduled(Trigger trigger) {
        this.sendNotification("jobScheduled", TriggerSupport.toCompositeData(trigger));
    }

    @Override
    public void jobUnscheduled(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", triggerKey.getName());
        hashMap.put("triggerGroup", triggerKey.getGroup());
        this.sendNotification("jobUnscheduled", hashMap);
    }

    @Override
    public void schedulingDataCleared() {
        this.sendNotification("schedulingDataCleared");
    }

    @Override
    public void jobPaused(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobsPaused", hashMap);
    }

    @Override
    public void jobsPaused(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", null);
        hashMap.put("jobGroup", string);
        this.sendNotification("jobsPaused", hashMap);
    }

    @Override
    public void jobsResumed(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", null);
        hashMap.put("jobGroup", string);
        this.sendNotification("jobsResumed", hashMap);
    }

    @Override
    public void jobResumed(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobsResumed", hashMap);
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        this.sendNotification("schedulerError", schedulerException.getMessage());
    }

    @Override
    public void schedulerStarted() {
        this.sendNotification("schedulerStarted");
    }

    @Override
    public void schedulerStarting() {
    }

    @Override
    public void schedulerInStandbyMode() {
        this.sendNotification("schedulerPaused");
    }

    @Override
    public void schedulerShutdown() {
        this.scheduler.removeInternalSchedulerListener(this);
        this.scheduler.removeInternalJobListener(this.getName());
        this.sendNotification("schedulerShutdown");
    }

    @Override
    public void schedulerShuttingdown() {
    }

    @Override
    public void triggerFinalized(Trigger trigger) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", trigger.getKey().getName());
        hashMap.put("triggerGroup", trigger.getKey().getGroup());
        this.sendNotification("triggerFinalized", hashMap);
    }

    @Override
    public void triggersPaused(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", null);
        hashMap.put("triggerGroup", string);
        this.sendNotification("triggersPaused", hashMap);
    }

    @Override
    public void triggerPaused(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (triggerKey != null) {
            hashMap.put("triggerName", triggerKey.getName());
            hashMap.put("triggerGroup", triggerKey.getGroup());
        }
        this.sendNotification("triggersPaused", hashMap);
    }

    @Override
    public void triggersResumed(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", null);
        hashMap.put("triggerGroup", string);
        this.sendNotification("triggersResumed", hashMap);
    }

    @Override
    public void triggerResumed(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (triggerKey != null) {
            hashMap.put("triggerName", triggerKey.getName());
            hashMap.put("triggerGroup", triggerKey.getGroup());
        }
        this.sendNotification("triggersResumed", hashMap);
    }

    @Override
    public String getName() {
        return "QuartzSchedulerMBeanImpl.listener";
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        try {
            this.sendNotification("jobExecutionVetoed", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        try {
            this.sendNotification("jobToBeExecuted", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            this.sendNotification("jobWasExecuted", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    public void sendNotification(String string) {
        this.sendNotification(string, null, null);
    }

    public void sendNotification(String string, Object object) {
        this.sendNotification(string, object, null);
    }

    public void sendNotification(String object, Object object2, String string) {
        QuartzSchedulerMBeanImpl quartzSchedulerMBeanImpl = this;
        object = new Notification((String)object, quartzSchedulerMBeanImpl, quartzSchedulerMBeanImpl.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), string);
        if (object2 != null) {
            ((Notification)object).setUserData(object2);
        }
        this.emitter.sendNotification((Notification)object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) {
        this.emitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public synchronized boolean isSampledStatisticsEnabled() {
        return this.sampledStatisticsEnabled;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean bl) {
        if (bl != this.sampledStatisticsEnabled) {
            this.sampledStatisticsEnabled = bl;
            if (bl) {
                this.sampledStatistics = new SampledStatisticsImpl(this.scheduler);
            } else {
                this.sampledStatistics.shutdown();
                this.sampledStatistics = NULL_SAMPLED_STATISTICS;
            }
            this.sendNotification("sampledStatisticsEnabled", bl);
        }
    }

    @Override
    public long getJobsCompletedMostRecentSample() {
        return this.sampledStatistics.getJobsCompletedMostRecentSample();
    }

    @Override
    public long getJobsExecutedMostRecentSample() {
        return this.sampledStatistics.getJobsExecutingMostRecentSample();
    }

    @Override
    public long getJobsScheduledMostRecentSample() {
        return this.sampledStatistics.getJobsScheduledMostRecentSample();
    }

    @Override
    public Map<String, Long> getPerformanceMetrics() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("JobsCompleted", this.getJobsCompletedMostRecentSample());
        hashMap.put("JobsExecuted", this.getJobsExecutedMostRecentSample());
        hashMap.put("JobsScheduled", this.getJobsScheduledMostRecentSample());
        return hashMap;
    }

    static {
        NULL_SAMPLED_STATISTICS = new NullSampledStatisticsImpl();
        String[] stringArray = new String[]{"schedulerStarted", "schedulerPaused", "schedulerShutdown"};
        String string = Notification.class.getName();
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, string, "QuartzScheduler JMX Event")};
    }
}

