/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.spi.TriggerFiredBundle;

public class JTAJobRunShell
extends JobRunShell {
    private final Integer transactionTimeout;
    private UserTransaction ut;

    public JTAJobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle) {
        super(scheduler, triggerFiredBundle);
        this.transactionTimeout = null;
    }

    public JTAJobRunShell(Scheduler scheduler, TriggerFiredBundle triggerFiredBundle, int n) {
        super(scheduler, triggerFiredBundle);
        this.transactionTimeout = n;
    }

    @Override
    protected void begin() {
        this.cleanupUserTransaction();
        try {
            try {
                this.getLog().debug("Looking up UserTransaction.");
                this.ut = UserTransactionHelper.lookupUserTransaction();
                if (this.transactionTimeout != null) {
                    this.ut.setTransactionTimeout(this.transactionTimeout.intValue());
                }
                this.getLog().debug("Beginning UserTransaction.");
                this.ut.begin();
                return;
            }
            catch (SchedulerException schedulerException) {
                SchedulerException schedulerException2 = schedulerException;
                throw schedulerException;
            }
            catch (Exception exception) {
                throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", exception);
            }
        }
        catch (Throwable throwable) {
            this.cleanupUserTransaction();
            throw throwable;
        }
    }

    @Override
    protected void complete(boolean bl) {
        if (this.ut == null) {
            return;
        }
        try {
            try {
                if (this.ut.getStatus() == 1) {
                    this.getLog().debug("UserTransaction marked for rollback only.");
                    bl = false;
                }
            }
            catch (SystemException systemException) {
                throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", systemException);
            }
            if (bl) {
                try {
                    this.getLog().debug("Committing UserTransaction.");
                    this.ut.commit();
                }
                catch (Exception exception) {
                    throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", exception);
                }
            }
            try {
                this.getLog().debug("Rolling-back UserTransaction.");
                this.ut.rollback();
            }
            catch (Exception exception) {
                throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", exception);
            }
            return;
        }
        finally {
            this.cleanupUserTransaction();
        }
    }

    @Override
    public void passivate() {
        this.cleanupUserTransaction();
        super.passivate();
    }

    private void cleanupUserTransaction() {
        if (this.ut != null) {
            UserTransactionHelper.returnUserTransaction(this.ut);
            this.ut = null;
        }
    }
}

