/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.LoadingLoaderClassLoadHelper;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.simpl.ThreadContextClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private LinkedList<ClassLoadHelper> loadHelpers;
    private ClassLoadHelper bestCandidate;

    @Override
    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        for (ClassLoadHelper classLoadHelper : this.loadHelpers) {
            classLoadHelper.initialize();
        }
    }

    @Override
    public Class<?> loadClass(String string) {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(string);
            }
            catch (Throwable throwable) {
                this.bestCandidate = null;
            }
        }
        Throwable throwable = null;
        Class<?> clazz = null;
        ClassLoadHelper classLoadHelper2 = null;
        for (ClassLoadHelper classLoadHelper2 : this.loadHelpers) {
            try {
                clazz = classLoadHelper2.loadClass(string);
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throwable = throwable2;
            }
        }
        if (clazz == null) {
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new ClassNotFoundException(String.format("Unable to load class %s by any known loaders.", string), throwable);
        }
        this.bestCandidate = classLoadHelper2;
        return clazz;
    }

    @Override
    public <T> Class<? extends T> loadClass(String string, Class<T> clazz) {
        return this.loadClass(string);
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.bestCandidate != null) {
            uRL = this.bestCandidate.getResource(string);
            if (uRL == null) {
                this.bestCandidate = null;
            } else {
                return uRL;
            }
        }
        ClassLoadHelper classLoadHelper = null;
        Iterator iterator = this.loadHelpers.iterator();
        while (iterator.hasNext() && (uRL = (classLoadHelper = (ClassLoadHelper)iterator.next()).getResource(string)) == null) {
        }
        this.bestCandidate = classLoadHelper;
        return uRL;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.bestCandidate != null) {
            inputStream = this.bestCandidate.getResourceAsStream(string);
            if (inputStream == null) {
                this.bestCandidate = null;
            } else {
                return inputStream;
            }
        }
        ClassLoadHelper classLoadHelper = null;
        Iterator iterator = this.loadHelpers.iterator();
        while (iterator.hasNext() && (inputStream = (classLoadHelper = (ClassLoadHelper)iterator.next()).getResourceAsStream(string)) == null) {
        }
        this.bestCandidate = classLoadHelper;
        return inputStream;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.bestCandidate == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.bestCandidate.getClassLoader();
    }
}

