/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.util.List;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.GlyphSubstitutionTable;
import org.apache.fontbox.ttf.OpenTypeScript;

public class SubstitutingCmapLookup
implements CmapLookup {
    private final CmapSubtable cmap;
    private final GlyphSubstitutionTable gsub;
    private final List<String> enabledFeatures;

    public SubstitutingCmapLookup(CmapSubtable cmapSubtable, GlyphSubstitutionTable glyphSubstitutionTable, List<String> list) {
        this.cmap = cmapSubtable;
        this.gsub = glyphSubstitutionTable;
        this.enabledFeatures = list;
    }

    @Override
    public int getGlyphId(int n) {
        int n2 = this.cmap.getGlyphId(n);
        String[] stringArray = OpenTypeScript.getScriptTags(n);
        return this.gsub.getSubstitution(n2, stringArray, this.enabledFeatures);
    }

    @Override
    public List<Integer> getCharCodes(int n) {
        return this.cmap.getCharCodes(this.gsub.getUnsubstitution(n));
    }
}

