/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.TimeZone;

abstract class TTFDataStream
implements Closeable {
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    TTFDataStream() {
    }

    public float read32Fixed() {
        float f2 = this.readSignedShort();
        return f2 += (float)this.readUnsignedShort() / 65536.0f;
    }

    public String readString(int n) {
        return this.readString(n, StandardCharsets.ISO_8859_1);
    }

    public String readString(int n, Charset charset) {
        return new String(this.read(n), charset);
    }

    public abstract int read();

    public abstract long readLong();

    public int readSignedByte() {
        int n = this.read();
        if (n <= 127) {
            return n;
        }
        return n - 256;
    }

    public int readUnsignedByte() {
        int n = this.read();
        if (n == -1) {
            throw new EOFException("premature EOF");
        }
        return n;
    }

    public long readUnsignedInt() {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        if (l4 < 0L) {
            throw new EOFException();
        }
        return (l << 24) + (l2 << 16) + (l3 << 8) + l4;
    }

    public int readUnsignedShort() {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public int[] readUnsignedByteArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.read();
        }
        return nArray;
    }

    public int[] readUnsignedShortArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readUnsignedShort();
        }
        return nArray;
    }

    public short readSignedShort() {
        return (short)this.readUnsignedShort();
    }

    public Calendar readInternationalDate() {
        long l = this.readLong();
        Calendar calendar = Calendar.getInstance((TimeZone)TIMEZONE_UTC.clone());
        calendar.set(1904, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        calendar.setTimeInMillis(l2 += l * 1000L);
        return calendar;
    }

    public String readTag() {
        return new String(this.read(4), StandardCharsets.US_ASCII);
    }

    public abstract void seek(long var1);

    public byte[] read(int n) {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = this.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 == n) {
            return byArray;
        }
        throw new IOException("Unexpected end of TTF stream reached");
    }

    public abstract int read(byte[] var1, int var2, int var3);

    public abstract long getCurrentPosition();

    public abstract InputStream getOriginalData();

    public abstract long getOriginalDataSize();
}

