/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;

public abstract class NativeFontDirFinder
implements FontDirFinder {
    private static final Log LOG = LogFactory.getLog(NativeFontDirFinder.class);

    @Override
    public List<File> find() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.getSearchableDirectories();
        if (stringArray != null) {
            for (String securityException : stringArray) {
                File file = new File(securityException);
                try {
                    if (!file.exists() || !file.canRead()) continue;
                    arrayList.add(file);
                }
                catch (SecurityException securityException2) {
                    LOG.debug((Object)"Couldn't get native font directories - ignoring", (Throwable)securityException2);
                }
            }
        }
        return arrayList;
    }

    protected abstract String[] getSearchableDirectories();
}

