/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.Trigger$TriggerState;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.jmx.JobDetailSupport;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.matchers.StringMatcher$StringOperatorName;
import org.quartz.spi.JobFactory;

public abstract class RemoteMBeanScheduler
implements Scheduler {
    private ObjectName schedulerObjectName;

    protected ObjectName getSchedulerObjectName() {
        return this.schedulerObjectName;
    }

    public void setSchedulerObjectName(String string) {
        try {
            this.schedulerObjectName = new ObjectName(string);
            return;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new SchedulerException("Failed to parse Scheduler MBean name: " + string, malformedObjectNameException);
        }
    }

    public void setSchedulerObjectName(ObjectName objectName) {
        this.schedulerObjectName = objectName;
    }

    public abstract void initialize();

    protected abstract Object getAttribute(String var1);

    protected abstract AttributeList getAttributes(String[] var1);

    protected abstract Object invoke(String var1, Object[] var2, String[] var3);

    @Override
    public String getSchedulerName() {
        return (String)this.getAttribute("SchedulerName");
    }

    @Override
    public String getSchedulerInstanceId() {
        return (String)this.getAttribute("SchedulerInstanceId");
    }

    @Override
    public SchedulerMetaData getMetaData() {
        AttributeList attributeList = this.getAttributes(new String[]{"SchedulerName", "SchedulerInstanceId", "StandbyMode", "Shutdown", "JobStoreClassName", "ThreadPoolClassName", "ThreadPoolSize", "Version", "PerformanceMetrics"});
        try {
            return new SchedulerMetaData((String)this.getAttribute(attributeList, 0).getValue(), (String)this.getAttribute(attributeList, 1).getValue(), this.getClass(), true, false, (Boolean)this.getAttribute(attributeList, 2).getValue(), (Boolean)this.getAttribute(attributeList, 3).getValue(), null, Integer.parseInt(((Map)this.getAttribute(attributeList, 8).getValue()).get("JobsExecuted").toString()), Class.forName((String)this.getAttribute(attributeList, 4).getValue()), false, false, Class.forName((String)this.getAttribute(attributeList, 5).getValue()), (Integer)this.getAttribute(attributeList, 6).getValue(), (String)this.getAttribute(attributeList, 7).getValue());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SchedulerException(classNotFoundException);
        }
    }

    private Attribute getAttribute(AttributeList attributeList, int n) {
        return (Attribute)attributeList.get(n);
    }

    @Override
    public SchedulerContext getContext() {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void start() {
        this.invoke("start", new Object[0], new String[0]);
    }

    @Override
    public void startDelayed(int n) {
        this.invoke("startDelayed", new Object[]{n}, new String[]{Integer.TYPE.getName()});
    }

    @Override
    public void standby() {
        this.invoke("standby", new Object[0], new String[0]);
    }

    @Override
    public boolean isStarted() {
        return (Boolean)this.getAttribute("Started");
    }

    @Override
    public boolean isInStandbyMode() {
        return (Boolean)this.getAttribute("StandbyMode");
    }

    @Override
    public void shutdown() {
        String string = this.getSchedulerName();
        this.invoke("shutdown", new Object[0], new String[0]);
        SchedulerRepository.getInstance().remove(string);
    }

    @Override
    public void shutdown(boolean bl) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean isShutdown() {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public Date scheduleJob(Trigger trigger) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl) {
        this.invoke("addJob", new Object[]{JobDetailSupport.toCompositeData(jobDetail), bl}, new String[]{CompositeData.class.getName(), Boolean.TYPE.getName()});
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean bl, boolean bl2) {
        this.invoke("addJob", new Object[]{JobDetailSupport.toCompositeData(jobDetail), bl, bl2}, new String[]{CompositeData.class.getName(), Boolean.TYPE.getName(), Boolean.TYPE.getName()});
    }

    @Override
    public boolean deleteJob(JobKey jobKey) {
        return (Boolean)this.invoke("deleteJob", new Object[]{jobKey.getName(), jobKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) {
        return (Boolean)this.invoke("unscheduleJob", new Object[]{triggerKey.getName(), triggerKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public boolean deleteJobs(List<JobKey> list) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> set, boolean bl) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> list) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void triggerJob(JobKey jobKey) {
        this.triggerJob(jobKey, null);
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap jobDataMap) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        this.invoke("pauseTrigger", new Object[]{triggerKey.getName(), triggerKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        String string = null;
        switch (groupMatcher.getCompareWithOperator()) {
            case EQUALS: {
                string = "pauseTriggerGroup";
                break;
            }
            case CONTAINS: {
                string = "pauseTriggersContaining";
                break;
            }
            case STARTS_WITH: {
                string = "pauseTriggersStartingWith";
                break;
            }
            case ENDS_WITH: 
            case ANYTHING: {
                string = "pauseTriggersAll";
            }
        }
        if (string != null) {
            this.invoke(string, new Object[]{groupMatcher.getCompareToValue()}, new String[]{String.class.getName()});
            return;
        }
        throw new SchedulerException("Unsupported GroupMatcher kind for pausing triggers: " + (Object)((Object)groupMatcher.getCompareWithOperator()));
    }

    @Override
    public void pauseJob(JobKey jobKey) {
        this.invoke("pauseJob", new Object[]{jobKey.getName(), jobKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        String string = null;
        switch (groupMatcher.getCompareWithOperator()) {
            case EQUALS: {
                string = "pauseJobGroup";
                break;
            }
            case STARTS_WITH: {
                string = "pauseJobsStartingWith";
                break;
            }
            case ENDS_WITH: {
                string = "pauseJobsEndingWith";
                break;
            }
            case CONTAINS: 
            case ANYTHING: {
                string = "pauseJobsAll";
            }
        }
        this.invoke(string, new Object[]{groupMatcher.getCompareToValue()}, new String[]{String.class.getName()});
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        this.invoke("resumeTrigger", new Object[]{triggerKey.getName(), triggerKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        String string = null;
        switch (groupMatcher.getCompareWithOperator()) {
            case EQUALS: {
                string = "resumeTriggerGroup";
                break;
            }
            case CONTAINS: {
                string = "resumeTriggersContaining";
                break;
            }
            case STARTS_WITH: {
                string = "resumeTriggersStartingWith";
                break;
            }
            case ENDS_WITH: 
            case ANYTHING: {
                string = "resumeTriggersAll";
            }
        }
        if (string != null) {
            this.invoke(string, new Object[]{groupMatcher.getCompareToValue()}, new String[]{String.class.getName()});
            return;
        }
        throw new SchedulerException("Unsupported GroupMatcher kind for resuming triggers: " + (Object)((Object)groupMatcher.getCompareWithOperator()));
    }

    @Override
    public void resumeJob(JobKey jobKey) {
        this.invoke("resumeJob", new Object[]{jobKey.getName(), jobKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        String string = null;
        switch (groupMatcher.getCompareWithOperator()) {
            case EQUALS: {
                string = "resumeJobGroup";
                break;
            }
            case STARTS_WITH: {
                string = "resumeJobsStartingWith";
                break;
            }
            case ENDS_WITH: {
                string = "resumeJobsEndingWith";
                break;
            }
            case CONTAINS: 
            case ANYTHING: {
                string = "resumeJobsAll";
            }
        }
        this.invoke(string, new Object[]{groupMatcher.getCompareToValue()}, new String[]{String.class.getName()});
    }

    @Override
    public void pauseAll() {
        this.invoke("pauseAllTriggers", new Object[0], new String[0]);
    }

    @Override
    public void resumeAll() {
        this.invoke("resumeAllTriggers", new Object[0], new String[0]);
    }

    @Override
    public List<String> getJobGroupNames() {
        return (List)this.getAttribute("JobGroupNames");
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> object) {
        if (((StringMatcher)object).getCompareWithOperator().equals((Object)StringMatcher$StringOperatorName.EQUALS)) {
            object = (List)this.invoke("getJobNames", new Object[]{((StringMatcher)object).getCompareToValue()}, new String[]{String.class.getName()});
            return new HashSet<JobKey>((Collection<JobKey>)object);
        }
        throw new SchedulerException("Only equals matcher are supported for looking up JobKeys");
    }

    public List<Trigger> getTriggersOfJob(JobKey jobKey) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public List<String> getTriggerGroupNames() {
        return (List)this.getAttribute("TriggerGroupNames");
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) {
        try {
            return JobDetailSupport.newJobDetail((CompositeData)this.invoke("getJobDetail", new Object[]{jobKey.getName(), jobKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SchedulerException("Unable to resolve job class", classNotFoundException);
        }
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean checkExists(JobKey jobKey) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) {
        return (Boolean)this.invoke("checkExists", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public void clear() {
        this.invoke("clear", new Object[0], new String[0]);
    }

    @Override
    public Trigger$TriggerState getTriggerState(TriggerKey triggerKey) {
        return Trigger$TriggerState.valueOf((String)this.invoke("getTriggerState", new Object[]{triggerKey.getName(), triggerKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()}));
    }

    @Override
    public void resetTriggerFromErrorState(TriggerKey triggerKey) {
        this.invoke("resetTriggerFromErrorState", new Object[]{triggerKey.getName(), triggerKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
    }

    @Override
    public void addCalendar(String string, Calendar calendar, boolean bl, boolean bl2) {
        this.invoke("addCalendar", new Object[]{string, calendar, bl, bl2}, new String[]{String.class.getName(), Calendar.class.getName(), Boolean.TYPE.getName(), Boolean.TYPE.getName()});
    }

    @Override
    public boolean deleteCalendar(String string) {
        this.invoke("deleteCalendar", new Object[]{string}, new String[]{String.class.getName()});
        return true;
    }

    @Override
    public Calendar getCalendar(String string) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public List<String> getCalendarNames() {
        return (List)this.getAttribute("CalendarNames");
    }

    @Override
    public Set<String> getPausedTriggerGroups() {
        return (Set)this.getAttribute("PausedTriggerGroups");
    }

    @Override
    public ListenerManager getListenerManager() {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean interrupt(JobKey jobKey) {
        try {
            return (Boolean)this.invoke("interruptJob", new Object[]{jobKey.getName(), jobKey.getGroup()}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public boolean interrupt(String string) {
        try {
            return (Boolean)this.invoke("interruptJob", new Object[]{string}, new String[]{String.class.getName()});
        }
        catch (SchedulerException schedulerException) {
            throw new UnableToInterruptJobException(schedulerException);
        }
    }

    @Override
    public void setJobFactory(JobFactory jobFactory) {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }
}

