/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.aE;
import kotlinx.coroutines.aF;
import kotlinx.coroutines.ax;
import kotlinx.coroutines.l;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Picture;
import org.jetbrains.skia.PictureRecorder;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameWatcher;
import org.jetbrains.skiko.FullscreenAdapter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.HardwareLayer;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.PictureHolder;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderFactory;
import org.jetbrains.skiko.SkiaLayer$1;
import org.jetbrains.skiko.SkiaLayer$3$2;
import org.jetbrains.skiko.SkiaLayer$Companion;
import org.jetbrains.skiko.SkiaLayer$PropertyKind;
import org.jetbrains.skiko.SkiaLayer$addView$1;
import org.jetbrains.skiko.SkiaLayer$addView$2;
import org.jetbrains.skiko.SkiaLayer$addView$3;
import org.jetbrains.skiko.SkiaLayer$addView$4;
import org.jetbrains.skiko.SkiaLayer$addView$5;
import org.jetbrains.skiko.SkiaLayer$draw$2;
import org.jetbrains.skiko.SkiaLayer$redrawerManager$1;
import org.jetbrains.skiko.SkiaLayer$screenshot$2;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u00bf\u00012\u00020\u0001:\u0004\u00bf\u0001\u00c0\u0001BQ\b\u0016\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fBE\b\u0000\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010m\u001a\u00020g2\b\u0010n\u001a\u0004\u0018\u00010oH\u0016J\u0010\u0010p\u001a\u00020g2\u0006\u0010n\u001a\u00020qH\u0016J\u0010\u0010r\u001a\u00020g2\u0006\u0010n\u001a\u00020sH\u0016J\u0010\u0010t\u001a\u00020g2\u0006\u0010n\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020g2\u0006\u0010n\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020g2\u0006\u0010n\u001a\u00020yH\u0016J\b\u0010z\u001a\u00020gH\u0016J\u000e\u0010{\u001a\u00020g2\u0006\u0010|\u001a\u00020_J\u000e\u0010}\u001a\u00020g2\u0006\u0010~\u001a\u00020\u007fJ\u000f\u0010}\u001a\u00020g2\u0007\u0010\u0080\u0001\u001a\u00020$J\u0007\u0010\u0081\u0001\u001a\u00020gJ\t\u0010\u0082\u0001\u001a\u00020gH\u0002J\u0007\u0010\u0083\u0001\u001a\u00020gJ\t\u0010\u0084\u0001\u001a\u00020gH\u0016J\t\u0010\u0085\u0001\u001a\u00020gH\u0016J\u0018\u0010\u0086\u0001\u001a\u00020g2\u0007\u0010\u001a\u001a\u00030\u0087\u0001H\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u0012\u0010\u0089\u0001\u001a\u00020g2\u0007\u0010\u008a\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u008b\u0001\u001a\u00020\u0007H\u0016J\u0016\u0010\u008c\u0001\u001a\t\u0012\u0004\u0012\u00020q0\u008d\u0001H\u0016\u00a2\u0006\u0003\u0010\u008e\u0001J\t\u0010\u008f\u0001\u001a\u00020\u0007H\u0016J#\u0010\u0090\u0001\u001a\u00020g2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020g0\u0092\u0001H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0003\b\u0093\u0001J\u0014\u0010\u0094\u0001\u001a\u00020g2\t\b\u0002\u0010\u0095\u0001\u001a\u00020\u0007H\u0002J\t\u0010\u0096\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u0097\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u0098\u0001\u001a\u00020\u0007H\u0016J3\u0010\u0099\u0001\u001a\u0005\u0018\u0001H\u009a\u0001\"\t\b\u0000\u0010\u009a\u0001*\u00020$2\u0014\u0010\u009b\u0001\u001a\u000f\u0012\u0004\u0012\u00020J\u0012\u0005\u0012\u0003H\u009a\u00010\u0003H\u0002\u00a2\u0006\u0003\u0010\u009c\u0001J\u0007\u0010\u009d\u0001\u001a\u00020gJ\u0012\u0010\u009e\u0001\u001a\u00020g2\u0007\u0010\u009f\u0001\u001a\u00020fH\u0002J%\u0010\u00a0\u0001\u001a\u00020g2\u0007\u0010\u009f\u0001\u001a\u00020f2\u0013\u0010\u00a1\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020g0\u0003J\u0013\u0010\u00a2\u0001\u001a\u00020g2\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0015\u0010\u00a5\u0001\u001a\u00020g2\n\u0010\u00a6\u0001\u001a\u0005\u0018\u00010\u00a7\u0001H\u0014J\u0013\u0010\u00a8\u0001\u001a\u00020g2\b\u0010n\u001a\u0004\u0018\u00010oH\u0016J\u0011\u0010\u00a9\u0001\u001a\u00020g2\u0006\u0010n\u001a\u00020qH\u0016J\u0011\u0010\u00aa\u0001\u001a\u00020g2\u0006\u0010n\u001a\u00020sH\u0016J\u0011\u0010\u00ab\u0001\u001a\u00020g2\u0006\u0010n\u001a\u00020uH\u0016J\u0011\u0010\u00ac\u0001\u001a\u00020g2\u0006\u0010n\u001a\u00020wH\u0016J\u0011\u0010\u00ad\u0001\u001a\u00020g2\u0006\u0010n\u001a\u00020yH\u0016J\t\u0010\u00ae\u0001\u001a\u00020gH\u0016J\t\u0010\u00af\u0001\u001a\u00020gH\u0016J\u0015\u0010\u00af\u0001\u001a\u00020g2\n\u0010\u00b0\u0001\u001a\u0005\u0018\u00010\u00b1\u0001H\u0016J\t\u0010\u00b2\u0001\u001a\u00020\u0007H\u0016J\u0015\u0010\u00b2\u0001\u001a\u00020\u00072\n\u0010\u00b0\u0001\u001a\u0005\u0018\u00010\u00b1\u0001H\u0016J\u0012\u0010\u00b3\u0001\u001a\u00020g2\t\u0010\u00b4\u0001\u001a\u0004\u0018\u00010\u0005J\u0011\u0010\u00b5\u0001\u001a\u0002002\u0006\u00107\u001a\u000200H\u0002J\n\u0010\u00b6\u0001\u001a\u0005\u0018\u00010\u00b7\u0001J\u0012\u0010\u00b8\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\u0007H\u0016J\u0012\u0010\u00ba\u0001\u001a\u00020g2\u0007\u0010\u00bb\u0001\u001a\u00020\u0007H\u0016J\u0018\u0010\u00bc\u0001\u001a\u00020g2\u0007\u0010\u00bd\u0001\u001a\u00020(H\u0000\u00a2\u0006\u0003\b\u00be\u0001R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u0004\u0018\u000104X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u00106R$\u00108\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010P\u001a\u0004\u0018\u00010Q8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020Q0UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n2\u0006\u00107\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010Z\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR,\u0010d\u001a \u0012\u0004\u0012\u00020f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020g0\u00030\u001f0eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010h\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bi\u0010:\"\u0004\bj\u0010<R\u0011\u0010k\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010*\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00c1\u0001"}, d2={"Lorg/jetbrains/skiko/SkiaLayer;", "Ljavax/swing/JPanel;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "isVsyncEnabled", "", "isVsyncFramelimitFallbackEnabled", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "pixelGeometry", "Lorg/jetbrains/skia/PixelGeometry;", "(Lkotlin/jvm/functions/Function1;ZZLorg/jetbrains/skiko/GraphicsApi;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skia/PixelGeometry;)V", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "renderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;Lorg/jetbrains/skiko/RenderFactory;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skia/PixelGeometry;)V", "_transparency", "backedLayer", "Lorg/jetbrains/skiko/HardwareLayer;", "getBackedLayer$skiko", "()Lorg/jetbrains/skiko/HardwareLayer;", "canvas", "Ljava/awt/Canvas;", "getCanvas", "()Ljava/awt/Canvas;", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "component", "", "getComponent", "()Ljava/lang/Object;", "contentHandle", "", "getContentHandle", "()J", "contentScale", "", "getContentScale", "()F", "currentDPI", "", "getCurrentDPI", "()I", "fpsCounter", "Lorg/jetbrains/skiko/FPSCounter;", "getFpsCounter$annotations", "()V", "value", "fullscreen", "getFullscreen", "()Z", "setFullscreen", "(Z)V", "fullscreenAdapter", "Lorg/jetbrains/skiko/FullscreenAdapter;", "isDisposed", "isInited", "isRendering", "isShowingCached", "keyEvent", "Ljava/awt/event/KeyEvent;", "latestReceivedGraphicsContextScaleTransform", "Ljava/awt/geom/AffineTransform;", "peerBufferSizeFixJob", "Lkotlinx/coroutines/Job;", "picture", "Lorg/jetbrains/skiko/PictureHolder;", "pictureLock", "pictureRecorder", "Lorg/jetbrains/skia/PictureRecorder;", "getPixelGeometry", "()Lorg/jetbrains/skia/PixelGeometry;", "redrawer", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "getRedrawer$skiko", "()Lorg/jetbrains/skiko/redrawer/Redrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "getSkikoView", "()Lorg/jetbrains/skiko/SkikoView;", "setSkikoView", "(Lorg/jetbrains/skiko/SkikoView;)V", "stateHandlers", "", "Lorg/jetbrains/skiko/SkiaLayer$PropertyKind;", "", "transparency", "getTransparency", "setTransparency", "windowHandle", "getWindowHandle", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "addInputMethodListener", "Ljava/awt/event/InputMethodListener;", "addKeyListener", "Ljava/awt/event/KeyListener;", "addMouseListener", "Ljava/awt/event/MouseListener;", "addMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "addMouseWheelListener", "Ljava/awt/event/MouseWheelListener;", "addNotify", "addView", "view", "attachTo", "jComponent", "Ljavax/swing/JComponent;", "container", "checkContentScale", "checkShowing", "detach", "dispose", "doLayout", "draw", "Lorg/jetbrains/skia/Canvas;", "draw$skiko", "enableInputMethods", "enable", "getFocusTraversalKeysEnabled", "getInputMethodListeners", "", "()[Ljava/awt/event/InputMethodListener;", "hasFocus", "inDrawScope", "body", "Lkotlin/Function0;", "inDrawScope$skiko", "init", "recreation", "isFocusOwner", "isFocusable", "isShowing", "lockPicture", "T", "action", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "needRedraw", "notifyChange", "kind", "onStateChanged", "handler", "paint", "g", "Ljava/awt/Graphics;", "processInputMethodEvent", "e", "Ljava/awt/event/InputMethodEvent;", "removeFocusListener", "removeInputMethodListener", "removeKeyListener", "removeMouseListener", "removeMouseMotionListener", "removeMouseWheelListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "requestFocusInWindow", "requestNativeFocusOnAccessible", "accessible", "roundSize", "screenshot", "Lorg/jetbrains/skia/Bitmap;", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "update", "nanoTime", "update$skiko", "Companion", "PropertyKind", "skiko"})
public class SkiaLayer
extends JPanel {
    public static final SkiaLayer$Companion Companion = new SkiaLayer$Companion(null);
    private final SkiaLayerProperties properties;
    private final RenderFactory renderFactory;
    private final SkiaLayerAnalytics analytics;
    private final PixelGeometry pixelGeometry;
    private boolean _transparency;
    private final HardwareLayer backedLayer;
    private aE peerBufferSizeFixJob;
    private AffineTransform latestReceivedGraphicsContextScaleTransform;
    private FullscreenAdapter fullscreenAdapter;
    private boolean isInited;
    private boolean isRendering;
    private boolean isShowingCached;
    private SkikoView skikoView;
    private KeyEvent keyEvent;
    private final List<ClipRectangle> clipComponents;
    private volatile boolean isDisposed;
    private final RedrawerManager<Redrawer> redrawerManager;
    private volatile PictureHolder picture;
    private PictureRecorder pictureRecorder;
    private final Object pictureLock;
    private final Map<SkiaLayer$PropertyKind, List<Function1<SkiaLayer, Unit>>> stateHandlers;
    private final FPSCounter fpsCounter;

    public SkiaLayer(Function1<? super Component, ? extends Accessible> function1, SkiaLayerProperties skiaLayerProperties, RenderFactory renderFactory, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        Intrinsics.checkNotNullParameter((Object)renderFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelGeometry), (String)"");
        this.properties = skiaLayerProperties;
        this.renderFactory = renderFactory;
        this.analytics = skiaLayerAnalytics;
        this.pixelGeometry = pixelGeometry;
        this.setOpaque(false);
        this.setLayout(null);
        this.backedLayer = new SkiaLayer$1(function1, this);
        SkiaLayer skiaLayer = this;
        skiaLayer.add(skiaLayer.backedLayer);
        this.backedLayer.addHierarchyListener(arg_0 -> SkiaLayer._init_$lambda$0(this, arg_0));
        this.addPropertyChangeListener("graphicsContextScaleTransform", arg_0 -> SkiaLayer._init_$lambda$2(this, arg_0));
        this.fullscreenAdapter = new FullscreenAdapter(this.backedLayer);
        this.clipComponents = new ArrayList();
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), new SkiaLayer$redrawerManager$1(this));
        this.pictureLock = new Object();
        this.stateHandlers = new LinkedHashMap();
        this.fpsCounter = SkiaLayer_awtKt.defaultFPSCounter(this);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, SkiaLayerProperties skiaLayerProperties, RenderFactory renderFactory, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        if ((n & 4) != 0) {
            renderFactory = RenderFactory.Companion.getDefault();
        }
        if ((n & 8) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n & 0x10) != 0) {
            pixelGeometry = PixelGeometry.UNKNOWN;
        }
        this((Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties, renderFactory, skiaLayerAnalytics, pixelGeometry);
    }

    public final PixelGeometry getPixelGeometry() {
        return this.pixelGeometry;
    }

    public final boolean getTransparency() {
        return this._transparency;
    }

    public final void setTransparency(boolean bl) {
        this._transparency = bl;
        if (!bl) {
            this.setBackground(UIManager.getColor("Panel.background"));
            return;
        }
        this.setBackground(new Color(0, 0, 0, 0));
    }

    public final HardwareLayer getBackedLayer$skiko() {
        return this.backedLayer;
    }

    public SkiaLayer(Function1<? super Component, ? extends Accessible> function1, boolean bl, boolean bl2, GraphicsApi graphicsApi, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelGeometry), (String)"");
        this(function1, new SkiaLayerProperties(bl, bl2, graphicsApi, null, 8, null), RenderFactory.Companion.getDefault(), skiaLayerAnalytics, pixelGeometry);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, boolean bl, boolean bl2, GraphicsApi graphicsApi, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        if ((n & 2) != 0) {
            bl = SkikoProperties.INSTANCE.getVsyncEnabled();
        }
        if ((n & 4) != 0) {
            bl2 = SkikoProperties.INSTANCE.getVsyncFramelimitFallbackEnabled();
        }
        if ((n & 8) != 0) {
            graphicsApi = SkikoProperties.INSTANCE.getRenderApi();
        }
        if ((n & 0x10) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n & 0x20) != 0) {
            pixelGeometry = PixelGeometry.UNKNOWN;
        }
        this((Function1<? super Component, ? extends Accessible>)function1, bl, bl2, graphicsApi, skiaLayerAnalytics, pixelGeometry);
    }

    public final java.awt.Canvas getCanvas() {
        return this.backedLayer;
    }

    @Override
    public void removeNotify() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("SkiaLayer.awt#removeNotify " + this);
        }
        object = SwingUtilities.getWindowAncestor(this);
        ((Component)object).removeComponentListener(this.fullscreenAdapter);
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("SkiaLayer.awt#addNotify " + this);
        }
        super.addNotify();
        object = SwingUtilities.getWindowAncestor(this);
        ((Component)object).addComponentListener(this.fullscreenAdapter);
        this.checkShowing();
        SkiaLayer skiaLayer = this;
        skiaLayer.init(skiaLayer.isInited);
    }

    public final void detach() {
        this.dispose();
    }

    private final void checkShowing() {
        boolean bl = this.isShowingCached;
        this.isShowingCached = super.isShowing();
        if (bl != this.isShowing()) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.setVisible(this.isShowing());
            }
        }
        if (this.isShowing()) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.syncSize();
            }
            this.repaint();
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShowingCached;
    }

    public final float getContentScale() {
        return (float)this.getGraphicsConfiguration().getDefaultTransform().getScaleX();
    }

    public final long getContentHandle() {
        return this.backedLayer.getContentHandle();
    }

    public final long getWindowHandle() {
        return this.backedLayer.getWindowHandle();
    }

    public final int getCurrentDPI() {
        return this.backedLayer.getCurrentDPI();
    }

    public final boolean getFullscreen() {
        return this.fullscreenAdapter.getFullscreen();
    }

    public final void setFullscreen(boolean bl) {
        this.fullscreenAdapter.setFullscreen(bl);
    }

    public final Object getComponent() {
        return this.backedLayer;
    }

    public final SkikoView getSkikoView() {
        return this.skikoView;
    }

    public final void setSkikoView(SkikoView skikoView) {
        this.skikoView = skikoView;
    }

    public final void attachTo(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.attachTo((JComponent)object);
    }

    public final void attachTo(JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"");
        jComponent.add(this);
    }

    public final void addView(SkikoView skikoView) {
        Intrinsics.checkNotNullParameter((Object)skikoView, (String)"");
        this.skikoView = skikoView;
        this.addMouseListener(new SkiaLayer$addView$1(this));
        this.addMouseMotionListener(new SkiaLayer$addView$2(this));
        this.addMouseWheelListener(new SkiaLayer$addView$3(this));
        this.addKeyListener(new SkiaLayer$addView$4(this));
        this.addInputMethodListener(new SkiaLayer$addView$5(this));
    }

    public final List<ClipRectangle> getClipComponents() {
        return this.clipComponents;
    }

    public final Redrawer getRedrawer$skiko() {
        return this.redrawerManager.getRedrawer();
    }

    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    public final void setRenderApi(GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.redrawerManager.forceRenderApi(graphicsApi);
        this.notifyChange(SkiaLayer$PropertyKind.Renderer);
    }

    public final String getRenderInfo() {
        if (this.getRedrawer$skiko() == null) {
            return "SkiaLayer isn't initialized yet";
        }
        Redrawer redrawer = this.getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return redrawer.getRenderInfo();
    }

    private final void init(boolean bl) {
        this.isDisposed = false;
        this.backedLayer.init();
        this.pictureRecorder = new PictureRecorder();
        this.redrawerManager.findNextWorkingRenderApi(bl);
        this.isInited = true;
    }

    static /* synthetic */ void init$default(SkiaLayer skiaLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaLayer.init(bl);
    }

    public final void onStateChanged(SkiaLayer$PropertyKind skiaLayer$PropertyKind, Function1<? super SkiaLayer, Unit> function1) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)skiaLayer$PropertyKind), (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Map<SkiaLayer$PropertyKind, List<Function1<SkiaLayer, Unit>>> map = this.stateHandlers;
        List list3 = map.get((Object)skiaLayer$PropertyKind);
        if (list3 == null) {
            list3 = new ArrayList();
            map.put(skiaLayer$PropertyKind, list3);
            list2 = list3;
        } else {
            list2 = list3;
        }
        ((Collection)list2).add(function1);
    }

    private final void notifyChange(SkiaLayer$PropertyKind object) {
        List<Function1<SkiaLayer, Unit>> list2 = this.stateHandlers.get(object);
        if (list2 != null) {
            object = list2;
            object = list2;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Function1)object2;
                object2.invoke((Object)this);
            }
            return;
        }
    }

    public void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInited && !this.isDisposed) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.dispose();
            }
            this.redrawerManager.dispose();
            Object object = this.picture;
            if (object != null && (object = ((PictureHolder)object).getInstance()) != null) {
                ((Managed)object).close();
            }
            this.picture = null;
            PictureRecorder pictureRecorder = this.pictureRecorder;
            if (pictureRecorder != null) {
                pictureRecorder.close();
            }
            this.pictureRecorder = null;
            this.backedLayer.dispose();
            aE aE2 = this.peerBufferSizeFixJob;
            if (aE2 != null) {
                aF.a((aE)aE2, null, (int)1, null);
            }
            this.isDisposed = true;
        }
    }

    @Override
    public void doLayout() {
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("doLayout on " + this);
        }
        SkiaLayer skiaLayer = this;
        SkiaLayer skiaLayer2 = this;
        this.backedLayer.setBounds(0, 0, skiaLayer.roundSize(skiaLayer.getWidth()), skiaLayer2.roundSize(skiaLayer2.getHeight()));
        this.backedLayer.validate();
        Redrawer redrawer = this.getRedrawer$skiko();
        if (redrawer != null) {
            redrawer.syncSize();
            return;
        }
    }

    @Override
    public void paint(Graphics object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("Paint called on: " + this);
        }
        this.checkContentScale();
        if (this.isRendering) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.needRedraw();
                return;
            }
            return;
        }
        Redrawer redrawer = this.getRedrawer$skiko();
        if (redrawer != null) {
            redrawer.redrawImmediately();
            return;
        }
    }

    public final void checkContentScale() {
        AffineTransform affineTransform = this.getGraphicsConfiguration().getDefaultTransform();
        if (!Intrinsics.areEqual((Object)affineTransform, (Object)this.latestReceivedGraphicsContextScaleTransform)) {
            this.firePropertyChange("graphicsContextScaleTransform", this.latestReceivedGraphicsContextScaleTransform, affineTransform);
        }
    }

    @Override
    public void enableInputMethods(boolean bl) {
        this.backedLayer.enableInputMethods(bl);
    }

    @Override
    public InputMethodListener[] getInputMethodListeners() {
        InputMethodListener[] inputMethodListenerArray = this.backedLayer.getInputMethodListeners();
        Intrinsics.checkNotNullExpressionValue((Object)inputMethodListenerArray, (String)"");
        return inputMethodListenerArray;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        this.backedLayer.doProcessInputMethodEvent(inputMethodEvent);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.backedLayer.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.backedLayer.removeFocusListener(focusListener);
    }

    @Override
    public void setFocusable(boolean bl) {
        this.backedLayer.setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return this.backedLayer.isFocusable();
    }

    @Override
    public boolean hasFocus() {
        return this.backedLayer.hasFocus();
    }

    @Override
    public boolean isFocusOwner() {
        return this.backedLayer.isFocusOwner();
    }

    @Override
    public void requestFocus() {
        this.backedLayer.requestFocus();
    }

    @Override
    public void requestFocus(FocusEvent.Cause cause) {
        this.backedLayer.requestFocus(cause);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.backedLayer.requestFocusInWindow();
    }

    @Override
    public boolean requestFocusInWindow(FocusEvent.Cause cause) {
        return this.backedLayer.requestFocusInWindow(cause);
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean bl) {
        this.backedLayer.setFocusTraversalKeysEnabled(bl);
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return this.backedLayer.getFocusTraversalKeysEnabled();
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        Intrinsics.checkNotNullParameter((Object)inputMethodListener, (String)"");
        super.addInputMethodListener(inputMethodListener);
        this.backedLayer.addInputMethodListener(inputMethodListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"");
        this.backedLayer.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Intrinsics.checkNotNullParameter((Object)mouseMotionListener, (String)"");
        this.backedLayer.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelListener, (String)"");
        this.backedLayer.addMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        Intrinsics.checkNotNullParameter((Object)keyListener, (String)"");
        this.backedLayer.addKeyListener(keyListener);
    }

    @Override
    public void removeInputMethodListener(InputMethodListener inputMethodListener) {
        Intrinsics.checkNotNullParameter((Object)inputMethodListener, (String)"");
        super.removeInputMethodListener(inputMethodListener);
        this.backedLayer.removeInputMethodListener(inputMethodListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"");
        this.backedLayer.removeMouseListener(mouseListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Intrinsics.checkNotNullParameter((Object)mouseMotionListener, (String)"");
        this.backedLayer.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelListener, (String)"");
        this.backedLayer.removeMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        Intrinsics.checkNotNullParameter((Object)keyListener, (String)"");
        this.backedLayer.removeKeyListener(keyListener);
    }

    public final void needRedraw() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (!(!this.isDisposed)) {
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        Redrawer redrawer = this.getRedrawer$skiko();
        if (redrawer != null) {
            redrawer.needRedraw();
            return;
        }
    }

    private static /* synthetic */ void getFpsCounter$annotations() {
    }

    public final void update$skiko(long l2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (!(!this.isDisposed)) {
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        this.checkContentScale();
        FrameWatcher.INSTANCE.nextFrame();
        FPSCounter fPSCounter = this.fpsCounter;
        if (fPSCounter != null) {
            fPSCounter.tick();
        }
        int n = RangesKt.coerceAtLeast((int)((int)((float)this.getWidth() * this.getContentScale())), (int)0);
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getHeight() * this.getContentScale())), (int)0);
        Object object = Rect.Companion.makeWH(n, n2);
        PictureRecorder pictureRecorder = this.pictureRecorder;
        Intrinsics.checkNotNull((Object)pictureRecorder);
        PictureRecorder pictureRecorder2 = pictureRecorder;
        object = pictureRecorder.beginRecording((Rect)object);
        for (ClipRectangle object2 : this.clipComponents) {
            SkiaLayer_awtKt.clipRectBy((Canvas)object, object2, this.getContentScale());
        }
        try {
            this.isRendering = true;
            SkikoView skikoView = this.skikoView;
            if (skikoView != null) {
                skikoView.onRender((Canvas)object, n, n2, l2);
            }
        }
        finally {
            this.isRendering = false;
        }
        if (!this.isDisposed && !pictureRecorder2.isClosed()) {
            Object object2 = this.pictureLock;
            synchronized (object2) {
                Object object3 = this.picture;
                if (object3 != null && (object3 = ((PictureHolder)object3).getInstance()) != null) {
                    ((Managed)object3).close();
                }
                Picture picture = pictureRecorder2.finishRecordingAsPicture();
                this.picture = new PictureHolder(picture, n, n2);
                return;
            }
        }
    }

    public final void inDrawScope$skiko(Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        if (!SwingUtilities.isEventDispatchThread()) {
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (!(!this.isDisposed)) {
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        try {
            function0.invoke();
            return;
        }
        catch (CancellationException cancellationException) {
            return;
        }
        catch (RenderException renderException) {
            if (!this.isDisposed) {
                Object object = Logger.INSTANCE;
                if (((Logger)object).getLoggerImpl().isWarnEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
                    object = renderException;
                    SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface2.warn((Throwable)object, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                Redrawer redrawer = this.getRedrawer$skiko();
                if (redrawer != null) {
                    redrawer.redrawImmediately();
                    return;
                }
            }
            return;
        }
    }

    public final void draw$skiko(Canvas object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!(!this.isDisposed)) {
            object = "SkiaLayer is disposed";
            throw new IllegalStateException(object.toString());
        }
        this.lockPicture(new SkiaLayer$draw$2((Canvas)object));
    }

    private final <T> T lockPicture(Function1<? super PictureHolder, ? extends T> function1) {
        Object object = this.pictureLock;
        synchronized (object) {
            PictureHolder pictureHolder = this.picture;
            function1 = pictureHolder != null ? function1.invoke((Object)pictureHolder) : null;
            return (T)function1;
        }
    }

    public final Bitmap screenshot() {
        if (!(!this.isDisposed)) {
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        return (Bitmap)this.lockPicture(SkiaLayer$screenshot$2.INSTANCE);
    }

    private final int roundSize(int n) {
        float f;
        float f2 = (float)n * this.getContentScale();
        f2 -= (float)((int)f2);
        f2 = f > 0.4f && f2 < 0.6f ? (float)n + 1.0f : (float)n;
        return (int)f2;
    }

    public final void requestNativeFocusOnAccessible(Accessible accessible) {
        this.backedLayer.requestNativeFocusOnAccessible(accessible);
    }

    private static final void _init_$lambda$0(SkiaLayer skiaLayer, HierarchyEvent hierarchyEvent) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            skiaLayer.checkShowing();
        }
    }

    private static final void _init_$lambda$2(SkiaLayer skiaLayer, PropertyChangeEvent propertyChangeEvent) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Object object = Logger.INSTANCE;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            object = ((Logger)object).getLoggerImpl();
            object.debug("graphicsContextScaleTransform changed for " + skiaLayer);
        }
        Object object2 = propertyChangeEvent.getNewValue();
        Intrinsics.checkNotNull((Object)object2);
        skiaLayer.latestReceivedGraphicsContextScaleTransform = (AffineTransform)object2;
        Redrawer redrawer = skiaLayer.getRedrawer$skiko();
        if (redrawer != null) {
            redrawer.syncSize();
        }
        skiaLayer.notifyChange(SkiaLayer$PropertyKind.ContentScale);
        if (OsArch_jvmKt.getHostOs() == OS.Windows) {
            aE aE2 = skiaLayer.peerBufferSizeFixJob;
            if (aE2 != null) {
                aF.a((aE)aE2, null, (int)1, null);
            }
            skiaLayer.peerBufferSizeFixJob = l.a((CoroutineScope)((CoroutineScope)ax.a), (CoroutineContext)((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher()), null, (Function2)new SkiaLayer$3$2(skiaLayer, null), (int)2, null);
        }
    }

    public static final /* synthetic */ void access$setKeyEvent$p(SkiaLayer skiaLayer, KeyEvent keyEvent) {
        skiaLayer.keyEvent = keyEvent;
    }

    public static final /* synthetic */ KeyEvent access$getKeyEvent$p(SkiaLayer skiaLayer) {
        return skiaLayer.keyEvent;
    }

    public static final /* synthetic */ RenderFactory access$getRenderFactory$p(SkiaLayer skiaLayer) {
        return skiaLayer.renderFactory;
    }

    public static final /* synthetic */ SkiaLayerAnalytics access$getAnalytics$p(SkiaLayer skiaLayer) {
        return skiaLayer.analytics;
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaLayer skiaLayer) {
        return skiaLayer.properties;
    }

    static {
        Library.INSTANCE.load();
    }
}

