/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.swing.MetalSwingRedrawer$Companion;
import org.jetbrains.skiko.swing.MetalSwingRedrawer$onRender$1$1;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0082 J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\u0011\u0010\u001e\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0014H\u0082 J\u0011\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0082 J)\u0010 \u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0082 J\b\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0014H\u0014J\b\u0010)\u001a\u00020*H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoView;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "bytesToDraw", "", "context", "Lorg/jetbrains/skia/DirectContext;", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "texturePtr", "", "dispose", "", "disposeMetalTexture", "texture", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "makeMetalContext", "makeMetalRenderTargetOffScreen", "makeMetalTexture", "oldTexture", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "nanoTime", "rendererInfo", "", "Companion", "skiko"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    public static final MetalSwingRedrawer$Companion Companion = new MetalSwingRedrawer$Companion(null);
    private final SkikoView skikoView;
    private final MetalAdapter adapter;
    private final DirectContext context;
    private long texturePtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;
    private final SwingOffscreenDrawer swingOffscreenDrawer;

    public MetalSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoView object, SkiaLayerAnalytics object2) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        super(swingLayerProperties2, (SkiaLayerAnalytics)object2, GraphicsApi.METAL);
        this.skikoView = object;
        object2 = object = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        MetalSwingRedrawer metalSwingRedrawer = this;
        this.onDeviceChosen(((MetalAdapter)object2).getName());
        metalSwingRedrawer.adapter = object;
        this.context = this.makeMetalContext();
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        MetalSwingRedrawer metalSwingRedrawer = this;
        metalSwingRedrawer.disposeMetalTexture(metalSwingRedrawer.texturePtr);
        this.context.close();
        MetalApiKt.dispose(this.adapter);
        super.dispose();
    }

    @Override
    protected final void onRender(Graphics2D graphics2D, int n, int n2, long l2) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        long l3 = MetalApiKt.access$openAutoreleasepool();
        try {
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new MetalSwingRedrawer$onRender$1$1(this, n, n2, l2, graphics2D)));
            return;
        }
        finally {
            MetalApiKt.access$closeAutoreleasepool(l3);
        }
    }

    private final void flush(Surface surface, Graphics2D graphics2D) {
        surface.flushAndSubmit(true);
        int n = surface.getWidth();
        int n2 = surface.getHeight();
        int n3 = n << 2;
        if (this.storage.getWidth() != n || this.storage.getHeight() != n2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(n, n2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, n3, 0, 5, null)];
        }
        surface.readPixels(this.storage, 0, 0);
        boolean bl = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, n3, 0, 0, 26, null);
        if (bl) {
            this.swingOffscreenDrawer.draw(graphics2D, this.bytesToDraw, n, n2);
        }
    }

    @Override
    protected final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget() {
        MetalSwingRedrawer metalSwingRedrawer = this;
        return new BackendRenderTarget(metalSwingRedrawer.makeMetalRenderTargetOffScreen(metalSwingRedrawer.texturePtr));
    }

    private final DirectContext makeMetalContext() {
        MetalSwingRedrawer metalSwingRedrawer = this;
        return new DirectContext(metalSwingRedrawer.makeMetalContext(metalSwingRedrawer.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1);

    private final native long makeMetalTexture(long var1, long var3, int var5, int var6);

    private final native long disposeMetalTexture(long var1);

    public static final /* synthetic */ void access$setTexturePtr$p(MetalSwingRedrawer metalSwingRedrawer, long l2) {
        metalSwingRedrawer.texturePtr = l2;
    }

    public static final /* synthetic */ long access$makeMetalTexture(MetalSwingRedrawer metalSwingRedrawer, long l2, long l3, int n, int n2) {
        return metalSwingRedrawer.makeMetalTexture(l2, l3, n, n2);
    }

    public static final /* synthetic */ MetalAdapter access$getAdapter$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.adapter;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.context;
    }

    public static final /* synthetic */ SkikoView access$getSkikoView$p(MetalSwingRedrawer metalSwingRedrawer) {
        return metalSwingRedrawer.skikoView;
    }

    public static final /* synthetic */ void access$flush(MetalSwingRedrawer metalSwingRedrawer, Surface surface, Graphics2D graphics2D) {
        metalSwingRedrawer.flush(surface, graphics2D);
    }

    static {
        Library.INSTANCE.load();
    }
}

