/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;
import org.w3c.dom.bootstrap.DOMImplementationRegistry$1;
import org.w3c.dom.bootstrap.DOMImplementationRegistry$2;
import org.w3c.dom.bootstrap.DOMImplementationRegistry$3;
import org.w3c.dom.bootstrap.DOMImplementationRegistry$4;

public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static final String DEFAULT_DOM_IMPLEMENTATION_SOURCE = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
    private Vector sources;
    static Class class$org$w3c$dom$bootstrap$DOMImplementationRegistry;

    private DOMImplementationRegistry(Vector vector) {
        this.sources = vector;
    }

    public static DOMImplementationRegistry newInstance() {
        Vector<Object> vector = new Vector<Object>();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        Object object = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (object == null || ((String)object).length() == 0) {
            object = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (object == null) {
            object = DEFAULT_DOM_IMPLEMENTATION_SOURCE;
        }
        if (object != null) {
            object = new StringTokenizer((String)object);
            while (((StringTokenizer)object).hasMoreTokens()) {
                Class<?> clazz = ((StringTokenizer)object).nextToken();
                clazz = classLoader != null ? classLoader.loadClass((String)((Object)clazz)) : Class.forName((String)((Object)clazz));
                clazz = (DOMImplementationSource)clazz.newInstance();
                vector.addElement(clazz);
            }
        }
        return new DOMImplementationRegistry(vector);
    }

    public final DOMImplementation getDOMImplementation(String string) {
        int n = this.sources.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = (DOMImplementationSource)this.sources.elementAt(n2);
            if ((object = object.getDOMImplementation(string)) != null) {
                return object;
            }
            ++n2;
        }
        return null;
    }

    public final DOMImplementationList getDOMImplementationList(String string) {
        Vector<DOMImplementation> vector = new Vector<DOMImplementation>();
        int n = this.sources.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = (DOMImplementationSource)this.sources.elementAt(n2);
            object = object.getDOMImplementationList(string);
            int n3 = 0;
            while (n3 < object.getLength()) {
                DOMImplementation dOMImplementation = object.item(n3);
                vector.addElement(dOMImplementation);
                ++n3;
            }
            ++n2;
        }
        return new DOMImplementationRegistry$1(this, vector);
    }

    public final void addSource(DOMImplementationSource dOMImplementationSource) {
        if (dOMImplementationSource == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(dOMImplementationSource)) {
            this.sources.addElement(dOMImplementationSource);
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = DOMImplementationRegistry.getContextClassLoader();
            if (classLoader != null) {
                return classLoader;
            }
        }
        catch (Exception exception) {
            return (class$org$w3c$dom$bootstrap$DOMImplementationRegistry == null ? (class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class$("org.w3c.dom.bootstrap.DOMImplementationRegistry")) : class$org$w3c$dom$bootstrap$DOMImplementationRegistry).getClassLoader();
        }
        return (class$org$w3c$dom$bootstrap$DOMImplementationRegistry == null ? (class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class$("org.w3c.dom.bootstrap.DOMImplementationRegistry")) : class$org$w3c$dom$bootstrap$DOMImplementationRegistry).getClassLoader();
    }

    private static String getServiceValue(ClassLoader object) {
        block7: {
            Object object2 = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                String string;
                object = DOMImplementationRegistry.getResourceAsStream((ClassLoader)object, (String)object2);
                if (object == null) break block7;
                try {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object), 80);
                }
                try {
                    string = ((BufferedReader)object2).readLine();
                    object = null;
                }
                catch (Throwable throwable) {
                    object = null;
                    ((BufferedReader)object2).close();
                    throw throwable;
                }
                ((BufferedReader)object2).close();
                if (string != null && string.length() > 0) {
                    return string;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static boolean isJRE11() {
        try {
            Class.forName("java.security.AccessController");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (DOMImplementationRegistry.isJRE11()) {
            return null;
        }
        return (ClassLoader)AccessController.doPrivileged(new DOMImplementationRegistry$2());
    }

    private static String getSystemProperty(String string) {
        if (DOMImplementationRegistry.isJRE11()) {
            return System.getProperty(string);
        }
        return (String)AccessController.doPrivileged(new DOMImplementationRegistry$3(string));
    }

    private static InputStream getResourceAsStream(ClassLoader object, String string) {
        if (DOMImplementationRegistry.isJRE11()) {
            object = object == null ? ClassLoader.getSystemResourceAsStream(string) : ((ClassLoader)object).getResourceAsStream(string);
            return object;
        }
        return (InputStream)AccessController.doPrivileged(new DOMImplementationRegistry$4((ClassLoader)object, string));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

