/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe$1;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class FqNameUnsafe {
    private static final Name ROOT_NAME = Name.special("<root>");
    private static final Pattern SPLIT_BY_DOTS = Pattern.compile("\\.");
    private static final Function1<String, Name> STRING_TO_NAME = new FqNameUnsafe$1();
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(String string, FqName fqName2) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(0);
        }
        if (fqName2 == null) {
            FqNameUnsafe.$$$reportNull$$$0(1);
        }
        this.fqName = string;
        this.safe = fqName2;
    }

    public FqNameUnsafe(String string) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(2);
        }
        this.fqName = string;
    }

    private FqNameUnsafe(String string, FqNameUnsafe fqNameUnsafe, Name name) {
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(3);
        }
        this.fqName = string;
        this.parent = fqNameUnsafe;
        this.shortName = name;
    }

    private void compute() {
        int n = this.fqName.lastIndexOf(46);
        if (n >= 0) {
            this.shortName = Name.guessByFirstCharacter(this.fqName.substring(n + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, n));
            return;
        }
        this.shortName = Name.guessByFirstCharacter(this.fqName);
        this.parent = FqName.ROOT.toUnsafe();
    }

    public final String asString() {
        String string = this.fqName;
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(4);
        }
        return string;
    }

    public final boolean isSafe() {
        return this.safe != null || this.asString().indexOf(60) < 0;
    }

    public final FqName toSafe() {
        if (this.safe != null) {
            FqName fqName2 = this.safe;
            if (fqName2 == null) {
                FqNameUnsafe.$$$reportNull$$$0(5);
            }
            return fqName2;
        }
        FqName fqName3 = this.safe = new FqName(this);
        if (fqName3 == null) {
            FqNameUnsafe.$$$reportNull$$$0(6);
        }
        return fqName3;
    }

    public final boolean isRoot() {
        return this.fqName.isEmpty();
    }

    public final FqNameUnsafe parent() {
        if (this.parent != null) {
            FqNameUnsafe fqNameUnsafe = this.parent;
            if (fqNameUnsafe == null) {
                FqNameUnsafe.$$$reportNull$$$0(7);
            }
            return fqNameUnsafe;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe == null) {
            FqNameUnsafe.$$$reportNull$$$0(8);
        }
        return fqNameUnsafe;
    }

    public final FqNameUnsafe child(Name name) {
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(9);
        }
        String string = this.isRoot() ? name.asString() : this.fqName + "." + name.asString();
        return new FqNameUnsafe(string, this, name);
    }

    public final Name shortName() {
        if (this.shortName != null) {
            Name name = this.shortName;
            if (name == null) {
                FqNameUnsafe.$$$reportNull$$$0(10);
            }
            return name;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        Name name = this.shortName;
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(11);
        }
        return name;
    }

    public final Name shortNameOrSpecial() {
        if (this.isRoot()) {
            Name name = ROOT_NAME;
            if (name == null) {
                FqNameUnsafe.$$$reportNull$$$0(12);
            }
            return name;
        }
        Name name = this.shortName();
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(13);
        }
        return name;
    }

    public final List<Name> pathSegments() {
        List list = this.isRoot() ? Collections.emptyList() : ArraysKt.map((Object[])SPLIT_BY_DOTS.split(this.fqName), STRING_TO_NAME);
        if (list == null) {
            FqNameUnsafe.$$$reportNull$$$0(14);
        }
        return list;
    }

    public final boolean startsWith(Name object) {
        if (object == null) {
            FqNameUnsafe.$$$reportNull$$$0(15);
        }
        if (this.isRoot()) {
            return false;
        }
        int n = this.fqName.indexOf(46);
        object = ((Name)object).asString();
        return this.fqName.regionMatches(0, (String)object, 0, n == -1 ? Math.max(this.fqName.length(), ((String)object).length()) : n);
    }

    public static FqNameUnsafe topLevel(Name name) {
        if (name == null) {
            FqNameUnsafe.$$$reportNull$$$0(17);
        }
        return new FqNameUnsafe(name.asString(), FqName.ROOT.toUnsafe(), name);
    }

    public final String toString() {
        String string = this.isRoot() ? ROOT_NAME.asString() : this.fqName;
        if (string == null) {
            FqNameUnsafe.$$$reportNull$$$0(18);
        }
        return string;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FqNameUnsafe)) {
            return false;
        }
        object = (FqNameUnsafe)object;
        return this.fqName.equals(((FqNameUnsafe)object).fqName);
    }

    public final int hashCode() {
        return this.fqName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safe";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/name/FqNameUnsafe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toSafe";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shortName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "shortNameOrSpecial";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "pathSegments";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "child";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "topLevel";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

