/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(FqName fqName2, FqName fqName3) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName3, (String)"");
        if (Intrinsics.areEqual((Object)fqName2, (Object)fqName3)) {
            return true;
        }
        if (fqName3.isRoot()) {
            return true;
        }
        String string = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = fqName3.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return FqNamesUtilKt.isSubpackageOf(string, string2);
    }

    public static final boolean isChildOf(FqName fqName2, FqName fqName3) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName3, (String)"");
        return Intrinsics.areEqual((Object)FqNamesUtilKt.parentOrNull(fqName2), (Object)fqName3);
    }

    private static final boolean isSubpackageOf(String string, String string2) {
        return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && string.charAt(string2.length()) == '.';
    }

    public static final FqName tail(FqName object, FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (!FqNamesUtilKt.isSubpackageOf((FqName)object, fqName2) || fqName2.isRoot()) {
            return object;
        }
        if (Intrinsics.areEqual((Object)object, (Object)fqName2)) {
            FqName fqName3 = FqName.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"");
            return fqName3;
        }
        String string = ((FqName)object).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        object = string;
        int n = fqName2.asString().length() + 1;
        String string2 = ((String)object).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return new FqName(string2);
    }

    public static final FqName parentOrNull(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        if (fqName2.isRoot()) {
            return null;
        }
        return fqName2.parent();
    }

    public static final boolean isValidJavaFqName(String string) {
        if (string == null) {
            return false;
        }
        State state = State.BEGINNING;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (FqNamesUtilKt$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c == '.') {
                        state = State.AFTER_DOT;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue block4;
                    return false;
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    public static final <V> V findValueForMostSpecificFqname(FqName fqName2, Map<FqName, ? extends V> iterator2) {
        Iterator iterator3;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        Intrinsics.checkNotNullParameter(iterator2, (String)"");
        Object object = new LinkedHashMap();
        Iterator iterator5 = iterator2.entrySet().iterator();
        while (iterator5.hasNext()) {
            Map.Entry object2 = iterator5.next();
            iterator2 = object2;
            iterator2 = (FqName)object2.getKey();
            if (!(Intrinsics.areEqual((Object)fqName2, (Object)iterator2) || FqNamesUtilKt.isChildOf(fqName2, (FqName)((Object)iterator2)))) continue;
            object.put(object2.getKey(), object2.getValue());
        }
        iterator2 = object;
        object = iterator2;
        Iterator<Object> iterator4 = !iterator2.isEmpty() ? iterator2 : null;
        if (iterator4 == null) {
            return null;
        }
        iterator2 = iterator4;
        object = iterator4.entrySet();
        iterator2 = object.iterator();
        if (!iterator2.hasNext()) {
            iterator3 = null;
        } else {
            object = iterator2.next();
            if (!iterator2.hasNext()) {
                iterator3 = object;
            } else {
                Map.Entry entry = (Map.Entry)object;
                FqName object3 = (FqName)entry.getKey();
                int n = FqNamesUtilKt.tail(object3, fqName2).asString().length();
                do {
                    Map.Entry n2;
                    FqName fqName3;
                    int n3;
                    if (n <= (n3 = FqNamesUtilKt.tail(fqName3 = (FqName)(n2 = (Map.Entry)((Object)(iterator5 = iterator2.next()))).getKey(), fqName2).asString().length())) continue;
                    object = iterator5;
                    n = n3;
                } while (iterator2.hasNext());
                iterator3 = object;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)iterator3);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }
}

