/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.KeywordStringsGenerated;
import kotlin.text.StringsKt;

public final class RenderingUtilsKt {
    public static final String render(Name object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (RenderingUtilsKt.shouldBeEscaped((Name)object)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = ((Name)object).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            object = string;
            return stringBuilder.append("`" + (String)object).append('`').toString();
        }
        String string = ((Name)object).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final boolean shouldBeEscaped(Name object) {
        block5: {
            block4: {
                boolean bl;
                block3: {
                    String string = ((Name)object).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    object = string;
                    if (KeywordStringsGenerated.KEYWORDS.contains(object)) break block4;
                    CharSequence charSequence = (CharSequence)object;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char c;
                        char c2 = charSequence.charAt(i);
                        c2 = c2;
                        if (!(!Character.isLetterOrDigit(c) && c2 != '_')) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl && !(((CharSequence)object).length() == 0) && Character.isJavaIdentifierStart(((String)object).codePointAt(0))) break block5;
            }
            return true;
        }
        return false;
    }

    public static final String render(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        List<Name> list = fqNameUnsafe.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        return RenderingUtilsKt.renderFqName(list);
    }

    public static final String renderFqName(List<Name> object) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(object, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            Name name = (Name)object.next();
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(RenderingUtilsKt.render(name));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public static final String replacePrefixesInTypeRepresentations(String string, String string2, String string3, String string4, String string5) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"");
        if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)string3, (String)string4, (boolean)false, (int)2, null)) {
            String string6 = string.substring(string2.length());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
            string = string6;
            String string7 = string3.substring(string4.length());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
            string2 = string7;
            string3 = string5 + string;
            if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                return string3;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(string, string2)) {
                return string3 + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return Intrinsics.areEqual((Object)string, (Object)StringsKt.replace$default((String)string2, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)string2, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(string + '?'), (Object)string2) || Intrinsics.areEqual((Object)("(" + string + ")?"), (Object)string2);
    }
}

