/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class SimpleTypeWithEnhancement
extends DelegatingSimpleType
implements TypeWithEnhancement {
    private final SimpleType delegate;
    private final KotlinType enhancement;

    public SimpleTypeWithEnhancement(SimpleType simpleType2, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        this.delegate = simpleType2;
        this.enhancement = kotlinType;
    }

    @Override
    protected final SimpleType getDelegate() {
        return this.delegate;
    }

    @Override
    public final KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    public final SimpleType getOrigin() {
        return this.getDelegate();
    }

    @Override
    public final SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(typeAttributes), this.getEnhancement());
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (SimpleType)unwrappedType;
    }

    @Override
    public final SimpleType makeNullableAsSpecified(boolean bl) {
        UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(bl), this.getEnhancement().unwrap().makeNullableAsSpecified(bl));
        Intrinsics.checkNotNull((Object)unwrappedType);
        return (SimpleType)unwrappedType;
    }

    @Override
    public final SimpleTypeWithEnhancement replaceDelegate(SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        return new SimpleTypeWithEnhancement(simpleType2, this.getEnhancement());
    }

    @Override
    public final SimpleTypeWithEnhancement refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getDelegate());
        Intrinsics.checkNotNull((Object)kotlinType);
        return new SimpleTypeWithEnhancement((SimpleType)kotlinType, kotlinTypeRefiner.refineType(this.getEnhancement()));
    }

    @Override
    public final String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

