/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;

public final class CollectionsKt {
    public static final <K> Map<K, Integer> mapToIndex(Iterable<? extends K> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            int n2 = n++;
            Object e = object.next();
            Integer n3 = n2;
            ((Map)linkedHashMap).put(e, n3);
        }
        return linkedHashMap;
    }

    public static final <T> void addIfNotNull(Collection<T> collection, T t) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        if (t != null) {
            collection.add(t);
        }
    }

    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int n) {
        return new HashMap(CollectionsKt.capacity(n));
    }

    public static final <E> HashSet<E> newHashSetWithExpectedSize(int n) {
        return new HashSet(CollectionsKt.capacity(n));
    }

    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int n) {
        return new LinkedHashSet(CollectionsKt.capacity(n));
    }

    private static final int capacity(int n) {
        if (n < 3) {
            return 3;
        }
        int n2 = n;
        return n2 + n2 / 3 + 1;
    }

    public static final <T> List<T> compact(ArrayList<T> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"");
        switch (arrayList.size()) {
            case 0: {
                return kotlin.collections.CollectionsKt.emptyList();
            }
            case 1: {
                return kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)arrayList));
            }
        }
        ArrayList<T> arrayList2 = arrayList;
        arrayList.trimToSize();
        return arrayList;
    }
}

