/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.FileMonitor$FileEvent;
import com.sun.jna.platform.FileMonitor$FileListener;
import com.sun.jna.platform.FileMonitor$Holder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FileMonitor {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_ACCESSED = 8;
    public static final int FILE_NAME_CHANGED_OLD = 16;
    public static final int FILE_NAME_CHANGED_NEW = 32;
    public static final int FILE_RENAMED = 48;
    public static final int FILE_SIZE_CHANGED = 64;
    public static final int FILE_ATTRIBUTES_CHANGED = 128;
    public static final int FILE_SECURITY_CHANGED = 256;
    public static final int FILE_ANY = 511;
    private final Map<File, Integer> watched = new HashMap<File, Integer>();
    private List<FileMonitor$FileListener> listeners = new ArrayList<FileMonitor$FileListener>();

    protected abstract void watch(File var1, int var2, boolean var3);

    protected abstract void unwatch(File var1);

    public abstract void dispose();

    public void addWatch(File file) {
        this.addWatch(file, 511);
    }

    public void addWatch(File file, int n) {
        this.addWatch(file, n, file.isDirectory());
    }

    public void addWatch(File file, int n, boolean bl) {
        this.watched.put(file, n);
        this.watch(file, n, bl);
    }

    public void removeWatch(File file) {
        if (this.watched.remove(file) != null) {
            this.unwatch(file);
        }
    }

    protected void notify(FileMonitor$FileEvent fileMonitor$FileEvent) {
        for (FileMonitor$FileListener fileMonitor$FileListener : this.listeners) {
            fileMonitor$FileListener.fileChanged(fileMonitor$FileEvent);
        }
    }

    public synchronized void addFileListener(FileMonitor$FileListener fileMonitor$FileListener) {
        ArrayList<FileMonitor$FileListener> arrayList = new ArrayList<FileMonitor$FileListener>(this.listeners);
        arrayList.add(fileMonitor$FileListener);
        this.listeners = arrayList;
    }

    public synchronized void removeFileListener(FileMonitor$FileListener fileMonitor$FileListener) {
        ArrayList<FileMonitor$FileListener> arrayList = new ArrayList<FileMonitor$FileListener>(this.listeners);
        arrayList.remove(fileMonitor$FileListener);
        this.listeners = arrayList;
    }

    protected void finalize() {
        for (File file : this.watched.keySet()) {
            this.removeWatch(file);
        }
        this.dispose();
    }

    public static FileMonitor getInstance() {
        return FileMonitor$Holder.INSTANCE;
    }
}

