/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util$1;
import com.sun.jna.platform.win32.Kernel32Util$2;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Tlhelp32$MODULEENTRY32W;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinBase$SECURITY_ATTRIBUTES;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$HMODULE;
import com.sun.jna.platform.win32.WinDef$HRSRC;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.platform.win32.WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION;
import com.sun.jna.platform.win32.WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Kernel32Util
implements WinDef {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String VOLUME_GUID_PATH_PREFIX = "\\\\?\\Volume{";
    public static final String VOLUME_GUID_PATH_SUFFIX = "}\\";

    public static String getComputerName() {
        char[] cArray = new char[WinBase.MAX_COMPUTERNAME_LENGTH + 1];
        IntByReference intByReference = new IntByReference(cArray.length);
        if (!Kernel32.INSTANCE.GetComputerName(cArray, intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])cArray);
    }

    public static void freeLocalMemory(Pointer pointer) {
        if ((pointer = Kernel32.INSTANCE.LocalFree(pointer)) != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void freeGlobalMemory(Pointer pointer) {
        if ((pointer = Kernel32.INSTANCE.GlobalFree(pointer)) != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void closeHandleRefs(WinNT$HANDLEByReference ... winNT$HANDLEByReferenceArray) {
        Win32Exception win32Exception = null;
        for (WinNT$HANDLEByReference winNT$HANDLEByReference : winNT$HANDLEByReferenceArray) {
            try {
                Kernel32Util.closeHandleRef(winNT$HANDLEByReference);
            }
            catch (Win32Exception win32Exception2) {
                if (win32Exception == null) {
                    win32Exception = win32Exception2;
                    continue;
                }
                win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception2));
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
    }

    public static void closeHandleRef(WinNT$HANDLEByReference winNT$HANDLEByReference) {
        Kernel32Util.closeHandle(winNT$HANDLEByReference == null ? null : winNT$HANDLEByReference.getValue());
    }

    public static void closeHandles(WinNT$HANDLE ... winNT$HANDLEArray) {
        Win32Exception win32Exception = null;
        for (WinNT$HANDLE winNT$HANDLE : winNT$HANDLEArray) {
            try {
                Kernel32Util.closeHandle(winNT$HANDLE);
            }
            catch (Win32Exception win32Exception2) {
                if (win32Exception == null) {
                    win32Exception = win32Exception2;
                    continue;
                }
                win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception2));
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
    }

    public static void closeHandle(WinNT$HANDLE winNT$HANDLE) {
        if (winNT$HANDLE == null) {
            return;
        }
        if (!Kernel32.INSTANCE.CloseHandle(winNT$HANDLE)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String formatMessage(int n) {
        Object object = new PointerByReference();
        if ((n = Kernel32.INSTANCE.FormatMessage(4864, null, n, 0, (PointerByReference)object, 0, null)) == 0) {
            throw new LastErrorException(Native.getLastError());
        }
        Pointer pointer = object.getValue();
        try {
            object = pointer.getWideString(0L);
            object = object.trim();
            return object;
        }
        finally {
            Kernel32Util.freeLocalMemory(pointer);
        }
    }

    public static String formatMessage(WinNT$HRESULT winNT$HRESULT) {
        return Kernel32Util.formatMessage(winNT$HRESULT.intValue());
    }

    public static String formatMessageFromLastErrorCode(int n) {
        return Kernel32Util.formatMessage(W32Errors.HRESULT_FROM_WIN32(n));
    }

    public static String getLastErrorMessage() {
        return Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError());
    }

    public static String getTempPath() {
        WinDef$DWORD winDef$DWORD = new WinDef$DWORD(260L);
        char[] cArray = new char[winDef$DWORD.intValue()];
        if (Kernel32.INSTANCE.GetTempPath(winDef$DWORD, cArray).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])cArray);
    }

    public static void deleteFile(String string) {
        if (!Kernel32.INSTANCE.DeleteFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static List<String> getLogicalDriveStrings() {
        WinDef$DWORD winDef$DWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(new WinDef$DWORD(0L), null);
        if (winDef$DWORD.intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] cArray = new char[winDef$DWORD.intValue()];
        int n = (winDef$DWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(winDef$DWORD, cArray)).intValue();
        if (n <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList((char[])cArray, (int)0, (int)n);
    }

    public static int getFileAttributes(String string) {
        int n = Kernel32.INSTANCE.GetFileAttributes(string);
        if (n == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return n;
    }

    /*
     * Loose catch block
     */
    public static int getFileType(String object) {
        File file = new File((String)object);
        if (!file.exists()) {
            throw new FileNotFoundException((String)object);
        }
        WinNT$HANDLE winNT$HANDLE = null;
        Win32Exception win32Exception = null;
        WinNT$HANDLE winNT$HANDLE2 = Kernel32.INSTANCE.CreateFile((String)object, Integer.MIN_VALUE, 1, new WinBase$SECURITY_ATTRIBUTES(), 3, 128, new WinNT$HANDLEByReference().getValue());
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)winNT$HANDLE2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        int n = Kernel32.INSTANCE.GetFileType(winNT$HANDLE2);
        block4 : switch (n) {
            case 0: {
                int n2 = Kernel32.INSTANCE.GetLastError();
                switch (n2) {
                    case 0: {
                        break block4;
                    }
                }
                throw new Win32Exception(n2);
            }
        }
        try {
            Kernel32Util.closeHandle(winNT$HANDLE2);
        }
        catch (Win32Exception win32Exception2) {
            if (win32Exception == null) {
                win32Exception = win32Exception2;
            }
            win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception2));
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return n;
        catch (Win32Exception win32Exception3) {
            try {
                Win32Exception win32Exception4 = win32Exception3;
                win32Exception = win32Exception3;
                throw win32Exception3;
            }
            catch (Throwable throwable) {
                block20: {
                    try {
                        Kernel32Util.closeHandle(winNT$HANDLE);
                    }
                    catch (Win32Exception win32Exception5) {
                        if (win32Exception == null) {
                            win32Exception = win32Exception5;
                            break block20;
                        }
                        win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception5));
                    }
                }
                if (win32Exception != null) {
                    throw win32Exception;
                }
                throw throwable;
            }
        }
    }

    public static int getDriveType(String string) {
        return Kernel32.INSTANCE.GetDriveType(string);
    }

    public static String getEnvironmentVariable(String string) {
        int n = Kernel32.INSTANCE.GetEnvironmentVariable(string, null, 0);
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] cArray = new char[n];
        if ((n = Kernel32.INSTANCE.GetEnvironmentVariable(string, cArray, n)) <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])cArray);
    }

    public static Map<String, String> getEnvironmentVariables() {
        Pointer pointer = Kernel32.INSTANCE.GetEnvironmentStrings();
        if (pointer == null) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        try {
            Map<String, String> map = Kernel32Util.getEnvironmentVariables(pointer, 0L);
            return map;
        }
        finally {
            if (!Kernel32.INSTANCE.FreeEnvironmentStrings(pointer)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    public static Map<String, String> getEnvironmentVariables(Pointer pointer, long l) {
        String string;
        int n;
        if (pointer == null) {
            return null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        boolean bl = Kernel32Util.isWideCharEnvironmentStringBlock(pointer, l);
        long l2 = bl ? 2L : 1L;
        long l3 = l;
        while ((n = (string = Kernel32Util.readEnvironmentStringBlockEntry(pointer, l3, bl)).length()) != 0) {
            int n2 = string.indexOf(61);
            if (n2 < 0) {
                throw new IllegalArgumentException("Missing variable value separator in " + string);
            }
            String string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            treeMap.put(string2, string);
            l3 += (long)(n + 1) * l2;
        }
        return treeMap;
    }

    public static String readEnvironmentStringBlockEntry(Pointer pointer, long l, boolean bl) {
        long l2 = Kernel32Util.findEnvironmentStringBlockEntryEnd(pointer, l, bl);
        int n = (int)(l2 - l);
        if (n == 0) {
            return "";
        }
        n = bl ? n / 2 : n;
        char[] cArray = new char[n];
        long l3 = l;
        long l4 = bl ? 2L : 1L;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        int n2 = 0;
        while (n2 < cArray.length) {
            byte by = pointer.getByte(l3);
            if (bl) {
                byte by2 = pointer.getByte(l3 + 1L);
                cArray[n2] = ByteOrder.LITTLE_ENDIAN.equals(byteOrder) ? (char)(by2 << 8 & 0xFF00 | by & 0xFF) : (char)(by << 8 & 0xFF00 | by2 & 0xFF);
            } else {
                cArray[n2] = (char)(by & 0xFF);
            }
            ++n2;
            l3 += l4;
        }
        return new String(cArray);
    }

    public static long findEnvironmentStringBlockEntryEnd(Pointer pointer, long l, boolean bl) {
        long l2;
        long l3 = l;
        long l4 = l2 = bl ? 2L : 1L;
        byte by;
        while ((by = pointer.getByte(l3)) != 0) {
            l3 += l2;
        }
        return l3;
    }

    public static boolean isWideCharEnvironmentStringBlock(Pointer pointer, long l) {
        byte by = pointer.getByte(l);
        byte by2 = pointer.getByte(l + 1L);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Kernel32Util.isWideCharEnvironmentStringBlock(by2);
        }
        return Kernel32Util.isWideCharEnvironmentStringBlock(by);
    }

    private static boolean isWideCharEnvironmentStringBlock(byte by) {
        return by == 0;
    }

    public static final int getPrivateProfileInt(String string, String string2, int n, String string3) {
        return Kernel32.INSTANCE.GetPrivateProfileInt(string, string2, n, string3);
    }

    public static final String getPrivateProfileString(String string, String string2, String string3, String string4) {
        char[] cArray = new char[1024];
        Kernel32.INSTANCE.GetPrivateProfileString(string, string2, string3, cArray, new WinDef$DWORD(1024L), string4);
        return Native.toString((char[])cArray);
    }

    public static final void writePrivateProfileString(String string, String string2, String string3, String string4) {
        if (!Kernel32.INSTANCE.WritePrivateProfileString(string, string2, string3, string4)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] getLogicalProcessorInformation() {
        Object object;
        int n = new WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION().size();
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD(n));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformation((Pointer)(object = new Memory((long)winDef$DWORDByReference.getValue().intValue())), winDef$DWORDByReference)) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 == 122) continue;
            throw new Win32Exception(n2);
        }
        object = new WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION((Pointer)object);
        n = winDef$DWORDByReference.getValue().intValue() / n;
        return (WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])object.toArray((Structure[])new WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION[n]);
    }

    public static final WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] getLogicalProcessorInformationEx(int n) {
        WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX winNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;
        Memory memory;
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD(1L));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformationEx(n, (Pointer)(memory = new Memory((long)winDef$DWORDByReference.getValue().intValue())), winDef$DWORDByReference)) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 == 122) continue;
            throw new Win32Exception(n2);
        }
        ArrayList<WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX> arrayList = new ArrayList<WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX>();
        for (n = 0; n < winDef$DWORDByReference.getValue().intValue(); n += winNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX.size) {
            winNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX = WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX.fromPointer(memory.share((long)n));
            arrayList.add(winNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX);
        }
        return arrayList.toArray(new WinNT$SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[0]);
    }

    public static final String[] getPrivateProfileSection(String string, String string2) {
        char[] cArray = new char[32768];
        if (Kernel32.INSTANCE.GetPrivateProfileSection(string, cArray, new WinDef$DWORD(32768L), string2).intValue() == 0) {
            int n = Kernel32.INSTANCE.GetLastError();
            if (n == 0) {
                return EMPTY_STRING_ARRAY;
            }
            throw new Win32Exception(n);
        }
        return new String(cArray).split("\u0000");
    }

    public static final String[] getPrivateProfileSectionNames(String string) {
        char[] cArray = new char[65536];
        if (Kernel32.INSTANCE.GetPrivateProfileSectionNames(cArray, new WinDef$DWORD(65536L), string).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new String(cArray).split("\u0000");
    }

    public static final void writePrivateProfileSection(String string, String[] stringArray, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(string3).append('\u0000');
        }
        stringBuilder.append('\u0000');
        if (!Kernel32.INSTANCE.WritePrivateProfileSection(string, stringBuilder.toString(), string2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final List<String> queryDosDevice(String string, int n) {
        char[] cArray = new char[n];
        int n2 = Kernel32.INSTANCE.QueryDosDevice(string, cArray, n);
        if (n2 == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList((char[])cArray, (int)0, (int)n2);
    }

    public static final List<String> getVolumePathNamesForVolumeName(String string) {
        int n;
        char[] cArray = new char[261];
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string, cArray, 261, intByReference)) {
            n = Kernel32.INSTANCE.GetLastError();
            if (n != 234) {
                throw new Win32Exception(n);
            }
            n = intByReference.getValue();
            cArray = new char[n];
            if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string, cArray, n, intByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
        n = intByReference.getValue();
        return Native.toStringList((char[])cArray, (int)0, (int)n);
    }

    public static final String extractVolumeGUID(String string) {
        if (string == null || string.length() <= 11 + 2 || !string.startsWith(VOLUME_GUID_PATH_PREFIX) || !string.endsWith(VOLUME_GUID_PATH_SUFFIX)) {
            throw new IllegalArgumentException("Bad volume GUID path format: " + string);
        }
        return string.substring(11, string.length() - 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String QueryFullProcessImageName(int n, int n2) {
        String string;
        WinNT$HANDLE winNT$HANDLE = null;
        Win32Exception win32Exception = null;
        try {
            winNT$HANDLE = Kernel32.INSTANCE.OpenProcess(1040, false, n);
            if (winNT$HANDLE == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            string = Kernel32Util.QueryFullProcessImageName(winNT$HANDLE, n2);
        }
        catch (Win32Exception win32Exception2) {
            try {
                Win32Exception win32Exception4 = win32Exception2;
                win32Exception = win32Exception2;
                throw win32Exception2;
            }
            catch (Throwable throwable) {
                block13: {
                    try {
                        Kernel32Util.closeHandle(winNT$HANDLE);
                    }
                    catch (Win32Exception win32Exception5) {
                        if (win32Exception == null) {
                            win32Exception = win32Exception5;
                            break block13;
                        }
                        win32Exception.addSuppressed((Throwable)((Object)win32Exception5));
                    }
                }
                if (win32Exception != null) {
                    throw win32Exception;
                }
                throw throwable;
            }
        }
        try {
            Kernel32Util.closeHandle(winNT$HANDLE);
        }
        catch (Win32Exception win32Exception2) {
            if (win32Exception == null) {
                win32Exception = win32Exception2;
            }
            win32Exception.addSuppressed((Throwable)((Object)win32Exception2));
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return string;
    }

    public static final String QueryFullProcessImageName(WinNT$HANDLE winNT$HANDLE, int n) {
        int n2 = 260;
        IntByReference intByReference = new IntByReference();
        do {
            char[] cArray = new char[n2];
            intByReference.setValue(n2);
            if (Kernel32.INSTANCE.QueryFullProcessImageName(winNT$HANDLE, n, cArray, intByReference)) {
                return new String(cArray, 0, intByReference.getValue());
            }
            n2 += 1024;
        } while (Kernel32.INSTANCE.GetLastError() == 122);
        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
    }

    public static byte[] getResource(String object, String object2, String string) {
        byte[] byArray;
        Win32Exception win32Exception;
        block16: {
            Object object3;
            block17: {
                if ((object = Kernel32.INSTANCE.LoadLibraryEx((String)object, null, 2)) == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                win32Exception = null;
                byArray = null;
                try {
                    try {
                        object3 = new Pointer(Long.parseLong(object2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object3 = new Memory((long)(Native.WCHAR_SIZE * (object2.length() + 1)));
                        object3.setWideString(0L, object2);
                    }
                    try {
                        object2 = new Pointer(Long.parseLong(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2 = new Memory((long)(Native.WCHAR_SIZE * (string.length() + 1)));
                        object2.setWideString(0L, string);
                    }
                    object2 = Kernel32.INSTANCE.FindResource((WinDef$HMODULE)((Object)object), (Pointer)object2, (Pointer)object3);
                    if (object2 == null) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    object3 = Kernel32.INSTANCE.LoadResource((WinDef$HMODULE)((Object)object), (WinDef$HRSRC)((Object)object2));
                    if (object3 == null) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    int n = Kernel32.INSTANCE.SizeofResource((WinDef$HMODULE)((Object)object), (WinNT$HANDLE)((Object)object2));
                    if (n == 0) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    object2 = Kernel32.INSTANCE.LockResource((WinNT$HANDLE)((Object)object3));
                    if (object2 == null) {
                        throw new IllegalStateException("LockResource returned null.");
                    }
                    byArray = object2.getByteArray(0L, n);
                    if (object == null || Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) break block16;
                    object3 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    if (win32Exception == null) break block17;
                    object3.addSuppressedReflected((Throwable)((Object)win32Exception));
                }
                catch (Win32Exception win32Exception2) {
                    Win32Exception win32Exception3 = win32Exception2;
                    win32Exception = win32Exception2;
                    if (object != null && !Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) {
                        win32Exception3 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        win32Exception3.addSuppressedReflected((Throwable)((Object)win32Exception));
                        throw win32Exception3;
                    }
                }
                catch (Throwable throwable) {
                    if (object != null && !Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) {
                        object = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        if (win32Exception != null) {
                            ((Win32Exception)((Object)object)).addSuppressedReflected((Throwable)((Object)win32Exception));
                        }
                        throw object;
                    }
                    throw throwable;
                }
            }
            throw object3;
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return byArray;
    }

    public static Map<String, List<String>> getResourceNames(String object) {
        Win32Exception win32Exception;
        LinkedHashMap<String, List<String>> linkedHashMap;
        block12: {
            Object object2;
            block13: {
                if ((object = Kernel32.INSTANCE.LoadLibraryEx((String)object, null, 2)) == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                object2 = new ArrayList();
                linkedHashMap = new LinkedHashMap<String, List<String>>();
                Kernel32Util$1 kernel32Util$1 = new Kernel32Util$1((List)object2);
                Kernel32Util$2 kernel32Util$2 = new Kernel32Util$2(linkedHashMap);
                win32Exception = null;
                try {
                    if (!Kernel32.INSTANCE.EnumResourceTypes((WinDef$HMODULE)((Object)object), kernel32Util$1, null)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        boolean bl;
                        Pointer pointer;
                        String string = (String)object2.next();
                        linkedHashMap.put(string, new ArrayList());
                        try {
                            pointer = new Pointer(Long.parseLong(string));
                        }
                        catch (NumberFormatException numberFormatException) {
                            pointer = new Memory((long)(Native.WCHAR_SIZE * (string.length() + 1)));
                            pointer.setWideString(0L, string);
                        }
                        if (bl = Kernel32.INSTANCE.EnumResourceNames((WinDef$HMODULE)((Object)object), pointer, kernel32Util$2, null)) continue;
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (object == null || Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) break block12;
                    object2 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    if (win32Exception == null) break block13;
                    ((Win32Exception)((Object)object2)).addSuppressedReflected((Throwable)((Object)win32Exception));
                }
                catch (Win32Exception win32Exception2) {
                    object2 = win32Exception2;
                    win32Exception = win32Exception2;
                    if (object != null && !Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) {
                        object2 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        ((Win32Exception)((Object)object2)).addSuppressedReflected((Throwable)((Object)win32Exception));
                        throw object2;
                    }
                }
                catch (Throwable throwable) {
                    if (object != null && !Kernel32.INSTANCE.FreeLibrary((WinDef$HMODULE)((Object)object))) {
                        object = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        if (win32Exception != null) {
                            ((Win32Exception)((Object)object)).addSuppressedReflected((Throwable)((Object)win32Exception));
                        }
                        throw object;
                    }
                    throw throwable;
                }
            }
            throw object2;
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return linkedHashMap;
    }

    public static List<Tlhelp32$MODULEENTRY32W> getModules(int n) {
        WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPMODULE, new WinDef$DWORD(n));
        if (winNT$HANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            Tlhelp32$MODULEENTRY32W tlhelp32$MODULEENTRY32W = new Tlhelp32$MODULEENTRY32W();
            if (!Kernel32.INSTANCE.Module32FirstW(winNT$HANDLE, tlhelp32$MODULEENTRY32W)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            ArrayList<Tlhelp32$MODULEENTRY32W> arrayList = new ArrayList<Tlhelp32$MODULEENTRY32W>();
            arrayList.add(tlhelp32$MODULEENTRY32W);
            tlhelp32$MODULEENTRY32W = new Tlhelp32$MODULEENTRY32W();
            while (Kernel32.INSTANCE.Module32NextW(winNT$HANDLE, tlhelp32$MODULEENTRY32W)) {
                arrayList.add(tlhelp32$MODULEENTRY32W);
                tlhelp32$MODULEENTRY32W = new Tlhelp32$MODULEENTRY32W();
            }
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 != 0 && n2 != 18) {
                throw new Win32Exception(n2);
            }
            ArrayList<Tlhelp32$MODULEENTRY32W> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Win32Exception win32Exception2) {
            Win32Exception win32Exception3 = win32Exception2;
            win32Exception = win32Exception2;
            throw win32Exception2;
        }
        finally {
            try {
                Kernel32Util.closeHandle(winNT$HANDLE);
            }
            catch (Win32Exception win32Exception4) {
                if (win32Exception == null) {
                    win32Exception = win32Exception4;
                }
                win32Exception.addSuppressedReflected((Throwable)((Object)win32Exception4));
            }
            if (win32Exception != null) {
                throw win32Exception;
            }
        }
    }

    public static String expandEnvironmentStrings(String string) {
        if (string == null) {
            return "";
        }
        int n = Kernel32.INSTANCE.ExpandEnvironmentStrings(string, null, 0);
        if (n == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Memory memory = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? new Memory((long)(n * Native.WCHAR_SIZE)) : new Memory((long)(n + 1));
        n = Kernel32.INSTANCE.ExpandEnvironmentStrings(string, (Pointer)memory, n);
        if (n == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }
}

