/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ImcplicitActionDataForBasicProperty;
import ch.qos.logback.core.joran.action.ImplicitModelData;
import ch.qos.logback.core.joran.action.ImplicitModelDataForComplexProperty;
import ch.qos.logback.core.joran.spi.NoAutoStartUtil;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;

public class ImplicitModelHandler
extends ModelHandlerBase {
    private final BeanDescriptionCache beanDescriptionCache;
    private ImplicitModelData implicitModelData;
    static final String PARENT_PROPPERTY_KEY = "parent";
    public static final String IGNORING_UNKNOWN_PROP = "Ignoring unknown property";
    boolean inError = false;

    public ImplicitModelHandler(Context context, BeanDescriptionCache beanDescriptionCache) {
        super(context);
        this.beanDescriptionCache = beanDescriptionCache;
    }

    protected Class<? extends ImplicitModel> getSupportedModelClass() {
        return ImplicitModel.class;
    }

    public static ImplicitModelHandler makeInstance(Context context, ModelInterpretationContext contextAwareBase) {
        contextAwareBase = contextAwareBase.getBeanDescriptionCache();
        return new ImplicitModelHandler(context, (BeanDescriptionCache)contextAwareBase);
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) {
        Object object2 = (ImplicitModel)object;
        if (modelInterpretationContext.isObjectStackEmpty()) {
            this.inError = true;
            return;
        }
        String string = ((Model)object2).getTag();
        Object object3 = modelInterpretationContext.peekObject();
        PropertySetter propertySetter = new PropertySetter(this.beanDescriptionCache, object3);
        propertySetter.setContext(this.context);
        AggregationType aggregationType = propertySetter.computeAggregationType(string);
        switch (aggregationType) {
            case NOT_FOUND: {
                this.addWarn("Ignoring unknown property [" + string + "] in [" + object3.getClass().getName() + "]");
                this.inError = true;
                ((Model)object2).markAsSkipped();
                return;
            }
            case AS_BASIC_PROPERTY: 
            case AS_BASIC_PROPERTY_COLLECTION: {
                this.implicitModelData = object2 = new ImcplicitActionDataForBasicProperty(propertySetter, aggregationType, string);
                this.doBasicProperty(modelInterpretationContext, (Model)object, (ImcplicitActionDataForBasicProperty)object2);
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: 
            case AS_COMPLEX_PROPERTY: {
                this.implicitModelData = object = new ImplicitModelDataForComplexProperty(propertySetter, aggregationType, string);
                this.doComplex(modelInterpretationContext, (ComponentModel)object2, (ImplicitModelDataForComplexProperty)object);
                return;
            }
        }
        this.addError("PropertySetter.computeAggregationType returned " + String.valueOf((Object)aggregationType));
    }

    void doBasicProperty(ModelInterpretationContext object, Model model, ImcplicitActionDataForBasicProperty imcplicitActionDataForBasicProperty) {
        object = ((ModelInterpretationContext)object).subst(model.getBodyText());
        switch (imcplicitActionDataForBasicProperty.aggregationType) {
            case AS_BASIC_PROPERTY: {
                imcplicitActionDataForBasicProperty.parentBean.setProperty(imcplicitActionDataForBasicProperty.propertyName, (String)object);
                return;
            }
            case AS_BASIC_PROPERTY_COLLECTION: {
                imcplicitActionDataForBasicProperty.parentBean.addBasicProperty(imcplicitActionDataForBasicProperty.propertyName, (String)object);
                return;
            }
        }
        this.addError("Unexpected aggregationType " + String.valueOf((Object)imcplicitActionDataForBasicProperty.aggregationType));
    }

    public void doComplex(ModelInterpretationContext object, ComponentModel componentModel, ImplicitModelDataForComplexProperty implicitModelDataForComplexProperty) {
        String string = componentModel.getClassName();
        string = ((ModelInterpretationContext)object).subst(string);
        string = ((ModelInterpretationContext)object).getImport(string);
        try {
            Object object2;
            if (!OptionHelper.isNullOrEmpty(string)) {
                object2 = Loader.loadClass(string, this.context);
            } else {
                object2 = implicitModelDataForComplexProperty.parentBean;
                object2 = ((PropertySetter)object2).getClassNameViaImplicitRules(implicitModelDataForComplexProperty.propertyName, implicitModelDataForComplexProperty.getAggregationType(), ((ModelInterpretationContext)object).getDefaultNestedComponentRegistry());
            }
            if (object2 == null) {
                implicitModelDataForComplexProperty.inError = true;
                object2 = "Could not find an appropriate class for property [" + componentModel.getTag() + "]";
                this.addError((String)object2);
                return;
            }
            if (OptionHelper.isNullOrEmpty(string)) {
                this.addInfo("Assuming default type [" + ((Class)object2).getName() + "] for [" + componentModel.getTag() + "] property");
            }
            implicitModelDataForComplexProperty.setNestedComplexProperty(((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]));
            if (implicitModelDataForComplexProperty.getNestedComplexProperty() instanceof ContextAware) {
                ((ContextAware)implicitModelDataForComplexProperty.getNestedComplexProperty()).setContext(this.context);
            }
            ((ModelInterpretationContext)object).pushObject(implicitModelDataForComplexProperty.getNestedComplexProperty());
            return;
        }
        catch (Exception exception) {
            implicitModelDataForComplexProperty.inError = true;
            object = "Could not create component [" + componentModel.getTag() + "] of type [" + string + "]";
            this.addError((String)object, exception);
            return;
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        if (this.implicitModelData == null) {
            return;
        }
        if (this.implicitModelData.inError) {
            return;
        }
        if (this.implicitModelData instanceof ImplicitModelDataForComplexProperty) {
            this.postHandleComplex(modelInterpretationContext, model, (ImplicitModelDataForComplexProperty)this.implicitModelData);
        }
    }

    private void postHandleComplex(ModelInterpretationContext modelInterpretationContext, Model model, ImplicitModelDataForComplexProperty implicitModelDataForComplexProperty) {
        Object object = new PropertySetter(this.beanDescriptionCache, implicitModelDataForComplexProperty.getNestedComplexProperty());
        ((ContextAwareBase)object).setContext(this.context);
        if (((PropertySetter)object).computeAggregationType(PARENT_PROPPERTY_KEY) == AggregationType.AS_COMPLEX_PROPERTY) {
            ((PropertySetter)object).setComplexProperty(PARENT_PROPPERTY_KEY, implicitModelDataForComplexProperty.parentBean.getObj());
        }
        if ((object = implicitModelDataForComplexProperty.getNestedComplexProperty()) instanceof LifeCycle && NoAutoStartUtil.notMarkedWithNoAutoStart(object)) {
            ((LifeCycle)object).start();
        }
        if ((object = modelInterpretationContext.peekObject()) != implicitModelDataForComplexProperty.getNestedComplexProperty()) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
            return;
        }
        modelInterpretationContext.popObject();
        switch (implicitModelDataForComplexProperty.aggregationType) {
            case AS_COMPLEX_PROPERTY: {
                implicitModelDataForComplexProperty.parentBean.setComplexProperty(model.getTag(), implicitModelDataForComplexProperty.getNestedComplexProperty());
                return;
            }
            case AS_COMPLEX_PROPERTY_COLLECTION: {
                implicitModelDataForComplexProperty.parentBean.addComplexProperty(model.getTag(), implicitModelDataForComplexProperty.getNestedComplexProperty());
                return;
            }
        }
        this.addError("Unexpected aggregationType " + String.valueOf((Object)implicitModelDataForComplexProperty.aggregationType));
    }
}

