/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.List;

public class StatusPrinter {
    private static PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printInCaseOfErrorsOrWarnings(Context context) {
        StatusPrinter.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public static void printInCaseOfErrorsOrWarnings(Context object, long l) {
        if (object == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = object.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + object.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(l) > 0) {
            StatusPrinter.print(statusManager, l);
        }
    }

    public static void printIfErrorsOccured(Context object) {
        if (object == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = object.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + object.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(0L) == 2) {
            StatusPrinter.print(statusManager);
        }
    }

    public static void print(Context context) {
        StatusPrinter.print(context, 0L);
    }

    public static void print(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        StatusPrinter.print(statusManager, l);
    }

    public static void print(StatusManager statusManager) {
        StatusPrinter.print(statusManager, 0L);
    }

    public static void print(StatusManager object, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        object = StatusUtil.filterStatusListByTimeThreshold(object.getCopyOfStatusList(), l);
        StatusPrinter.buildStrFromStatusList(stringBuilder, (List<Status>)object);
        ps.println(stringBuilder.toString());
    }

    public static void print(List<Status> list) {
        StringBuilder stringBuilder = new StringBuilder();
        StatusPrinter.buildStrFromStatusList(stringBuilder, list);
        ps.println(stringBuilder.toString());
    }

    private static void buildStrFromStatusList(StringBuilder stringBuilder, List<Status> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            StatusPrinter.buildStr(stringBuilder, "", status);
        }
    }

    private static void appendThrowable(StringBuilder stringBuilder, Throwable stringArray) {
        String[] stringArray2 = ThrowableToStringArray.convert((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    stringBuilder.append("\t... ");
                } else {
                    stringBuilder.append("\tat ");
                }
            }
            stringBuilder.append(string).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder stringBuilder, String string, Status status) {
        Object object;
        String string2 = status.hasChildren() ? string + "+ " : string + "|-";
        if (cachingDateFormat != null) {
            object = cachingDateFormat.format(status.getTimestamp());
            stringBuilder.append((String)object).append(" ");
        }
        stringBuilder.append(string2).append(status).append(CoreConstants.LINE_SEPARATOR);
        if (status.getThrowable() != null) {
            StatusPrinter.appendThrowable(stringBuilder, status.getThrowable());
        }
        if (status.hasChildren()) {
            object = status.iterator();
            while (object.hasNext()) {
                status = (Status)object.next();
                StatusPrinter.buildStr(stringBuilder, string + "  ", status);
            }
        }
    }
}

