/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.PoolableCallableStatement;
import org.apache.commons.dbcp.PoolablePreparedStatement;
import org.apache.commons.dbcp.PoolingConnection$PStmtKey;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    private KeyedObjectPool c = null;

    public PoolingConnection(Connection connection, KeyedObjectPool keyedObjectPool) {
        super(connection);
        this.c = keyedObjectPool;
    }

    @Override
    public synchronized void close() {
        if (this.c != null) {
            Object object = this.c;
            this.c = null;
            try {
                object.d();
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                object = sQLException;
                throw sQLException;
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Cannot close connection").initCause(exception);
            }
        }
        this.i().close();
    }

    @Override
    public PreparedStatement prepareStatement(String object) {
        if (this.c == null) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.c.d(this.a((String)object));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String object, int n, int n2) {
        if (this.c == null) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.c.d(this.a((String)object, n, n2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String object) {
        try {
            return (CallableStatement)this.c.d(this.a((String)object, (byte)1));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow callableStatement from pool failed", exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String object, int n, int n2) {
        try {
            return (CallableStatement)this.c.d(this.a((String)object, n, n2, (byte)1));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow callableStatement from pool failed", exception);
        }
    }

    private Object a(String string, int n, int n2) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {}
        return new PoolingConnection$PStmtKey(string.trim(), string2, n, n2);
    }

    private Object a(String string, int n, int n2, byte by) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {}
        return new PoolingConnection$PStmtKey(string.trim(), string2, n, n2, 1);
    }

    private Object a(String string) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {}
        return new PoolingConnection$PStmtKey(string.trim(), string2);
    }

    private Object a(String string, byte by) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {}
        return new PoolingConnection$PStmtKey(string.trim(), string2, 1);
    }

    public final Object a(Object object) {
        if (object == null || !(object instanceof PoolingConnection$PStmtKey)) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        object = (PoolingConnection$PStmtKey)object;
        if (((PoolingConnection$PStmtKey)object).b == null && ((PoolingConnection$PStmtKey)object).c == null) {
            if (((PoolingConnection$PStmtKey)object).d == 0) {
                return new PoolablePreparedStatement(this.g().prepareStatement(((PoolingConnection$PStmtKey)object).a), object, this.c, this);
            }
            return new PoolableCallableStatement(this.g().prepareCall(((PoolingConnection$PStmtKey)object).a), object, this.c, this);
        }
        if (((PoolingConnection$PStmtKey)object).d == 0) {
            return new PoolablePreparedStatement(this.g().prepareStatement(((PoolingConnection$PStmtKey)object).a, ((PoolingConnection$PStmtKey)object).b, ((PoolingConnection$PStmtKey)object).c), object, this.c, this);
        }
        return new PoolableCallableStatement(this.g().prepareCall(((PoolingConnection$PStmtKey)object).a, ((PoolingConnection$PStmtKey)object).b, ((PoolingConnection$PStmtKey)object).c), object, this.c, this);
    }

    public final void a(Object object, Object object2) {
        if (object2 instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)object2).g().close();
            return;
        }
        ((PreparedStatement)object2).close();
    }

    public final boolean b(Object object, Object object2) {
        return true;
    }

    public final void c(Object object, Object object2) {
        ((DelegatingPreparedStatement)object2).i();
    }

    public final void d(Object object, Object object2) {
        ((PreparedStatement)object2).clearParameters();
        ((DelegatingPreparedStatement)object2).j();
    }

    @Override
    public String toString() {
        if (this.c != null) {
            return "PoolingConnection: " + this.c.toString();
        }
        return "PoolingConnection: null";
    }
}

