/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.JavaIncompatibilityRulesOverridabilityCondition$Companion;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialGenericSignatures;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition$Contract;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition$Result;

public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    public static final JavaIncompatibilityRulesOverridabilityCondition$Companion Companion = new JavaIncompatibilityRulesOverridabilityCondition$Companion(null);

    @Override
    public final ExternalOverridabilityCondition$Result isOverridable(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)callableDescriptor2, (String)"");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(callableDescriptor, callableDescriptor2, classDescriptor)) {
            return ExternalOverridabilityCondition$Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(callableDescriptor, callableDescriptor2)) {
            return ExternalOverridabilityCondition$Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition$Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, ClassDescriptor classDescriptor) {
        if (!(callableDescriptor instanceof CallableMemberDescriptor) || !(callableDescriptor2 instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(callableDescriptor2)) {
            return false;
        }
        Name name = ((FunctionDescriptor)callableDescriptor2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            Name name2 = ((FunctionDescriptor)callableDescriptor2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
            if (!SpecialGenericSignatures.Companion.getSameAsRenamedInJvmBuiltin(name2)) {
                return false;
            }
        }
        CallableMemberDescriptor callableMemberDescriptor = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)callableDescriptor);
        FunctionDescriptor functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        boolean bl = functionDescriptor != null ? ((FunctionDescriptor)callableDescriptor2).isHiddenToOvercomeSignatureClash() == functionDescriptor.isHiddenToOvercomeSignatureClash() : false;
        boolean bl2 = !bl;
        if (bl2 && (callableMemberDescriptor == null || !((FunctionDescriptor)callableDescriptor2).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(classDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)callableDescriptor2).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (callableMemberDescriptor == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(classDescriptor, callableMemberDescriptor)) {
            return false;
        }
        if (callableMemberDescriptor instanceof FunctionDescriptor && callableDescriptor instanceof FunctionDescriptor && BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)callableMemberDescriptor) != null) {
            String string = MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)callableDescriptor2, false, false, 2, null);
            FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)callableDescriptor).getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor2, (String)"");
            if (Intrinsics.areEqual((Object)string, (Object)MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor2, false, false, 2, null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final ExternalOverridabilityCondition$Contract getContract() {
        return ExternalOverridabilityCondition$Contract.CONFLICTS_ONLY;
    }
}

