/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.FilteredAnnotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.DisjointKeysUnionTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor$1;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor$SubstitutionException;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor$VarianceConflictType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.utils.ExceptionUtilsKt;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    private final TypeSubstitution substitution;

    public static TypeSubstitutor create(TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(0);
        }
        return new TypeSubstitutor(typeSubstitution);
    }

    public TypeSubstitutor replaceWithNonApproximatingSubstitution() {
        if (!(this.substitution instanceof IndexedParametersSubstitution) || !this.substitution.approximateContravariantCapturedTypes()) {
            return this;
        }
        return new TypeSubstitutor(new IndexedParametersSubstitution(((IndexedParametersSubstitution)this.substitution).getParameters(), ((IndexedParametersSubstitution)this.substitution).getArguments(), false));
    }

    public static TypeSubstitutor createChainedSubstitutor(TypeSubstitution typeSubstitution, TypeSubstitution typeSubstitution2) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(3);
        }
        if (typeSubstitution2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(4);
        }
        return TypeSubstitutor.create(DisjointKeysUnionTypeSubstitution.create(typeSubstitution, typeSubstitution2));
    }

    public static TypeSubstitutor create(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(6);
        }
        return TypeSubstitutor.create(TypeConstructorSubstitution.create(kotlinType.getConstructor(), kotlinType.getArguments()));
    }

    protected TypeSubstitutor(TypeSubstitution typeSubstitution) {
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(7);
        }
        this.substitution = typeSubstitution;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(8);
        }
        return typeSubstitution;
    }

    public KotlinType safeSubstitute(KotlinType kotlinType, Variance variance) {
        KotlinType kotlinType2;
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(9);
        }
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(10);
        }
        if (this.isEmpty()) {
            KotlinType kotlinType3 = kotlinType;
            if (kotlinType3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(11);
            }
            return kotlinType3;
        }
        try {
            kotlinType2 = this.unsafeSubstitute(new TypeProjectionImpl(variance, kotlinType), null, 0).getType();
        }
        catch (TypeSubstitutor$SubstitutionException typeSubstitutor$SubstitutionException) {
            ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, typeSubstitutor$SubstitutionException.getMessage());
            if (errorType == null) {
                TypeSubstitutor.$$$reportNull$$$0(13);
            }
            return errorType;
        }
        if (kotlinType2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(12);
        }
        return kotlinType2;
    }

    public KotlinType substitute(KotlinType object, Variance variance) {
        if (object == null) {
            TypeSubstitutor.$$$reportNull$$$0(14);
        }
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(15);
        }
        if ((object = this.substitute(new TypeProjectionImpl(variance, this.getSubstitution().prepareTopLevelType((KotlinType)object, variance)))) == null) {
            return null;
        }
        return object.getType();
    }

    public TypeProjection substitute(TypeProjection typeProjection) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(16);
        }
        typeProjection = this.substituteWithoutApproximation(typeProjection);
        if (!this.substitution.approximateCapturedTypes() && !this.substitution.approximateContravariantCapturedTypes()) {
            return typeProjection;
        }
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary(typeProjection, this.substitution.approximateContravariantCapturedTypes());
    }

    public TypeProjection substituteWithoutApproximation(TypeProjection typeProjection) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(17);
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, null, 0);
        }
        catch (TypeSubstitutor$SubstitutionException typeSubstitutor$SubstitutionException) {
            return null;
        }
    }

    private TypeProjection unsafeSubstitute(TypeProjection object, TypeParameterDescriptor object2, int n) {
        if (object == null) {
            TypeSubstitutor.$$$reportNull$$$0(18);
        }
        TypeSubstitutor.assertRecursionDepth(n, (TypeProjection)object, this.substitution);
        if (object.isStarProjection()) {
            TypeProjection typeProjection = object;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(19);
            }
            return typeProjection;
        }
        KotlinType kotlinType = object.getType();
        if (kotlinType instanceof TypeWithEnhancement) {
            Object object3 = ((TypeWithEnhancement)((Object)kotlinType)).getOrigin();
            KotlinType kotlinType2 = ((TypeWithEnhancement)((Object)kotlinType)).getEnhancement();
            object3 = this.unsafeSubstitute(new TypeProjectionImpl(object.getProjectionKind(), (KotlinType)object3), (TypeParameterDescriptor)object2, n + 1);
            if (object3.isStarProjection()) {
                Object object4 = object3;
                if (object4 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(20);
                }
                return object4;
            }
            KotlinType kotlinType3 = this.substitute(kotlinType2, object.getProjectionKind());
            UnwrappedType unwrappedType = TypeWithEnhancementKt.wrapEnhancement(object3.getType().unwrap(), kotlinType3);
            return new TypeProjectionImpl(object3.getProjectionKind(), unwrappedType);
        }
        if (DynamicTypesKt.isDynamic(kotlinType) || kotlinType.unwrap() instanceof RawType) {
            TypeProjection typeProjection = object;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(21);
            }
            return typeProjection;
        }
        Object object5 = this.substitution.get(kotlinType);
        TypeProjection typeProjection = object5 != null ? TypeSubstitutor.projectedTypeForConflictedTypeWithUnsafeVariance(kotlinType, object5, (TypeParameterDescriptor)object2, (TypeProjection)object) : null;
        object5 = object.getProjectionKind();
        if (typeProjection == null && FlexibleTypesKt.isFlexible(kotlinType) && !TypeCapabilitiesKt.isCustomTypeParameter(kotlinType)) {
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(kotlinType);
            TypeProjection typeProjection2 = this.unsafeSubstitute(new TypeProjectionImpl((Variance)((Object)object5), flexibleType.getLowerBound()), (TypeParameterDescriptor)object2, n + 1);
            object2 = this.unsafeSubstitute(new TypeProjectionImpl((Variance)((Object)object5), flexibleType.getUpperBound()), (TypeParameterDescriptor)object2, n + 1);
            Variance variance = typeProjection2.getProjectionKind();
            assert (variance == object2.getProjectionKind() && object5 == Variance.INVARIANT || object5 == variance) : "Unexpected substituted projection kind: " + (Object)((Object)variance) + "; original: " + object5;
            if (typeProjection2.getType() == flexibleType.getLowerBound() && object2.getType() == flexibleType.getUpperBound()) {
                Object object6 = object;
                if (object6 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(22);
                }
                return object6;
            }
            object = KotlinTypeFactory.flexibleType(TypeSubstitutionKt.asSimpleType(typeProjection2.getType()), TypeSubstitutionKt.asSimpleType(object2.getType()));
            return new TypeProjectionImpl(variance, (KotlinType)object);
        }
        if (KotlinBuiltIns.isNothing(kotlinType) || KotlinTypeKt.isError(kotlinType)) {
            TypeProjection typeProjection3 = object;
            if (typeProjection3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(23);
            }
            return typeProjection3;
        }
        if (typeProjection != null) {
            TypeSubstitutor$VarianceConflictType typeSubstitutor$VarianceConflictType = TypeSubstitutor.conflictType((Variance)((Object)object5), typeProjection.getProjectionKind());
            boolean bl = CapturedTypeConstructorKt.isCaptured(kotlinType);
            if (!bl) {
                switch (typeSubstitutor$VarianceConflictType) {
                    case OUT_IN_IN_POSITION: {
                        throw new TypeSubstitutor$SubstitutionException("Out-projection in in-position");
                    }
                    case IN_IN_OUT_POSITION: {
                        return new TypeProjectionImpl(Variance.OUT_VARIANCE, kotlinType.getConstructor().getBuiltIns().getNullableAnyType());
                    }
                }
            }
            CustomTypeParameter customTypeParameter = TypeCapabilitiesKt.getCustomTypeParameter(kotlinType);
            if (typeProjection.isStarProjection()) {
                TypeProjection typeProjection4 = typeProjection;
                if (typeProjection4 == null) {
                    TypeSubstitutor.$$$reportNull$$$0(24);
                }
                return typeProjection4;
            }
            object2 = customTypeParameter != null ? customTypeParameter.substitutionResult(typeProjection.getType()) : TypeUtils.makeNullableIfNeeded(typeProjection.getType(), kotlinType.isMarkedNullable());
            if (!kotlinType.getAnnotations().isEmpty()) {
                object = TypeSubstitutor.filterOutUnsafeVariance(this.substitution.filterAnnotations(kotlinType.getAnnotations()));
                object2 = TypeUtilsKt.replaceAnnotations((KotlinType)object2, new CompositeAnnotations(new Annotations[]{((KotlinType)object2).getAnnotations(), object}));
            }
            object = typeSubstitutor$VarianceConflictType == TypeSubstitutor$VarianceConflictType.NO_CONFLICT ? TypeSubstitutor.combine((Variance)((Object)object5), typeProjection.getProjectionKind()) : object5;
            return new TypeProjectionImpl((Variance)((Object)object), (KotlinType)object2);
        }
        TypeProjection typeProjection5 = this.substituteCompoundType((TypeProjection)object, n);
        if (typeProjection5 == null) {
            TypeSubstitutor.$$$reportNull$$$0(25);
        }
        return typeProjection5;
    }

    private static TypeProjection projectedTypeForConflictedTypeWithUnsafeVariance(KotlinType object, TypeProjection typeProjection, TypeParameterDescriptor object2, TypeProjection object3) {
        if (object == null) {
            TypeSubstitutor.$$$reportNull$$$0(26);
        }
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(27);
        }
        if (object3 == null) {
            TypeSubstitutor.$$$reportNull$$$0(28);
        }
        if (!((KotlinType)object).getAnnotations().hasAnnotation(StandardNames$FqNames.unsafeVariance)) {
            TypeProjection typeProjection2 = typeProjection;
            if (typeProjection2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(29);
            }
            return typeProjection2;
        }
        object = typeProjection.getType().getConstructor();
        if (!(object instanceof NewCapturedTypeConstructor)) {
            TypeProjection typeProjection3 = typeProjection;
            if (typeProjection3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(30);
            }
            return typeProjection3;
        }
        object = (NewCapturedTypeConstructor)object;
        object = ((NewCapturedTypeConstructor)object).getProjection();
        Variance variance = object.getProjectionKind();
        if ((object3 = TypeSubstitutor.conflictType(object3.getProjectionKind(), variance)) == TypeSubstitutor$VarianceConflictType.OUT_IN_IN_POSITION) {
            return new TypeProjectionImpl(object.getType());
        }
        if (object2 == null) {
            TypeProjection typeProjection4 = typeProjection;
            if (typeProjection4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(31);
            }
            return typeProjection4;
        }
        if ((object2 = TypeSubstitutor.conflictType(object2.getVariance(), variance)) == TypeSubstitutor$VarianceConflictType.OUT_IN_IN_POSITION) {
            return new TypeProjectionImpl(object.getType());
        }
        TypeProjection typeProjection5 = typeProjection;
        if (typeProjection5 == null) {
            TypeSubstitutor.$$$reportNull$$$0(32);
        }
        return typeProjection5;
    }

    private static Annotations filterOutUnsafeVariance(Annotations annotations2) {
        if (annotations2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(33);
        }
        if (!annotations2.hasAnnotation(StandardNames$FqNames.unsafeVariance)) {
            Annotations annotations3 = annotations2;
            if (annotations3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(34);
            }
            return annotations3;
        }
        return new FilteredAnnotations(annotations2, new TypeSubstitutor$1());
    }

    private TypeProjection substituteCompoundType(TypeProjection object, int n) {
        KotlinType kotlinType;
        Object object2;
        KotlinType kotlinType2 = object.getType();
        Variance variance = object.getProjectionKind();
        if (kotlinType2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return object;
        }
        object = null;
        SimpleType simpleType2 = SpecialTypesKt.getAbbreviation(kotlinType2);
        if (simpleType2 != null) {
            object2 = this.replaceWithNonApproximatingSubstitution();
            object = ((TypeSubstitutor)object2).substitute(simpleType2, Variance.INVARIANT);
        }
        if ((kotlinType = TypeSubstitutionKt.replace(kotlinType2, (List<? extends TypeProjection>)(object2 = this.substituteTypeArguments(kotlinType2.getConstructor().getParameters(), kotlinType2.getArguments(), n)), this.substitution.filterAnnotations(kotlinType2.getAnnotations()))) instanceof SimpleType && object instanceof SimpleType) {
            kotlinType = SpecialTypesKt.withAbbreviation((SimpleType)kotlinType, (SimpleType)object);
        }
        return new TypeProjectionImpl(variance, kotlinType);
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> list, List<TypeProjection> list2, int n) {
        ArrayList<TypeProjection> arrayList = new ArrayList<TypeProjection>(list.size());
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = list.get(i);
            TypeProjection typeProjection = list2.get(i);
            TypeProjection typeProjection2 = this.unsafeSubstitute(typeProjection, typeParameterDescriptor, n + 1);
            switch (TypeSubstitutor.conflictType(typeParameterDescriptor.getVariance(), typeProjection2.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameterDescriptor.getVariance() == Variance.INVARIANT || typeProjection2.isStarProjection()) break;
                    typeProjection2 = new TypeProjectionImpl(Variance.INVARIANT, typeProjection2.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor);
                }
            }
            if (typeProjection2 != typeProjection) {
                bl = true;
            }
            arrayList.add(typeProjection2);
        }
        if (!bl) {
            return list2;
        }
        return arrayList;
    }

    public static Variance combine(Variance variance, TypeProjection typeProjection) {
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(35);
        }
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(36);
        }
        if (typeProjection.isStarProjection()) {
            Variance variance2 = Variance.OUT_VARIANCE;
            if (variance2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(37);
            }
            return variance2;
        }
        return TypeSubstitutor.combine(variance, typeProjection.getProjectionKind());
    }

    public static Variance combine(Variance variance, Variance variance2) {
        if (variance == null) {
            TypeSubstitutor.$$$reportNull$$$0(38);
        }
        if (variance2 == null) {
            TypeSubstitutor.$$$reportNull$$$0(39);
        }
        if (variance == Variance.INVARIANT) {
            Variance variance3 = variance2;
            if (variance3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(40);
            }
            return variance3;
        }
        if (variance2 == Variance.INVARIANT) {
            Variance variance4 = variance;
            if (variance4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(41);
            }
            return variance4;
        }
        if (variance == variance2) {
            Variance variance5 = variance2;
            if (variance5 == null) {
                TypeSubstitutor.$$$reportNull$$$0(42);
            }
            return variance5;
        }
        throw new AssertionError((Object)("Variance conflict: type parameter variance '" + (Object)((Object)variance) + "' and projection kind '" + (Object)((Object)variance2) + "' cannot be combined"));
    }

    private static TypeSubstitutor$VarianceConflictType conflictType(Variance variance, Variance variance2) {
        if (variance == Variance.IN_VARIANCE && variance2 == Variance.OUT_VARIANCE) {
            return TypeSubstitutor$VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (variance == Variance.OUT_VARIANCE && variance2 == Variance.IN_VARIANCE) {
            return TypeSubstitutor$VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return TypeSubstitutor$VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int n, TypeProjection typeProjection, TypeSubstitution typeSubstitution) {
        if (n > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(typeProjection) + "; substitution: " + TypeSubstitutor.safeToString(typeSubstitution));
        }
    }

    private static String safeToString(Object object) {
        try {
            return object.toString();
        }
        catch (Throwable throwable) {
            object = throwable;
            if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                throw (RuntimeException)object;
            }
            return "[Exception while computing toString(): " + object + "]";
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "howThisTypeIsUsed";
                break;
            }
            case 16: 
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProjection";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProjection";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterVariance";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithNonApproximatingSubstitution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithContravariantApproximatingSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "safeSubstitute";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unsafeSubstitute";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUnsafeVariance";
                break;
            }
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChainedSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "safeSubstitute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithoutApproximation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unsafeSubstitute";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUnsafeVariance";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "combine";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

