/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sqlite.date.DatePrinter;
import org.sqlite.date.FastDatePrinter$CharacterLiteral;
import org.sqlite.date.FastDatePrinter$Iso8601_Rule;
import org.sqlite.date.FastDatePrinter$NumberRule;
import org.sqlite.date.FastDatePrinter$PaddedNumberField;
import org.sqlite.date.FastDatePrinter$Rule;
import org.sqlite.date.FastDatePrinter$StringLiteral;
import org.sqlite.date.FastDatePrinter$TextField;
import org.sqlite.date.FastDatePrinter$TimeZoneDisplayKey;
import org.sqlite.date.FastDatePrinter$TimeZoneNameRule;
import org.sqlite.date.FastDatePrinter$TimeZoneNumberRule;
import org.sqlite.date.FastDatePrinter$TwelveHourField;
import org.sqlite.date.FastDatePrinter$TwentyFourHourField;
import org.sqlite.date.FastDatePrinter$TwoDigitMonthField;
import org.sqlite.date.FastDatePrinter$TwoDigitNumberField;
import org.sqlite.date.FastDatePrinter$TwoDigitYearField;
import org.sqlite.date.FastDatePrinter$UnpaddedMonthField;
import org.sqlite.date.FastDatePrinter$UnpaddedNumberField;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDatePrinter$Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final ConcurrentMap<FastDatePrinter$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDatePrinter$TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDatePrinter$Rule> list;
        List<FastDatePrinter$Rule> list2 = list = this.parsePattern();
        this.mRules = list2.toArray(new FastDatePrinter$Rule[list2.size()]);
        int n = 0;
        int n2 = this.mRules.length;
        while (--n2 >= 0) {
            n += this.mRules[n2].estimateLength();
        }
        this.mMaxLengthEstimate = n;
    }

    protected List<FastDatePrinter$Rule> parsePattern() {
        String[] stringArray = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDatePrinter$Rule> arrayList = new ArrayList<FastDatePrinter$Rule>();
        String[] stringArray2 = stringArray.getEras();
        String[] stringArray3 = stringArray.getMonths();
        String[] stringArray4 = stringArray.getShortMonths();
        String[] stringArray5 = stringArray.getWeekdays();
        String[] stringArray6 = stringArray.getShortWeekdays();
        stringArray = stringArray.getAmPmStrings();
        int n = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            FastDatePrinter fastDatePrinter = this;
            Object object = fastDatePrinter.parseToken(fastDatePrinter.mPattern, nArray);
            i = nArray[0];
            int n2 = ((String)object).length();
            if (n2 == 0) break;
            char c = ((String)object).charAt(0);
            switch (c) {
                case 'G': {
                    object = new FastDatePrinter$TextField(0, stringArray2);
                    break;
                }
                case 'y': {
                    if (n2 == 2) {
                        object = FastDatePrinter$TwoDigitYearField.INSTANCE;
                        break;
                    }
                    object = this.selectNumberRule(1, n2 < 4 ? 4 : n2);
                    break;
                }
                case 'M': {
                    if (n2 >= 4) {
                        object = new FastDatePrinter$TextField(2, stringArray3);
                        break;
                    }
                    if (n2 == 3) {
                        object = new FastDatePrinter$TextField(2, stringArray4);
                        break;
                    }
                    if (n2 == 2) {
                        object = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    object = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    object = this.selectNumberRule(5, n2);
                    break;
                }
                case 'h': {
                    object = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, n2));
                    break;
                }
                case 'H': {
                    object = this.selectNumberRule(11, n2);
                    break;
                }
                case 'm': {
                    object = this.selectNumberRule(12, n2);
                    break;
                }
                case 's': {
                    object = this.selectNumberRule(13, n2);
                    break;
                }
                case 'S': {
                    object = this.selectNumberRule(14, n2);
                    break;
                }
                case 'E': {
                    object = new FastDatePrinter$TextField(7, n2 < 4 ? stringArray6 : stringArray5);
                    break;
                }
                case 'D': {
                    object = this.selectNumberRule(6, n2);
                    break;
                }
                case 'F': {
                    object = this.selectNumberRule(8, n2);
                    break;
                }
                case 'w': {
                    object = this.selectNumberRule(3, n2);
                    break;
                }
                case 'W': {
                    object = this.selectNumberRule(4, n2);
                    break;
                }
                case 'a': {
                    object = new FastDatePrinter$TextField(9, stringArray);
                    break;
                }
                case 'k': {
                    object = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, n2));
                    break;
                }
                case 'K': {
                    object = this.selectNumberRule(10, n2);
                    break;
                }
                case 'X': {
                    object = FastDatePrinter$Iso8601_Rule.getRule(n2);
                    break;
                }
                case 'z': {
                    if (n2 >= 4) {
                        object = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    object = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n2 == 1) {
                        object = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n2 == 2) {
                        object = FastDatePrinter$TimeZoneNumberRule.INSTANCE_ISO_8601;
                        break;
                    }
                    object = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    object = ((String)object).substring(1);
                    if (((String)object).length() == 1) {
                        object = new FastDatePrinter$CharacterLiteral(((String)object).charAt(0));
                        break;
                    }
                    object = new FastDatePrinter$StringLiteral((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + (String)object);
                }
            }
            arrayList.add((FastDatePrinter$Rule)object);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        char c = string.charAt(n);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            stringBuilder.append(c);
            while (n + 1 < n2 && (c2 = string.charAt(n + 1)) == c) {
                stringBuilder.append(c);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c = string.charAt(n);
                if (c == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    stringBuilder.append(c);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuilder.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int n, int n2) {
        switch (n2) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(n);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(n);
            }
        }
        return new FastDatePrinter$PaddedNumberField(n, n2);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    @Override
    public String format(long l) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTimeInMillis(l);
        return this.applyRulesToString(gregorianCalendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    private GregorianCalendar newCalendar() {
        return new GregorianCalendar(this.mTimeZone, this.mLocale);
    }

    @Override
    public String format(Date date) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRulesToString(gregorianCalendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer) {
        return this.format(new Date(l), stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, stringBuffer);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        FastDatePrinter$Rule[] fastDatePrinter$RuleArray = this.mRules;
        int n = this.mRules.length;
        for (int i = 0; i < n; ++i) {
            FastDatePrinter$Rule fastDatePrinter$Rule = fastDatePrinter$RuleArray[i];
            fastDatePrinter$Rule.appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        object = (FastDatePrinter)object;
        return this.mPattern.equals(((FastDatePrinter)object).mPattern) && this.mTimeZone.equals(((FastDatePrinter)object).mTimeZone) && this.mLocale.equals(((FastDatePrinter)object).mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(StringBuffer stringBuffer, int n) {
        stringBuffer.append((char)(n / 10 + 48));
        stringBuffer.append((char)(n % 10 + 48));
    }

    static String getTimeZoneDisplay(TimeZone object, boolean bl, int n, Locale locale) {
        FastDatePrinter$TimeZoneDisplayKey fastDatePrinter$TimeZoneDisplayKey = new FastDatePrinter$TimeZoneDisplayKey((TimeZone)object, bl, n, locale);
        Object object2 = (String)cTimeZoneDisplayCache.get(fastDatePrinter$TimeZoneDisplayKey);
        if (object2 == null && (object = cTimeZoneDisplayCache.putIfAbsent(fastDatePrinter$TimeZoneDisplayKey, (String)(object2 = ((TimeZone)object).getDisplayName(bl, n, locale)))) != null) {
            object2 = object;
        }
        return object2;
    }

    static /* synthetic */ void access$000(StringBuffer stringBuffer, int n) {
        FastDatePrinter.appendDigits(stringBuffer, n);
    }
}

