/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryFinder$1;
import javax.xml.validation.SchemaFactoryFinder$2;
import javax.xml.validation.SecuritySupport;

final class SchemaFactoryFinder {
    private static final String W3C_XML_SCHEMA10_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.0";
    private static final String W3C_XML_SCHEMA11_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;
    static Class class$javax$xml$validation$SchemaFactory;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public SchemaFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (VirtualMachineError virtualMachineError) {
            VirtualMachineError virtualMachineError2 = virtualMachineError;
            throw virtualMachineError;
        }
        catch (ThreadDeath threadDeath) {
            ThreadDeath threadDeath2 = threadDeath;
            throw threadDeath;
        }
        catch (Throwable throwable) {}
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public final SchemaFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SchemaFactory schemaFactory = this._newFactory(string);
        if (debug) {
            if (schemaFactory != null) {
                SchemaFactoryFinder.debugPrintln("factory '" + schemaFactory.getClass().getName() + "' was found for " + string);
            } else {
                SchemaFactoryFinder.debugPrintln("unable to find a factory for " + string);
            }
        }
        return schemaFactory;
    }

    private SchemaFactory _newFactory(String string) {
        Serializable serializable;
        Object object;
        Object object2;
        block31: {
            String string2;
            block30: {
                string2 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    if (debug) {
                        SchemaFactoryFinder.debugPrintln("Looking up system property '" + string2 + "'");
                    }
                    if ((object2 = SecuritySupport.getSystemProperty(string2)) != null && ((String)object2).length() > 0) {
                        if (debug) {
                            SchemaFactoryFinder.debugPrintln("The value is '" + (String)object2 + "'");
                        }
                        if ((object2 = this.createInstance((String)object2)) != null) {
                            return object2;
                        }
                    } else if (debug) {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    VirtualMachineError virtualMachineError2 = virtualMachineError;
                    throw virtualMachineError;
                }
                catch (ThreadDeath threadDeath) {
                    ThreadDeath threadDeath2 = threadDeath;
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    if (!debug) break block30;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + string2 + "'");
                    throwable.printStackTrace();
                }
            }
            object2 = SecuritySupport.getSystemProperty("java.home");
            object2 = (String)object2 + File.separator + "lib" + File.separator + "jaxp.properties";
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable = new File((String)object2);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)serializable)) {
                                if (debug) {
                                    SchemaFactoryFinder.debugPrintln("Read properties file " + serializable);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)serializable));
                            }
                        }
                    }
                }
                object2 = cacheProps.getProperty(string2);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("found " + (String)object2 + " in $java.home/jaxp.properties");
                }
                if (object2 != null && (object2 = this.createInstance((String)object2)) != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                if (!debug) break block31;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable = (URL)object.next();
            if (debug) {
                SchemaFactoryFinder.debugPrintln("looking into " + serializable);
            }
            try {
                object2 = this.loadFromServicesFile(string, ((URL)serializable).toExternalForm(), SecuritySupport.getURLInputStream((URL)serializable));
                if (object2 == null) continue;
                return object2;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + serializable);
                iOException.printStackTrace();
            }
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals(W3C_XML_SCHEMA10_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.0 validator");
            }
            return this.createInstance("org.apache.xerces.jaxp.validation.XMLSchemaFactory");
        }
        if (string.equals(W3C_XML_SCHEMA11_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.1 validator");
            }
            return this.createInstance("org.apache.xerces.jaxp.validation.XMLSchema11Factory");
        }
        if (debug) {
            SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    final SchemaFactory createInstance(String string) {
        block8: {
            try {
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("instanciating " + string);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string) : Class.forName(string);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("loaded it from " + SchemaFactoryFinder.which(clazz));
                }
                if ((clazz = clazz.newInstance()) instanceof SchemaFactory) {
                    return (SchemaFactory)((Object)clazz);
                }
                if (debug) {
                    SchemaFactoryFinder.debugPrintln(string + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                VirtualMachineError virtualMachineError2 = virtualMachineError;
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                ThreadDeath threadDeath2 = threadDeath;
                throw threadDeath;
            }
            catch (Throwable throwable) {
                SchemaFactoryFinder.debugPrintln("failed to instanciate " + string);
                if (!debug) break block8;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SchemaFactoryFinder$1(this);
        }
        try {
            Enumeration enumeration = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !enumeration.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new SchemaFactoryFinder$2(this, enumeration);
        }
        catch (IOException iOException) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                iOException.printStackTrace();
            }
            return ((AbstractList)new ArrayList()).iterator();
        }
    }

    private SchemaFactory loadFromServicesFile(String string, String object, InputStream object2) {
        if (debug) {
            SchemaFactoryFinder.debugPrintln("Reading " + (String)object);
        }
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader((InputStream)object2), 80);
        }
        Object object3 = null;
        while (true) {
            try {
                object2 = ((BufferedReader)object).readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (object2 == null) break;
            int n = ((String)object2).indexOf(35);
            if (n != -1) {
                object2 = ((String)object2).substring(0, n);
            }
            if (((String)(object2 = ((String)object2).trim())).length() == 0) continue;
            try {
                if (!((SchemaFactory)(object2 = this.createInstance((String)object2))).isSchemaLanguageSupported(string)) continue;
                object3 = object2;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        try {
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {}
        return object3;
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String object, ClassLoader classLoader) {
        object = ((String)object).replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((object = SecuritySupport.getResourceAsURL(classLoader, (String)object)) != null) {
            return ((URL)object).toString();
        }
        return null;
    }

    static String access$100() {
        return SERVICE_ID;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = class$javax$xml$validation$SchemaFactory == null ? (class$javax$xml$validation$SchemaFactory = SchemaFactoryFinder.class$("javax.xml.validation.SchemaFactory")) : class$javax$xml$validation$SchemaFactory;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }
}

