/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cff.CFFCharset;

class CFFCharsetCID
implements CFFCharset {
    private static final String EXCEPTION_MESSAGE = "Not a Type 1-equivalent font";
    private final Map<Integer, Integer> sidOrCidToGid = new HashMap<Integer, Integer>(250);
    private final Map<Integer, Integer> gidToCid = new HashMap<Integer, Integer>();

    CFFCharsetCID() {
    }

    @Override
    public boolean isCIDFont() {
        return true;
    }

    @Override
    public void addSID(int n, int n2, String string) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public void addCID(int n, int n2) {
        this.sidOrCidToGid.put(n2, n);
        this.gidToCid.put(n, n2);
    }

    @Override
    public int getSIDForGID(int n) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getGIDForSID(int n) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getGIDForCID(int n) {
        Integer n2 = this.sidOrCidToGid.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    @Override
    public int getSID(String string) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public String getNameForGID(int n) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getCIDForGID(int n) {
        Integer n2 = this.gidToCid.get(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }
}

