/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.GlyphDescription;
import org.apache.fontbox.ttf.GlyphRenderer$Point;

class GlyphRenderer {
    private static final Log LOG = LogFactory.getLog(GlyphRenderer.class);
    private final GlyphDescription glyphDescription;

    GlyphRenderer(GlyphDescription glyphDescription) {
        this.glyphDescription = glyphDescription;
    }

    public GeneralPath getPath() {
        GlyphRenderer glyphRenderer = this;
        GlyphRenderer$Point[] glyphRenderer$PointArray = glyphRenderer.describe(glyphRenderer.glyphDescription);
        return this.calculatePath(glyphRenderer$PointArray);
    }

    private GlyphRenderer$Point[] describe(GlyphDescription glyphDescription) {
        int n = 0;
        int n2 = -1;
        GlyphRenderer$Point[] glyphRenderer$PointArray = new GlyphRenderer$Point[glyphDescription.getPointCount()];
        for (int i = 0; i < glyphRenderer$PointArray.length; ++i) {
            boolean bl;
            if (n2 == -1) {
                n2 = glyphDescription.getEndPtOfContours(n);
            }
            if (bl = n2 == i) {
                ++n;
                n2 = -1;
            }
            glyphRenderer$PointArray[i] = new GlyphRenderer$Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        return glyphRenderer$PointArray;
    }

    private GeneralPath calculatePath(GlyphRenderer$Point[] glyphRenderer$PointArray) {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        int n2 = glyphRenderer$PointArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!GlyphRenderer$Point.access$000(glyphRenderer$PointArray[i])) continue;
            GlyphRenderer$Point glyphRenderer$Point = glyphRenderer$PointArray[n];
            GlyphRenderer$Point glyphRenderer$Point2 = glyphRenderer$PointArray[i];
            ArrayList<GlyphRenderer$Point> arrayList = new ArrayList<GlyphRenderer$Point>();
            for (n3 = n; n3 <= i; ++n3) {
                arrayList.add(glyphRenderer$PointArray[n3]);
            }
            if (GlyphRenderer$Point.access$100(glyphRenderer$PointArray[n])) {
                arrayList.add(glyphRenderer$Point);
            } else if (GlyphRenderer$Point.access$100(glyphRenderer$PointArray[i])) {
                arrayList.add(0, glyphRenderer$Point2);
            } else {
                GlyphRenderer$Point glyphRenderer$Point3 = this.midValue(glyphRenderer$Point, glyphRenderer$Point2);
                arrayList.add(0, glyphRenderer$Point3);
                arrayList.add(glyphRenderer$Point3);
            }
            this.moveTo(generalPath, (GlyphRenderer$Point)arrayList.get(0));
            n = arrayList.size();
            for (n3 = 1; n3 < n; ++n3) {
                glyphRenderer$Point = (GlyphRenderer$Point)arrayList.get(n3);
                if (GlyphRenderer$Point.access$100(glyphRenderer$Point)) {
                    this.lineTo(generalPath, glyphRenderer$Point);
                    continue;
                }
                if (GlyphRenderer$Point.access$100((GlyphRenderer$Point)arrayList.get(n3 + 1))) {
                    this.quadTo(generalPath, glyphRenderer$Point, (GlyphRenderer$Point)arrayList.get(n3 + 1));
                    ++n3;
                    continue;
                }
                this.quadTo(generalPath, glyphRenderer$Point, this.midValue(glyphRenderer$Point, (GlyphRenderer$Point)arrayList.get(n3 + 1)));
            }
            generalPath.closePath();
            n = i + 1;
        }
        return generalPath;
    }

    private void moveTo(GeneralPath generalPath, GlyphRenderer$Point glyphRenderer$Point) {
        generalPath.moveTo(GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("moveTo: " + String.format(Locale.US, "%d,%d", GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point))));
        }
    }

    private void lineTo(GeneralPath generalPath, GlyphRenderer$Point glyphRenderer$Point) {
        generalPath.lineTo(GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("lineTo: " + String.format(Locale.US, "%d,%d", GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point))));
        }
    }

    private void quadTo(GeneralPath generalPath, GlyphRenderer$Point glyphRenderer$Point, GlyphRenderer$Point glyphRenderer$Point2) {
        generalPath.quadTo(GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point), GlyphRenderer$Point.access$200(glyphRenderer$Point2), GlyphRenderer$Point.access$300(glyphRenderer$Point2));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("quadTo: " + String.format(Locale.US, "%d,%d %d,%d", GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point), GlyphRenderer$Point.access$200(glyphRenderer$Point2), GlyphRenderer$Point.access$300(glyphRenderer$Point2))));
        }
    }

    private int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private GlyphRenderer$Point midValue(GlyphRenderer$Point glyphRenderer$Point, GlyphRenderer$Point glyphRenderer$Point2) {
        return new GlyphRenderer$Point(this.midValue(GlyphRenderer$Point.access$200(glyphRenderer$Point), GlyphRenderer$Point.access$200(glyphRenderer$Point2)), this.midValue(GlyphRenderer$Point.access$300(glyphRenderer$Point), GlyphRenderer$Point.access$300(glyphRenderer$Point2)));
    }
}

