/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.gsub.GlyphSubstitutionDataExtractor;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.table.common.CoverageTable;
import org.apache.fontbox.ttf.table.common.CoverageTableFormat1;
import org.apache.fontbox.ttf.table.common.CoverageTableFormat2;
import org.apache.fontbox.ttf.table.common.FeatureListTable;
import org.apache.fontbox.ttf.table.common.FeatureRecord;
import org.apache.fontbox.ttf.table.common.FeatureTable;
import org.apache.fontbox.ttf.table.common.LangSysTable;
import org.apache.fontbox.ttf.table.common.LookupListTable;
import org.apache.fontbox.ttf.table.common.LookupSubTable;
import org.apache.fontbox.ttf.table.common.LookupTable;
import org.apache.fontbox.ttf.table.common.RangeRecord;
import org.apache.fontbox.ttf.table.common.ScriptTable;
import org.apache.fontbox.ttf.table.gsub.LigatureSetTable;
import org.apache.fontbox.ttf.table.gsub.LigatureTable;
import org.apache.fontbox.ttf.table.gsub.LookupTypeLigatureSubstitutionSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeMultipleSubstitutionFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat2;
import org.apache.fontbox.ttf.table.gsub.SequenceTable;

public class GlyphSubstitutionTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(GlyphSubstitutionTable.class);
    public static final String TAG = "GSUB";
    private Map<String, ScriptTable> scriptList;
    private FeatureListTable featureListTable;
    private LookupListTable lookupListTable;
    private final Map<Integer, Integer> lookupCache = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> reverseLookup = new HashMap<Integer, Integer>();
    private String lastUsedSupportedScript;
    private GsubData gsubData;

    GlyphSubstitutionTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        long l = tTFDataStream.getCurrentPosition();
        tTFDataStream.readUnsignedShort();
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int n4 = tTFDataStream.readUnsignedShort();
        if ((long)n == 1L) {
            tTFDataStream.readUnsignedInt();
        }
        this.scriptList = this.readScriptList(tTFDataStream, l + (long)n2);
        this.featureListTable = this.readFeatureList(tTFDataStream, l + (long)n3);
        this.lookupListTable = this.readLookupList(tTFDataStream, l + (long)n4);
        GlyphSubstitutionDataExtractor glyphSubstitutionDataExtractor = new GlyphSubstitutionDataExtractor();
        this.gsubData = glyphSubstitutionDataExtractor.getGsubData(this.scriptList, this.featureListTable, this.lookupListTable);
        this.initialized = true;
    }

    private Map<String, ScriptTable> readScriptList(TTFDataStream tTFDataStream, long l) {
        int n;
        tTFDataStream.seek(l);
        int n2 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        LinkedHashMap<String, ScriptTable> linkedHashMap = new LinkedHashMap<String, ScriptTable>(n2);
        for (n = 0; n < n2; ++n) {
            stringArray[n] = tTFDataStream.readString(4);
            nArray[n] = tTFDataStream.readUnsignedShort();
        }
        for (n = 0; n < n2; ++n) {
            ScriptTable scriptTable = this.readScriptTable(tTFDataStream, l + (long)nArray[n]);
            linkedHashMap.put(stringArray[n], scriptTable);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private ScriptTable readScriptTable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = tTFDataStream.readString(4);
            if (i > 0 && stringArray[i].compareTo(stringArray[i - 1]) <= 0) {
                LOG.error((Object)("LangSysRecords not alphabetically sorted by LangSys tag: " + stringArray[i] + " <= " + stringArray[i - 1]));
                return new ScriptTable(null, new LinkedHashMap<String, LangSysTable>());
            }
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        LangSysTable langSysTable = null;
        if (n != 0) {
            langSysTable = this.readLangSysTable(tTFDataStream, l + (long)n);
        }
        LinkedHashMap<String, LangSysTable> linkedHashMap = new LinkedHashMap<String, LangSysTable>(n2);
        for (int i = 0; i < n2; ++i) {
            LangSysTable langSysTable2 = this.readLangSysTable(tTFDataStream, l + (long)nArray[i]);
            linkedHashMap.put(stringArray[i], langSysTable2);
        }
        return new ScriptTable(langSysTable, Collections.unmodifiableMap(linkedHashMap));
    }

    private LangSysTable readLangSysTable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        return new LangSysTable(n, n2, n3, nArray);
    }

    private FeatureListTable readFeatureList(TTFDataStream tTFDataStream, long l) {
        int n;
        tTFDataStream.seek(l);
        int n2 = tTFDataStream.readUnsignedShort();
        FeatureRecord[] featureRecordArray = new FeatureRecord[n2];
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = tTFDataStream.readString(4);
            if (n > 0 && stringArray[n].compareTo(stringArray[n - 1]) < 0) {
                if (stringArray[n].matches("\\w{4}") && stringArray[n - 1].matches("\\w{4}")) {
                    LOG.debug((Object)("FeatureRecord array not alphabetically sorted by FeatureTag: " + stringArray[n] + " < " + stringArray[n - 1]));
                } else {
                    LOG.warn((Object)("FeatureRecord array not alphabetically sorted by FeatureTag: " + stringArray[n] + " < " + stringArray[n - 1]));
                    return new FeatureListTable(0, new FeatureRecord[0]);
                }
            }
            nArray[n] = tTFDataStream.readUnsignedShort();
        }
        for (n = 0; n < n2; ++n) {
            FeatureTable featureTable = this.readFeatureTable(tTFDataStream, l + (long)nArray[n]);
            featureRecordArray[n] = new FeatureRecord(stringArray[n], featureTable);
        }
        return new FeatureListTable(n2, featureRecordArray);
    }

    private FeatureTable readFeatureTable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        return new FeatureTable(n, n2, nArray);
    }

    private LookupListTable readLookupList(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        LookupTable[] lookupTableArray = new LookupTable[n];
        for (int i = 0; i < n; ++i) {
            lookupTableArray[i] = this.readLookupTable(tTFDataStream, l + (long)nArray[i]);
        }
        return new LookupListTable(n, lookupTableArray);
    }

    private LookupSubTable readLookupSubtable(TTFDataStream tTFDataStream, long l, int n) {
        switch (n) {
            case 1: {
                return this.readSingleLookupSubTable(tTFDataStream, l);
            }
            case 2: {
                return this.readMultipleSubstitutionSubtable(tTFDataStream, l);
            }
            case 4: {
                return this.readLigatureSubstitutionSubtable(tTFDataStream, l);
            }
        }
        LOG.debug((Object)("Type " + n + " GSUB lookup table is not supported and will be ignored"));
        return null;
    }

    private LookupTable readLookupTable(TTFDataStream tTFDataStream, long l) {
        int n;
        tTFDataStream.seek(l);
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int n4 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = tTFDataStream.readUnsignedShort();
        }
        n = (n3 & 0x10) != 0 ? tTFDataStream.readUnsignedShort() : 0;
        LookupSubTable[] lookupSubTableArray = new LookupSubTable[n4];
        switch (n2) {
            case 1: 
            case 2: 
            case 4: {
                for (int i = 0; i < n4; ++i) {
                    lookupSubTableArray[i] = this.readLookupSubtable(tTFDataStream, l + (long)nArray[i], n2);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n4; ++i) {
                    long l2 = tTFDataStream.getCurrentPosition();
                    int n5 = tTFDataStream.readUnsignedShort();
                    if (n5 != 1) {
                        LOG.error((Object)("The expected SubstFormat for ExtensionSubstFormat1 subtable is " + n5 + " but should be 1"));
                        continue;
                    }
                    n5 = tTFDataStream.readUnsignedShort();
                    long l3 = tTFDataStream.readUnsignedInt();
                    lookupSubTableArray[i] = this.readLookupSubtable(tTFDataStream, l2 + l3, n5);
                }
                break;
            }
            default: {
                LOG.debug((Object)("Type " + n2 + " GSUB lookup table is not supported and will be ignored"));
            }
        }
        return new LookupTable(n2, n3, n, lookupSubTableArray);
    }

    private LookupSubTable readSingleLookupSubTable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        switch (n) {
            case 1: {
                int n2 = tTFDataStream.readUnsignedShort();
                short s = tTFDataStream.readSignedShort();
                CoverageTable coverageTable = this.readCoverageTable(tTFDataStream, l + (long)n2);
                return new LookupTypeSingleSubstFormat1(n, coverageTable, s);
            }
            case 2: {
                int n3 = tTFDataStream.readUnsignedShort();
                int n4 = tTFDataStream.readUnsignedShort();
                int[] nArray = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = tTFDataStream.readUnsignedShort();
                }
                CoverageTable coverageTable = this.readCoverageTable(tTFDataStream, l + (long)n3);
                return new LookupTypeSingleSubstFormat2(n, coverageTable, nArray);
            }
        }
        LOG.warn((Object)("Unknown substFormat: " + n));
        return null;
    }

    private LookupSubTable readMultipleSubstitutionSubtable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        if (n != 1) {
            throw new IOException("The expected SubstFormat for LigatureSubstitutionTable is 1");
        }
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        CoverageTable coverageTable = this.readCoverageTable(tTFDataStream, l + (long)n2);
        if (n3 != coverageTable.getSize()) {
            throw new IOException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of SequenceTables");
        }
        SequenceTable[] sequenceTableArray = new SequenceTable[n3];
        for (int i = 0; i < n3; ++i) {
            tTFDataStream.seek(l + (long)nArray[i]);
            int n4 = tTFDataStream.readUnsignedShort();
            for (int j = 0; j < n4; ++j) {
                int[] nArray2 = tTFDataStream.readUnsignedShortArray(n4);
                sequenceTableArray[i] = new SequenceTable(n4, nArray2);
            }
        }
        return new LookupTypeMultipleSubstitutionFormat1(n, coverageTable, sequenceTableArray);
    }

    private LookupSubTable readLigatureSubstitutionSubtable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        if (n != 1) {
            throw new IOException("The expected SubstFormat for LigatureSubstitutionTable is 1");
        }
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
        }
        CoverageTable coverageTable = this.readCoverageTable(tTFDataStream, l + (long)n2);
        if (n3 != coverageTable.getSize()) {
            throw new IOException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of LigatureSetTables");
        }
        LigatureSetTable[] ligatureSetTableArray = new LigatureSetTable[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = coverageTable.getGlyphId(i);
            ligatureSetTableArray[i] = this.readLigatureSetTable(tTFDataStream, l + (long)nArray[i], n4);
        }
        return new LookupTypeLigatureSubstitutionSubstFormat1(n, coverageTable, ligatureSetTableArray);
    }

    private LigatureSetTable readLigatureSetTable(TTFDataStream tTFDataStream, long l, int n) {
        int n2;
        tTFDataStream.seek(l);
        int n3 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n3];
        LigatureTable[] ligatureTableArray = new LigatureTable[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = tTFDataStream.readUnsignedShort();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = nArray[n2];
            ligatureTableArray[n2] = this.readLigatureTable(tTFDataStream, l + (long)n4, n);
        }
        return new LigatureSetTable(n3, ligatureTableArray);
    }

    private LigatureTable readLigatureTable(TTFDataStream tTFDataStream, long l, int n) {
        tTFDataStream.seek(l);
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        int[] nArray = new int[n3];
        if (n3 > 0) {
            nArray[0] = n;
        }
        for (n = 1; n <= n3 - 1; ++n) {
            nArray[n] = tTFDataStream.readUnsignedShort();
        }
        return new LigatureTable(n2, n3, nArray);
    }

    private CoverageTable readCoverageTable(TTFDataStream tTFDataStream, long l) {
        tTFDataStream.seek(l);
        int n = tTFDataStream.readUnsignedShort();
        switch (n) {
            case 1: {
                int n2 = tTFDataStream.readUnsignedShort();
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = tTFDataStream.readUnsignedShort();
                }
                return new CoverageTableFormat1(n, nArray);
            }
            case 2: {
                int n3 = tTFDataStream.readUnsignedShort();
                RangeRecord[] rangeRecordArray = new RangeRecord[n3];
                for (int i = 0; i < n3; ++i) {
                    rangeRecordArray[i] = this.readRangeRecord(tTFDataStream);
                }
                return new CoverageTableFormat2(n, rangeRecordArray);
            }
        }
        throw new IOException("Unknown coverage format: " + n);
    }

    private String selectScriptTag(String[] stringArray) {
        Object object;
        if (stringArray.length == 1 && ("Inherited".equals(object = stringArray[0]) || "DFLT".equals(object) && !this.scriptList.containsKey(object))) {
            if (this.lastUsedSupportedScript == null) {
                this.lastUsedSupportedScript = this.scriptList.keySet().iterator().next();
            }
            return this.lastUsedSupportedScript;
        }
        object = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = object[i];
            if (!this.scriptList.containsKey(string)) continue;
            this.lastUsedSupportedScript = string;
            return this.lastUsedSupportedScript;
        }
        return stringArray[0];
    }

    private Collection<LangSysTable> getLangSysTables(String object) {
        Collection<LangSysTable> collection = Collections.emptyList();
        if ((object = this.scriptList.get(object)) != null) {
            if (((ScriptTable)object).getDefaultLangSysTable() == null) {
                collection = ((ScriptTable)object).getLangSysTables().values();
            } else {
                collection = new ArrayList<LangSysTable>(((ScriptTable)object).getLangSysTables().values());
                collection.add(((ScriptTable)object).getDefaultLangSysTable());
            }
        }
        return collection;
    }

    private List<FeatureRecord> getFeatureRecords(Collection<LangSysTable> collection, List<String> list) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeatureRecord> arrayList = new ArrayList<FeatureRecord>();
        collection.forEach(object -> {
            int n = ((LangSysTable)object).getRequiredFeatureIndex();
            FeatureRecord[] featureRecordArray = this.featureListTable.getFeatureRecords();
            if (n != 65535 && n < featureRecordArray.length) {
                arrayList.add(featureRecordArray[n]);
            }
            int[] nArray = ((LangSysTable)object).getFeatureIndices();
            object = nArray;
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (object2 >= featureRecordArray.length || list != null && !list.contains(featureRecordArray[object2].getFeatureTag())) continue;
                arrayList.add(featureRecordArray[object2]);
            }
        });
        if (this.containsFeature(arrayList, "vrt2")) {
            this.removeFeature(arrayList, "vert");
        }
        if (list != null && arrayList.size() > 1) {
            arrayList.sort((featureRecord, featureRecord2) -> Integer.compare(list.indexOf(featureRecord.getFeatureTag()), list.indexOf(featureRecord2.getFeatureTag())));
        }
        return arrayList;
    }

    private boolean containsFeature(List<FeatureRecord> list, String string) {
        return list.stream().anyMatch(featureRecord -> featureRecord.getFeatureTag().equals(string));
    }

    private void removeFeature(List<FeatureRecord> object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!((FeatureRecord)object.next()).getFeatureTag().equals(string)) continue;
            object.remove();
        }
    }

    private int applyFeature(FeatureRecord featureRecord, int n) {
        for (int n2 : featureRecord.getFeatureTable().getLookupListIndices()) {
            LookupTable lookupTable = this.lookupListTable.getLookups()[n2];
            if (lookupTable.getLookupType() != 1) {
                LOG.warn((Object)("Skipping GSUB feature '" + featureRecord.getFeatureTag() + "' because it requires unsupported lookup table type " + lookupTable.getLookupType()));
                continue;
            }
            n = this.doLookup(lookupTable, n);
        }
        return n;
    }

    private int doLookup(LookupTable lookupSubTableArray, int n) {
        for (LookupSubTable lookupSubTable : lookupSubTableArray.getSubTables()) {
            int n2 = lookupSubTable.getCoverageTable().getCoverageIndex(n);
            if (n2 < 0) continue;
            return lookupSubTable.doSubstitution(n, n2);
        }
        return n;
    }

    public int getSubstitution(int n, String[] object, List<String> list) {
        if (n == -1) {
            return -1;
        }
        Object object2 = this.lookupCache.get(n);
        if (object2 != null) {
            return (Integer)object2;
        }
        object = this.selectScriptTag((String[])object);
        object = this.getLangSysTables((String)object);
        object = this.getFeatureRecords((Collection<LangSysTable>)object, list);
        int n2 = n;
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (FeatureRecord)object.next();
            n2 = this.applyFeature((FeatureRecord)object2, n2);
        }
        this.lookupCache.put(n, n2);
        this.reverseLookup.put(n2, n);
        return n2;
    }

    public int getUnsubstitution(int n) {
        Integer n2 = this.reverseLookup.get(n);
        if (n2 == null) {
            LOG.warn((Object)("Trying to un-substitute a never-before-seen gid: " + n));
            return n;
        }
        return n2;
    }

    public GsubData getGsubData() {
        return this.gsubData;
    }

    public GsubData getGsubData(String string) {
        ScriptTable scriptTable = this.scriptList.get(string);
        if (scriptTable == null) {
            return null;
        }
        return new GlyphSubstitutionDataExtractor().getGsubData(string, scriptTable, this.featureListTable, this.lookupListTable);
    }

    public Set<String> getSupportedScriptTags() {
        return Collections.unmodifiableSet(this.scriptList.keySet());
    }

    private RangeRecord readRangeRecord(TTFDataStream tTFDataStream) {
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        return new RangeRecord(n, n2, n3);
    }
}

